package org.apache.flex.forks.velocity.runtime.parser.node;

/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 *  Modified by Adobe Flex.
 */

import java.io.Writer;
import java.io.IOException;

import org.apache.flex.forks.velocity.context.InternalContextAdapter;
import org.apache.flex.forks.velocity.runtime.parser.Parser;
import org.apache.flex.forks.velocity.runtime.parser.Token;

public class ASTText extends SimpleNode
{
    private String text;

    public ASTText(int id)
    {
        super(id);
    }

    public ASTText(Parser p, int id)
    {
        super(p, id);
    }

    /** Accept the visitor. **/
    public Object jjtAccept(ParserVisitor visitor, Object data)
    {
        return visitor.visit(this, data);
    }

    public void jjtOpen()
    {
    	text = NodeUtils.tokenLiteral(parser.getToken(1));
    }
    
    public Object init( InternalContextAdapter context, Object data) 
        throws Exception
    {
        return data;
    }

    public boolean render( InternalContextAdapter context, Writer writer)
        throws IOException
    {
        writer.write(text);
        return true;
    }    
}







