/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.annotations;

import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.metadata.Element;

public class PolicyDependency
extends OSGiTestCase {
    private Element[] deps;
    private IPOJOHelper helper;

    public void setUp() {
        this.helper = new IPOJOHelper((OSGiTestCase)this);
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.PolicyDependency");
        this.deps = meta.getElements("requires");
    }

    public void testField() {
        Element dep = this.getDependencyById(this.deps, "fs");
        String opt = dep.getAttribute("policy");
        PolicyDependency.assertEquals((String)"Check policy", (String)"static", (String)opt);
    }

    public void testFieldDPpolicy() {
        Element dep = this.getDependencyById(this.deps, "fs2");
        String opt = dep.getAttribute("policy");
        PolicyDependency.assertEquals((String)"Check policy", (String)"dynamic-priority", (String)opt);
    }

    public void testCallbackBind() {
        Element dep = this.getDependencyById(this.deps, "Bar");
        String opt = dep.getAttribute("policy");
        PolicyDependency.assertEquals((String)"Check policy", (String)"static", (String)opt);
    }

    public void testCallbackUnbind() {
        Element dep = this.getDependencyById(this.deps, "Baz");
        String opt = dep.getAttribute("policy");
        PolicyDependency.assertEquals((String)"Check policy", (String)"static", (String)opt);
    }

    public void testBoth() {
        Element dep = this.getDependencyById(this.deps, "inv");
        String opt = dep.getAttribute("policy");
        PolicyDependency.assertEquals((String)"Check policy", (String)"static", (String)opt);
    }

    public void testBindOnly() {
        Element dep = this.getDependencyById(this.deps, "bindonly");
        String opt = dep.getAttribute("policy");
        PolicyDependency.assertEquals((String)"Check policy", (String)"static", (String)opt);
    }

    public void testUnbindOnly() {
        Element dep = this.getDependencyById(this.deps, "unbindonly");
        String opt = dep.getAttribute("policy");
        PolicyDependency.assertEquals((String)"Check policy", (String)"static", (String)opt);
    }

    private Element getDependencyById(Element[] deps, String name) {
        int i = 0;
        while (i < deps.length) {
            String na = deps[i].getAttribute("id");
            String field = deps[i].getAttribute("field");
            if (na != null && na.equalsIgnoreCase(name)) {
                return deps[i];
            }
            if (field != null && field.equalsIgnoreCase(name)) {
                return deps[i];
            }
            ++i;
        }
        PolicyDependency.fail((String)("Dependency  " + name + " not found"));
        return null;
    }
}

