/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.junit;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.build.ProjectTester;
import aQute.bnd.plugin.Activator;
import aQute.bnd.service.EclipseJUnitTester;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;

public class OSGiJUnitLauncherConfigurationDelegate
extends JUnitLaunchConfigurationDelegate {
    private ProjectTester tester;

    private ProjectTester getTester(ILaunchConfiguration configuration) throws CoreException {
        try {
            if (this.tester == null) {
                IJavaProject javaProject = this.getJavaProject(configuration);
                Project project = Activator.getDefault().getCentral().getModel(javaProject);
                project.clear();
                this.tester = project.getProjectTester();
                if (this.tester == null) {
                    throw new IllegalArgumentException("Launching " + project + ". Cannot determine launcher configuration from -runpath: " + project.getProperty("-runpath"));
                }
            }
            return this.tester;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "aQute.bmaker", "Failed to obtain launcher", (Throwable)e));
        }
    }

    public String verifyMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return this.getTester(configuration).getProjectLauncher().getMainTypeName();
    }

    protected void collectExecutionArguments(ILaunchConfiguration configuration, List vmArguments, List programArguments) throws CoreException {
        try {
            super.collectExecutionArguments(configuration, vmArguments, programArguments);
            ProjectTester tester = this.getTester(configuration);
            ProjectLauncher launcher = tester.getProjectLauncher();
            int port = -1;
            int i = 0;
            while (i < programArguments.size()) {
                if (programArguments.get(i).equals("-port")) {
                    port = Integer.parseInt((String)programArguments.get(++i));
                } else if (programArguments.get(i).equals("-testNameFile")) {
                    File testNameFile = tester.getProject().getFile((String)programArguments.get(++i));
                    this.processFile(tester, testNameFile);
                } else if (programArguments.get(i).equals("-test")) {
                    tester.addTest((String)programArguments.get(++i));
                } else if (programArguments.get(i).equals("-classNames")) {
                    tester.addTest((String)programArguments.get(++i));
                }
                ++i;
            }
            if (tester instanceof EclipseJUnitTester) {
                EclipseJUnitTester etester = (EclipseJUnitTester)((Object)tester);
                etester.setPort(port);
            }
            programArguments.addAll(launcher.getArguments());
            vmArguments.addAll(launcher.getRunVM());
            if (configuration.getAttribute("aQute.bmaker.CLEARCACHE", false)) {
                programArguments.add("-keep");
            }
            if (tester.getProject().isOk()) {
                tester.prepare();
                return;
            }
            String args = vmArguments + " " + programArguments + " " + Arrays.toString(this.getClasspath(configuration));
            Activator.getDefault().report(true, false, tester.getProject(), "Launching " + tester.getProject(), args);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "aQute.bmaker", "Building arguments for remote VM", (Throwable)e));
        }
        throw new CoreException((IStatus)new Status(4, "aQute.bmaker", "Building arguments for remote VM"));
    }

    private void processFile(ProjectTester tester, File file) throws IOException {
        FileReader rdr = new FileReader(file);
        BufferedReader brdr = new BufferedReader(rdr);
        String line = brdr.readLine();
        while (line != null) {
            tester.addTest(line.trim());
            line = brdr.readLine();
        }
        rdr.close();
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        return this.getTester(configuration).getProjectLauncher().getClasspath().toArray(new String[0]);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            super.launch(configuration, mode, launch, monitor);
        }
        finally {
            this.tester = null;
        }
    }
}

