/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.jaas.config.impl;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.felix.karaf.jaas.config.KeystoreInstance;
import org.apache.felix.karaf.jaas.config.KeystoreIsLocked;
import org.apache.felix.karaf.jaas.config.KeystoreManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiKeystoreManager
implements KeystoreManager {
    private List<KeystoreInstance> keystores = new CopyOnWriteArrayList<KeystoreInstance>();

    public void register(KeystoreInstance keystore, Map<String, ?> properties) {
        this.keystores.add(keystore);
    }

    public void unregister(KeystoreInstance keystore, Map<String, ?> properties) {
        this.keystores.remove(keystore);
    }

    @Override
    public KeystoreInstance getKeystore(String name) {
        KeystoreInstance keystore = null;
        for (KeystoreInstance ks : this.keystores) {
            if (!ks.getName().equals(name) || keystore != null && keystore.getRank() >= ks.getRank()) continue;
            keystore = ks;
        }
        return keystore;
    }

    @Override
    public SSLContext createSSLContext(String provider, String protocol, String algorithm, String keyStore, String keyAlias, String trustStore) throws GeneralSecurityException {
        KeystoreInstance trustInstance;
        KeystoreInstance keyInstance = this.getKeystore(keyStore);
        if (keyInstance != null && keyInstance.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + keyStore + "' is locked");
        }
        if (keyInstance != null && keyInstance.isKeyLocked(keyAlias)) {
            throw new KeystoreIsLocked("Key '" + keyAlias + "' in keystore '" + keyStore + "' is locked");
        }
        KeystoreInstance keystoreInstance = trustInstance = trustStore == null ? null : this.getKeystore(trustStore);
        if (trustInstance != null && trustInstance.isKeystoreLocked()) {
            throw new KeystoreIsLocked("Keystore '" + trustStore + "' is locked");
        }
        SSLContext context = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
        context.init(keyInstance == null ? null : keyInstance.getKeyManager(algorithm, keyAlias), trustInstance == null ? null : trustInstance.getTrustManager(algorithm), new SecureRandom());
        return context;
    }

    @Override
    public SSLServerSocketFactory createSSLServerFactory(String provider, String protocol, String algorithm, String keyStore, String keyAlias, String trustStore) throws GeneralSecurityException {
        SSLContext context = this.createSSLContext(provider, protocol, algorithm, keyStore, keyAlias, trustStore);
        return context.getServerSocketFactory();
    }

    @Override
    public SSLSocketFactory createSSLFactory(String provider, String protocol, String algorithm, String keyStore, String keyAlias, String trustStore) throws GeneralSecurityException {
        SSLContext context = this.createSSLContext(provider, protocol, algorithm, keyStore, keyAlias, trustStore);
        return context.getSocketFactory();
    }
}

