/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.serviceregistry.FilteredServiceListener;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.eclipse.osgi.internal.serviceregistry.ShrinkableCollection;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;

public class ServiceRegistry {
    public static final int SERVICEEVENT = 3;
    private static final String findHookName;
    private static final String eventHookName;
    private static final String listenerHookName;
    private final Map publishedServicesByClass;
    private final List allPublishedServices;
    private final Map publishedServicesByContext;
    private long serviceid;
    private final Map serviceEventListeners;
    private static final int initialCapacity = 50;
    private static final int initialSubCapacity = 10;
    private final Framework framework;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.framework.hooks.service.FindHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        findHookName = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.framework.hooks.service.EventHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        eventHookName = clazz2.getName();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.osgi.framework.hooks.service.ListenerHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        listenerHookName = clazz3.getName();
    }

    public ServiceRegistry(Framework framework) {
        this.framework = framework;
        this.serviceid = 1L;
        this.publishedServicesByClass = new HashMap(50);
        this.publishedServicesByContext = new HashMap(50);
        this.allPublishedServices = new ArrayList(50);
        this.serviceEventListeners = new HashMap(50);
    }

    public ServiceRegistrationImpl registerService(BundleContextImpl context, String[] clazzes, Object service, Dictionary properties) {
        String invalidService;
        if (service == null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is null");
            }
            throw new IllegalArgumentException(Msg.SERVICE_ARGUMENT_NULL_EXCEPTION);
        }
        int size = clazzes.length;
        if (size == 0) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Classes array is empty");
            }
            throw new IllegalArgumentException(Msg.SERVICE_EMPTY_CLASS_LIST_EXCEPTION);
        }
        ArrayList<String> copy = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            String clazz = clazzes[i].intern();
            if (!copy.contains(clazz)) {
                copy.add(clazz);
            }
            ++i;
        }
        size = copy.size();
        clazzes = copy.toArray(new String[size]);
        ServiceRegistry.checkRegisterServicePermission(clazzes);
        if (!(service instanceof ServiceFactory) && (invalidService = ServiceRegistry.checkServiceClass(clazzes, service)) != null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is not an instanceof " + invalidService);
            }
            throw new IllegalArgumentException(NLS.bind(Msg.SERVICE_NOT_INSTANCEOF_CLASS_EXCEPTION, invalidService));
        }
        ServiceRegistrationImpl registration = new ServiceRegistrationImpl(this, context, clazzes, service);
        registration.register(properties);
        if (copy.contains(listenerHookName)) {
            this.notifyNewListenerHook(registration);
        }
        return registration;
    }

    public ServiceReferenceImpl[] getServiceReferences(BundleContextImpl context, String clazz, String filterstring, boolean allservices) throws InvalidSyntaxException {
        if (Debug.DEBUG_SERVICES) {
            Debug.println(String.valueOf(allservices ? "getAllServiceReferences(" : "getServiceReferences(") + clazz + ", \"" + filterstring + "\")");
        }
        Filter filter = filterstring == null ? null : context.createFilter(filterstring);
        List references = ServiceRegistry.changeRegistrationsToReferences(this.lookupServiceRegistrations(clazz, filter));
        Iterator iter = references.iterator();
        while (iter.hasNext()) {
            ServiceReferenceImpl reference = (ServiceReferenceImpl)iter.next();
            if (allservices || ServiceRegistry.isAssignableTo(context, reference)) {
                try {
                    ServiceRegistry.checkGetServicePermission(reference);
                }
                catch (SecurityException securityException) {
                    iter.remove();
                }
                continue;
            }
            iter.remove();
        }
        ShrinkableCollection shrinkable = new ShrinkableCollection(references);
        this.notifyFindHooks(context, clazz, filterstring, allservices, shrinkable);
        int size = references.size();
        if (size == 0) {
            return null;
        }
        return references.toArray(new ServiceReferenceImpl[size]);
    }

    public ServiceReferenceImpl getServiceReference(BundleContextImpl context, String clazz) {
        block4: {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("getServiceReference(" + clazz + ")");
            }
            try {
                ServiceReferenceImpl[] references = this.getServiceReferences(context, clazz, null, false);
                if (references != null) {
                    return references[0];
                }
            }
            catch (InvalidSyntaxException e) {
                if (!Debug.DEBUG_GENERAL) break block4;
                Debug.println("InvalidSyntaxException w/ null filter" + e.getMessage());
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public Object getService(BundleContextImpl context, ServiceReferenceImpl reference) {
        ServiceRegistry.checkGetServicePermission(reference);
        return reference.getRegistration().getService(context);
    }

    public boolean ungetService(BundleContextImpl context, ServiceReferenceImpl reference) {
        ServiceRegistrationImpl registration = reference.getRegistration();
        return registration.ungetService(context);
    }

    public ServiceReferenceImpl[] getRegisteredServices(BundleContextImpl context) {
        List references = ServiceRegistry.changeRegistrationsToReferences(this.lookupServiceRegistrations(context));
        Iterator iter = references.iterator();
        while (iter.hasNext()) {
            ServiceReferenceImpl reference = (ServiceReferenceImpl)iter.next();
            try {
                ServiceRegistry.checkGetServicePermission(reference);
            }
            catch (SecurityException securityException) {
                iter.remove();
            }
        }
        int size = references.size();
        if (size == 0) {
            return null;
        }
        return references.toArray(new ServiceReferenceImpl[size]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReferenceImpl[] getServicesInUse(BundleContextImpl context) {
        List references;
        Map servicesInUse = context.getServicesInUseMap();
        if (servicesInUse == null) {
            return null;
        }
        Map map = servicesInUse;
        synchronized (map) {
            block9: {
                if (servicesInUse.size() != 0) break block9;
                return null;
            }
            references = ServiceRegistry.changeRegistrationsToReferences(new ArrayList(servicesInUse.keySet()));
        }
        Iterator iter = references.iterator();
        while (iter.hasNext()) {
            ServiceReferenceImpl reference = (ServiceReferenceImpl)iter.next();
            try {
                ServiceRegistry.checkGetServicePermission(reference);
            }
            catch (SecurityException securityException) {
                iter.remove();
            }
        }
        int size = references.size();
        if (size == 0) {
            return null;
        }
        return references.toArray(new ServiceReferenceImpl[size]);
    }

    public void unregisterServices(BundleContextImpl context) {
        List registrations = this.lookupServiceRegistrations(context);
        Iterator iter = registrations.iterator();
        while (iter.hasNext()) {
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)iter.next();
            try {
                registration.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseServicesInUse(BundleContextImpl context) {
        ArrayList registrations;
        Map servicesInUse = context.getServicesInUseMap();
        if (servicesInUse == null) {
            return;
        }
        Map map = servicesInUse;
        synchronized (map) {
            if (servicesInUse.size() == 0) {
                return;
            }
            registrations = new ArrayList(servicesInUse.keySet());
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("Releasing services");
        }
        Iterator iter = registrations.iterator();
        while (iter.hasNext()) {
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)iter.next();
            registration.releaseService(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(BundleContextImpl context, ServiceListener listener, String filter) throws InvalidSyntaxException {
        FilteredServiceListener oldFilteredListener;
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("addServiceListener[" + context.getBundleImpl() + "](" + listenerName + ", \"" + filter + "\")");
        }
        FilteredServiceListener filteredListener = new FilteredServiceListener(context, listener, filter);
        Map map = this.serviceEventListeners;
        synchronized (map) {
            Map listeners = (Map)this.serviceEventListeners.get(context);
            if (listeners == null) {
                listeners = new CopyOnWriteIdentityMap();
                this.serviceEventListeners.put(context, listeners);
            }
            oldFilteredListener = listeners.put(listener, filteredListener);
        }
        if (oldFilteredListener != null) {
            oldFilteredListener.markRemoved();
            List<FilteredServiceListener> removedListeners = Collections.singletonList(oldFilteredListener);
            this.notifyListenerHooks(removedListeners, false);
        }
        List<FilteredServiceListener> addedListeners = Collections.singletonList(filteredListener);
        this.notifyListenerHooks(addedListeners, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(BundleContextImpl context, ServiceListener listener) {
        FilteredServiceListener oldFilteredListener;
        if (Debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("removeServiceListener[" + context.getBundleImpl() + "](" + listenerName + ")");
        }
        Map map = this.serviceEventListeners;
        synchronized (map) {
            Map listeners = (Map)this.serviceEventListeners.get(context);
            if (listeners == null) {
                return;
            }
            oldFilteredListener = (FilteredServiceListener)listeners.remove(listener);
        }
        if (oldFilteredListener == null) {
            return;
        }
        oldFilteredListener.markRemoved();
        List<FilteredServiceListener> removedListeners = Collections.singletonList(oldFilteredListener);
        this.notifyListenerHooks(removedListeners, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllServiceListeners(BundleContextImpl context) {
        Map removedListenersMap;
        Map map = this.serviceEventListeners;
        synchronized (map) {
            removedListenersMap = (Map)this.serviceEventListeners.remove(context);
        }
        if (removedListenersMap == null || removedListenersMap.size() == 0) {
            return;
        }
        Collection removedListeners = removedListenersMap.values();
        Iterator iter = removedListeners.iterator();
        while (iter.hasNext()) {
            FilteredServiceListener oldFilteredListener = (FilteredServiceListener)iter.next();
            oldFilteredListener.markRemoved();
        }
        this.notifyListenerHooks(removedListeners, false);
    }

    void publishServiceEvent(final ServiceEvent event) {
        if (System.getSecurityManager() == null) {
            this.publishServiceEventPrivileged(event);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServiceRegistry.this.publishServiceEventPrivileged(event);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishServiceEventPrivileged(ServiceEvent event) {
        HashMap listenerSnapshot;
        Map map = this.serviceEventListeners;
        synchronized (map) {
            listenerSnapshot = new HashMap(this.serviceEventListeners.size());
            Iterator iter = this.serviceEventListeners.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                BundleContextImpl context = (BundleContextImpl)entry.getKey();
                Map listeners = (Map)entry.getValue();
                if (listeners.isEmpty()) continue;
                listenerSnapshot.put(context, listeners.entrySet());
            }
        }
        Set shrinkable = listenerSnapshot.keySet();
        this.notifyEventHooksPrivileged(event, shrinkable);
        if (listenerSnapshot.isEmpty()) {
            return;
        }
        ListenerQueue queue = this.framework.newListenerQueue();
        Iterator iter = listenerSnapshot.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            BundleContextImpl dispatcher = (BundleContextImpl)entry.getKey();
            Set listeners = (Set)entry.getValue();
            queue.queueListeners(listeners, (EventDispatcher)dispatcher);
        }
        queue.dispatchEventSynchronous(3, event);
    }

    synchronized long getNextServiceId() {
        long id = this.serviceid++;
        return id;
    }

    void addServiceRegistration(BundleContextImpl context, ServiceRegistrationImpl registration) {
        int insertIndex;
        ArrayList<ServiceRegistrationImpl> contextServices = (ArrayList<ServiceRegistrationImpl>)this.publishedServicesByContext.get(context);
        if (contextServices == null) {
            contextServices = new ArrayList<ServiceRegistrationImpl>(10);
            this.publishedServicesByContext.put(context, contextServices);
        }
        contextServices.add(registration);
        String[] clazzes = registration.getClasses();
        int i = 0;
        int size = clazzes.length;
        while (i < size) {
            String clazz = clazzes[i];
            ArrayList<ServiceRegistrationImpl> services = (ArrayList<ServiceRegistrationImpl>)this.publishedServicesByClass.get(clazz);
            if (services == null) {
                services = new ArrayList<ServiceRegistrationImpl>(10);
                this.publishedServicesByClass.put(clazz, services);
            }
            insertIndex = -Collections.binarySearch(services, registration) - 1;
            services.add(insertIndex, registration);
            ++i;
        }
        insertIndex = -Collections.binarySearch(this.allPublishedServices, registration) - 1;
        this.allPublishedServices.add(insertIndex, registration);
    }

    void removeServiceRegistration(BundleContextImpl context, ServiceRegistrationImpl serviceReg) {
        List contextServices = (List)this.publishedServicesByContext.get(context);
        if (contextServices != null) {
            contextServices.remove(serviceReg);
        }
        String[] clazzes = serviceReg.getClasses();
        int i = 0;
        int size = clazzes.length;
        while (i < size) {
            String clazz = clazzes[i];
            List services = (List)this.publishedServicesByClass.get(clazz);
            services.remove(serviceReg);
            ++i;
        }
        this.allPublishedServices.remove(serviceReg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List lookupServiceRegistrations(String clazz, Filter filter) {
        List result;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            result = clazz == null ? this.allPublishedServices : (List)this.publishedServicesByClass.get(clazz);
            if (result == null || result.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            result = new ArrayList(result);
        }
        if (filter == null) {
            return result;
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)iter.next();
            if (filter.match(registration.getReferenceImpl())) continue;
            iter.remove();
        }
        return result;
    }

    private synchronized List lookupServiceRegistrations(BundleContextImpl context) {
        List result = (List)this.publishedServicesByContext.get(context);
        if (result == null || result.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(result);
    }

    private static List changeRegistrationsToReferences(List result) {
        ListIterator<ServiceReferenceImpl> iter = result.listIterator();
        while (iter.hasNext()) {
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)iter.next();
            iter.set(registration.getReferenceImpl());
        }
        return result;
    }

    private static void checkRegisterServicePermission(String[] names) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        int i = 0;
        int len = names.length;
        while (i < len) {
            sm.checkPermission(new ServicePermission(names[i], "register"));
            ++i;
        }
    }

    private static void checkGetServicePermission(ServiceReference reference) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        sm.checkPermission(new ServicePermission(reference, "get"));
    }

    static boolean hasListenServicePermission(ServiceEvent event, BundleContextImpl context) {
        BundleProtectionDomain domain = context.getBundleImpl().getProtectionDomain();
        if (domain == null) {
            return true;
        }
        return domain.implies(new ServicePermission(event.getServiceReference(), "get"));
    }

    static String checkServiceClass(String[] clazzes, final Object serviceObject) {
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return serviceObject.getClass().getClassLoader();
            }
        });
        int i = 0;
        int len = clazzes.length;
        while (i < len) {
            block4: {
                try {
                    Class<?> serviceClazz;
                    Class<?> clazz = serviceClazz = cl == null ? Class.forName(clazzes[i]) : cl.loadClass(clazzes[i]);
                    if (!serviceClazz.isInstance(serviceObject)) {
                        return clazzes[i];
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!ServiceRegistry.extensiveCheckServiceClass(clazzes[i], serviceObject.getClass())) break block4;
                    return clazzes[i];
                }
            }
            ++i;
        }
        return null;
    }

    private static boolean extensiveCheckServiceClass(String clazz, Class serviceClazz) {
        if (clazz.equals(serviceClazz.getName())) {
            return false;
        }
        Class<?>[] interfaces = serviceClazz.getInterfaces();
        int i = 0;
        int len = interfaces.length;
        while (i < len) {
            if (!ServiceRegistry.extensiveCheckServiceClass(clazz, interfaces[i])) {
                return false;
            }
            ++i;
        }
        Class superClazz = serviceClazz.getSuperclass();
        return superClazz == null || ServiceRegistry.extensiveCheckServiceClass(clazz, superClazz);
    }

    static boolean isAssignableTo(BundleContextImpl context, ServiceReferenceImpl reference) {
        AbstractBundle bundle = context.getBundleImpl();
        String[] clazzes = reference.getClasses();
        int i = 0;
        int len = clazzes.length;
        while (i < len) {
            if (!reference.isAssignableTo(bundle, clazzes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void notifyFindHooks(final BundleContextImpl context, final String clazz, final String filterstring, final boolean allservices, final Collection result) {
        if (System.getSecurityManager() == null) {
            this.notifyFindHooksPrivileged(context, clazz, filterstring, allservices, result);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServiceRegistry.this.notifyFindHooksPrivileged(context, clazz, filterstring, allservices, result);
                    return null;
                }
            });
        }
    }

    void notifyFindHooksPrivileged(BundleContextImpl context, String clazz, String filterstring, boolean allservices, Collection result) {
        BundleContextImpl systemBundleContext = this.framework.getSystemBundleContext();
        if (systemBundleContext == null) {
            return;
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("notifyFindHooks(" + context.getBundleImpl() + "," + clazz + "," + filterstring + "," + allservices + "," + result + ")");
        }
        List hooks = this.lookupServiceRegistrations(findHookName, null);
        Iterator iter = hooks.iterator();
        while (iter.hasNext()) {
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)iter.next();
            Object findHook = registration.getService(systemBundleContext);
            if (findHook == null) continue;
            try {
                try {
                    if (findHook instanceof FindHook) {
                        ((FindHook)findHook).find(context, clazz, filterstring, allservices, result);
                    }
                }
                catch (Throwable t) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println(findHook + ".find() exception: " + t.getMessage());
                        Debug.printStackTrace(t);
                    }
                    this.framework.getAdaptor().handleRuntimeError(t);
                    ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, findHook.getClass().getName(), "find"), t);
                    this.framework.publishFrameworkEvent(2, registration.getBundle(), se);
                    registration.ungetService(systemBundleContext);
                    continue;
                }
            }
            catch (Throwable throwable) {
                registration.ungetService(systemBundleContext);
                throw throwable;
            }
            registration.ungetService(systemBundleContext);
        }
    }

    private void notifyEventHooksPrivileged(ServiceEvent event, Collection result) {
        BundleContextImpl systemBundleContext = this.framework.getSystemBundleContext();
        if (systemBundleContext == null) {
            return;
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("notifyEventHooks(" + event.getType() + ":" + event.getServiceReference() + "," + result + ")");
        }
        List hooks = this.lookupServiceRegistrations(eventHookName, null);
        Iterator iter = hooks.iterator();
        while (iter.hasNext()) {
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)iter.next();
            Object eventHook = registration.getService(systemBundleContext);
            if (eventHook == null) continue;
            try {
                try {
                    if (eventHook instanceof EventHook) {
                        ((EventHook)eventHook).event(event, result);
                    }
                }
                catch (Throwable t) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println(eventHook + ".event() exception: " + t.getMessage());
                        Debug.printStackTrace(t);
                    }
                    this.framework.getAdaptor().handleRuntimeError(t);
                    ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, eventHook.getClass().getName(), "event"), t);
                    this.framework.publishFrameworkEvent(2, registration.getBundle(), se);
                    registration.ungetService(systemBundleContext);
                    continue;
                }
            }
            catch (Throwable throwable) {
                registration.ungetService(systemBundleContext);
                throw throwable;
            }
            registration.ungetService(systemBundleContext);
        }
    }

    private void notifyNewListenerHook(final ServiceRegistrationImpl registration) {
        if (System.getSecurityManager() == null) {
            this.notifyNewListenerHookPrivileged(registration);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServiceRegistry.this.notifyNewListenerHookPrivileged(registration);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyNewListenerHookPrivileged(ServiceRegistrationImpl registration) {
        BundleContextImpl systemBundleContext = this.framework.getSystemBundleContext();
        if (systemBundleContext == null) {
            return;
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("notifyNewListenerHook(" + registration + ")");
        }
        Collection addedListeners = new ArrayList(50);
        Map map = this.serviceEventListeners;
        synchronized (map) {
            Iterator iter = this.serviceEventListeners.values().iterator();
            while (iter.hasNext()) {
                Map listeners = (Map)iter.next();
                if (listeners.isEmpty()) continue;
                addedListeners.addAll(listeners.values());
            }
        }
        addedListeners = Collections.unmodifiableCollection(addedListeners);
        Object listenerHook = registration.getService(systemBundleContext);
        if (listenerHook == null) {
            return;
        }
        try {
            try {
                if (listenerHook instanceof ListenerHook) {
                    ((ListenerHook)listenerHook).added(addedListeners);
                }
            }
            catch (Throwable t) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println(listenerHook + ".added() exception: " + t.getMessage());
                    Debug.printStackTrace(t);
                }
                this.framework.getAdaptor().handleRuntimeError(t);
                ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, listenerHook.getClass().getName(), "event"), t);
                this.framework.publishFrameworkEvent(2, registration.getBundle(), se);
                registration.ungetService(systemBundleContext);
            }
        }
        finally {
            registration.ungetService(systemBundleContext);
        }
    }

    private void notifyListenerHooks(final Collection listeners, final boolean added) {
        if (System.getSecurityManager() == null) {
            this.notifyListenerHooksPrivileged(listeners, added);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServiceRegistry.this.notifyListenerHooksPrivileged(listeners, added);
                    return null;
                }
            });
        }
    }

    void notifyListenerHooksPrivileged(Collection listeners, boolean added) {
        BundleContextImpl systemBundleContext = this.framework.getSystemBundleContext();
        if (systemBundleContext == null) {
            return;
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("notifyListenerHooks(" + listeners + "," + (added ? "added" : "removed") + ")");
        }
        List hooks = this.lookupServiceRegistrations(listenerHookName, null);
        Iterator iter = hooks.iterator();
        while (iter.hasNext()) {
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)iter.next();
            Object listenerHook = registration.getService(systemBundleContext);
            if (listenerHook == null) continue;
            try {
                try {
                    if (listenerHook instanceof ListenerHook) {
                        if (added) {
                            ((ListenerHook)listenerHook).added(listeners);
                        } else {
                            ((ListenerHook)listenerHook).removed(listeners);
                        }
                    }
                }
                catch (Throwable t) {
                    if (Debug.DEBUG_SERVICES) {
                        Debug.println(listenerHook + "." + (added ? "added" : "removed") + "() exception: " + t.getMessage());
                        Debug.printStackTrace(t);
                    }
                    this.framework.getAdaptor().handleRuntimeError(t);
                    ServiceException se = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, listenerHook.getClass().getName(), "event"), t);
                    this.framework.publishFrameworkEvent(2, registration.getBundle(), se);
                    registration.ungetService(systemBundleContext);
                    continue;
                }
            }
            catch (Throwable throwable) {
                registration.ungetService(systemBundleContext);
                throw throwable;
            }
            registration.ungetService(systemBundleContext);
        }
    }
}

