/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.commands.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.felix.karaf.shell.commands.utils.StreamPumper;

public class PumpStreamHandler {
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private Thread outputThread;
    private Thread errorThread;
    private StreamPumper inputPump;

    public PumpStreamHandler(InputStream in, OutputStream out, OutputStream err) {
        assert (in != null);
        assert (out != null);
        assert (err != null);
        this.in = in;
        this.out = out;
        this.err = err;
    }

    public PumpStreamHandler(OutputStream out, OutputStream err) {
        this(null, out, err);
    }

    public PumpStreamHandler(OutputStream outAndErr) {
        this(outAndErr, outAndErr);
    }

    public void setChildOutputStream(InputStream in) {
        assert (in != null);
        this.createChildOutputPump(in, this.out);
    }

    public void setChildErrorStream(InputStream in) {
        assert (in != null);
        if (this.err != null) {
            this.createChildErrorPump(in, this.err);
        }
    }

    public void setChildInputStream(OutputStream out) {
        assert (out != null);
        if (this.in != null) {
            this.inputPump = this.createInputPump(this.in, out, true);
        } else {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void attach(Process p) {
        assert (p != null);
        this.setChildInputStream(p.getOutputStream());
        this.setChildOutputStream(p.getInputStream());
        this.setChildErrorStream(p.getErrorStream());
    }

    public void start() {
        if (this.outputThread != null) {
            this.outputThread.start();
        }
        if (this.errorThread != null) {
            this.errorThread.start();
        }
        if (this.inputPump != null) {
            Thread inputThread = new Thread(this.inputPump);
            inputThread.setDaemon(true);
            inputThread.start();
        }
    }

    public void stop() {
        if (this.outputThread != null) {
            try {
                this.outputThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.errorThread != null) {
            try {
                this.errorThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.inputPump != null) {
            this.inputPump.stop();
        }
        try {
            this.err.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void createChildOutputPump(InputStream in, OutputStream out) {
        assert (in != null);
        assert (out != null);
        this.outputThread = this.createPump(in, out);
    }

    protected void createChildErrorPump(InputStream in, OutputStream out) {
        assert (in != null);
        assert (out != null);
        this.errorThread = this.createPump(in, out);
    }

    protected Thread createPump(InputStream in, OutputStream out) {
        assert (in != null);
        assert (out != null);
        return this.createPump(in, out, false);
    }

    protected Thread createPump(InputStream in, OutputStream out, boolean closeWhenExhausted) {
        assert (in != null);
        assert (out != null);
        Thread result = new Thread(new StreamPumper(in, out, closeWhenExhausted));
        result.setDaemon(true);
        return result;
    }

    protected StreamPumper createInputPump(InputStream in, OutputStream out, boolean closeWhenExhausted) {
        assert (in != null);
        assert (out != null);
        StreamPumper pumper = new StreamPumper(in, out, closeWhenExhausted);
        pumper.setAutoflush(true);
        return pumper;
    }
}

