// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/apache/doris-operator/api/disaggregated/v1"
	scheme "github.com/apache/doris-operator/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// DorisDisaggregatedClustersGetter has a method to return a DorisDisaggregatedClusterInterface.
// A group's client should implement this interface.
type DorisDisaggregatedClustersGetter interface {
	DorisDisaggregatedClusters(namespace string) DorisDisaggregatedClusterInterface
}

// DorisDisaggregatedClusterInterface has methods to work with DorisDisaggregatedCluster resources.
type DorisDisaggregatedClusterInterface interface {
	Create(ctx context.Context, dorisDisaggregatedCluster *v1.DorisDisaggregatedCluster, opts metav1.CreateOptions) (*v1.DorisDisaggregatedCluster, error)
	Update(ctx context.Context, dorisDisaggregatedCluster *v1.DorisDisaggregatedCluster, opts metav1.UpdateOptions) (*v1.DorisDisaggregatedCluster, error)
	UpdateStatus(ctx context.Context, dorisDisaggregatedCluster *v1.DorisDisaggregatedCluster, opts metav1.UpdateOptions) (*v1.DorisDisaggregatedCluster, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.DorisDisaggregatedCluster, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.DorisDisaggregatedClusterList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.DorisDisaggregatedCluster, err error)
	DorisDisaggregatedClusterExpansion
}

// dorisDisaggregatedClusters implements DorisDisaggregatedClusterInterface
type dorisDisaggregatedClusters struct {
	client rest.Interface
	ns     string
}

// newDorisDisaggregatedClusters returns a DorisDisaggregatedClusters
func newDorisDisaggregatedClusters(c *DisaggregatedV1Client, namespace string) *dorisDisaggregatedClusters {
	return &dorisDisaggregatedClusters{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the dorisDisaggregatedCluster, and returns the corresponding dorisDisaggregatedCluster object, and an error if there is any.
func (c *dorisDisaggregatedClusters) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.DorisDisaggregatedCluster, err error) {
	result = &v1.DorisDisaggregatedCluster{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("dorisdisaggregatedclusters").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of DorisDisaggregatedClusters that match those selectors.
func (c *dorisDisaggregatedClusters) List(ctx context.Context, opts metav1.ListOptions) (result *v1.DorisDisaggregatedClusterList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.DorisDisaggregatedClusterList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("dorisdisaggregatedclusters").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested dorisDisaggregatedClusters.
func (c *dorisDisaggregatedClusters) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("dorisdisaggregatedclusters").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a dorisDisaggregatedCluster and creates it.  Returns the server's representation of the dorisDisaggregatedCluster, and an error, if there is any.
func (c *dorisDisaggregatedClusters) Create(ctx context.Context, dorisDisaggregatedCluster *v1.DorisDisaggregatedCluster, opts metav1.CreateOptions) (result *v1.DorisDisaggregatedCluster, err error) {
	result = &v1.DorisDisaggregatedCluster{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("dorisdisaggregatedclusters").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(dorisDisaggregatedCluster).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a dorisDisaggregatedCluster and updates it. Returns the server's representation of the dorisDisaggregatedCluster, and an error, if there is any.
func (c *dorisDisaggregatedClusters) Update(ctx context.Context, dorisDisaggregatedCluster *v1.DorisDisaggregatedCluster, opts metav1.UpdateOptions) (result *v1.DorisDisaggregatedCluster, err error) {
	result = &v1.DorisDisaggregatedCluster{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("dorisdisaggregatedclusters").
		Name(dorisDisaggregatedCluster.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(dorisDisaggregatedCluster).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *dorisDisaggregatedClusters) UpdateStatus(ctx context.Context, dorisDisaggregatedCluster *v1.DorisDisaggregatedCluster, opts metav1.UpdateOptions) (result *v1.DorisDisaggregatedCluster, err error) {
	result = &v1.DorisDisaggregatedCluster{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("dorisdisaggregatedclusters").
		Name(dorisDisaggregatedCluster.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(dorisDisaggregatedCluster).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the dorisDisaggregatedCluster and deletes it. Returns an error if one occurs.
func (c *dorisDisaggregatedClusters) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("dorisdisaggregatedclusters").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *dorisDisaggregatedClusters) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("dorisdisaggregatedclusters").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched dorisDisaggregatedCluster.
func (c *dorisDisaggregatedClusters) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.DorisDisaggregatedCluster, err error) {
	result = &v1.DorisDisaggregatedCluster{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("dorisdisaggregatedclusters").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
