-- https://github.com/apache/incubator-doris/issues/8850
DROP DATABASE IF EXISTS issue_8850;
CREATE DATABASE issue_8850;
use issue_8850
CREATE TABLE `tag_map` ( `tag_group` bigint(20) NULL COMMENT "标签组", `tag_value_id` varchar(64) NULL COMMENT "标签值", `tag_range` int(11) NOT NULL DEFAULT "0" COMMENT "", `partition_sign` varchar(32) NOT NULL COMMENT "分区标识", `bucket` int(11) NOT NULL COMMENT "分桶字段", `confidence` tinyint(4) NULL DEFAULT "100" COMMENT "置信度", `members` bitmap BITMAP_UNION  COMMENT "人群") ENGINE=OLAP AGGREGATE KEY(`tag_group`, `tag_value_id`, `tag_range`, `partition_sign`, `bucket`, `confidence`) COMMENT "dmp_tag_map" PARTITION BY LIST(`partition_sign`) (PARTITION p202203231 VALUES IN ("2022-03-23-1"), PARTITION p202203251 VALUES IN ("2022-03-25-1"), PARTITION p202203261 VALUES IN ("2022-03-26-1"), PARTITION p202203271 VALUES IN ("2022-03-27-1"), PARTITION p202203281 VALUES IN ("2022-03-28-1"), PARTITION p202203291 VALUES IN ("2022-03-29-1"), PARTITION p202203301 VALUES IN ("2022-03-30-1"), PARTITION p202203311 VALUES IN ("2022-03-31-1"), PARTITION p202204011 VALUES IN ("2022-04-01-1"), PARTITION crowd VALUES IN ("crowd"), PARTITION crowd_tmp VALUES IN ("crowd_tmp"), PARTITION extend_crowd VALUES IN ("extend_crowd"), PARTITION partition_sign VALUES IN ("online_crowd")) DISTRIBUTED BY HASH(`bucket`) BUCKETS 64 PROPERTIES ("replication_allocation" = "tag.location.default: 1", "in_memory" = "false", "storage_format" = "V2");

with d as (select f1.bucket, bitmap_and(f1.members, f2.members) as members from (select f1.bucket, bitmap_and(f1.members, f2.members) as members from (select bucket, bitmap_union(members) as members from tag_map where partition_sign='2022-03-31-1' and tag_group=810004  and tag_value_id in (5524627,5524628,5524629) group by bucket) f1,(select bucket, bitmap_union(members) as members from tag_map where partition_sign='2022-03-31-1' and tag_group=810007 and tag_value_id in ('5525013_17357124_5525019','5525013_17357124_5525020','5525013_17357124_5525021','5525013_17357124_5525022','5525013_17357124_5525023') group by bucket) f2 where f1.bucket=f2.bucket) f1, (select f1.bucket, bitmap_and(f1.members, f2.members) as members from (select f1.bucket, bitmap_and(f1.members, f2.members) as members from (select f1.bucket, bitmap_and(f1.members, f2.members) as members from (select bucket, bitmap_union(members) as members from tag_map where partition_sign='2022-03-31-1' and tag_group=660004  and tag_value_id in (1392235) group by bucket) f1,(select bucket, bitmap_union(members) as members from tag_map where partition_sign='2022-03-31-1' and tag_group=630004  and tag_value_id in (5404632) group by bucket) f2 where f1.bucket=f2.bucket) f1,(select bucket, bitmap_union(members) as members from tag_map where partition_sign='2022-03-31-1' and tag_group=420004  and tag_value_id in (5404628) group by bucket) f2 where f1.bucket=f2.bucket) f1,(select bucket, bitmap_union(members) as members from tag_map where partition_sign='2022-03-31-1' and tag_group=240004  and tag_value_id in (14622211) group by bucket) f2 where f1.bucket=f2.bucket) f2  where f1.bucket=f2.bucket) select bucket, member_id from d lateral view explode_bitmap(members) t as member_id;

DROP DATABASE IF EXISTS issue_8850;
