// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.analysis;

import org.apache.doris.thrift.TVarType;

// Set statement type.
public enum SetType {
    DEFAULT("DEFAULT"),
    GLOBAL("GLOBAL"),
    SESSION("SESSION"),
    USER("USER");

    private String desc;

    SetType(String desc) {
        this.desc = desc;
    }

    public TVarType toThrift() {
        switch (this) {
            case GLOBAL:
                return TVarType.GLOBAL;
            default:
                return TVarType.SESSION;
        }
    }

    public static SetType fromThrift(TVarType tType) {
        switch (tType) {
            case GLOBAL:
                return SetType.GLOBAL;
            default:
                return SetType.SESSION;
        }
    }

    public String toSql() {
        return desc;
    }

    @Override
    public String toString() {
        return toSql();
    }
}
