// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
suite("test_ip_functions", "arrow_flight_sql") {
    sql "set batch_size = 4096;"

    qt_sql "SELECT ipv4_num_to_string(-1);"
    qt_sql "SELECT ipv4_num_to_string(2130706433);"
    qt_sql "SELECT ipv4_num_to_string(4294967298);"
    qt_sql "SELECT inet_ntoa(3232235521);"

    qt_sql "SELECT ipv4_string_to_num('127.0.0.1');"
    qt_sql "SELECT ipv4_string_to_num_or_null('');"
    qt_sql "SELECT ipv4_string_to_num_or_default('');"
    qt_sql "SELECT ipv4_string_to_num_or_default('127.0.0.1');"
    qt_sql "SELECT ipv4_string_to_num_or_default('abc');"
    qt_sql "SELECT ipv4_string_to_num_or_default(NULL);"
    qt_sql "SELECT inet_aton('192.168.0.1');"
    qt_sql "SELECT inet_aton('192.168');"
    qt_sql "SELECT inet_aton('');"
    qt_sql "SELECT inet_aton(NULL);"

    qt_sql "SELECT ipv6_num_to_string(unhex('0A0005091'));"
    qt_sql "SELECT ipv6_num_to_string(unhex('2A0206B8000000000000000000000011'));"
    qt_sql "SELECT ipv6_num_to_string(unhex('FDFE0000000000005A55CAFFFEFA9089'));"
    qt_sql "SELECT ipv6_num_to_string(unhex(''));"
    qt_sql "SELECT ipv6_num_to_string(unhex('KK'));"
    qt_sql "SELECT ipv6_num_to_string(unhex('0A000509'));"
    qt_sql "SELECT ipv6_num_to_string(unhex('abcd123456'));"
    qt_sql "SELECT ipv6_num_to_string(unhex('ffffffffffffffffffffffffffffffffffffffffffffffffffffff'));"
    qt_sql "SELECT inet6_ntoa(unhex('0A0005091'));"
    qt_sql "SELECT inet6_ntoa(unhex('2A0206B8000000000000000000000011'));"
    qt_sql "SELECT inet6_ntoa(unhex(NULL));"
    qt_sql "SELECT inet6_ntoa(unhex('00000000000000000000000000000000'));"
    qt_sql "SELECT inet6_ntoa(unhex('0000000000000000000000000000'));"
    qt_sql "SELECT inet6_ntoa(unhex('000'));"
    qt_sql "SELECT inet6_ntoa(unhex('aaaaaaaaFFFFFFFFFFFFFFFFaaaaaaaa'));"
    qt_sql "SELECT inet6_ntoa(unhex('aaaa@#'));"
    qt_sql "SELECT inet6_ntoa(unhex('\0'));"
    qt_sql "SELECT inet6_ntoa(unhex('00000000000000000000FFFF7F000001'));"

    qt_sql "SELECT hex(ipv6_string_to_num('192.168.0.1'));"
    qt_sql "SELECT hex(ipv6_string_to_num('2a02:6b8::11'));"
    qt_sql "SELECT hex(ipv6_string_to_num('::'));"
    qt_sql "SELECT hex(ipv6_string_to_num('a0:50:9100::'));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_default('192.168.0.1'));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_default('2a02:6b8::11'));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_default('::'));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_default('KK'));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_default('ffffffffffffffffffffffffffffffffffffffffffffffffffffff'));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_null('192.168.0.1'));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_null('2a02:6b8::11'));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_null('::'));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_null('KK'));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_null('ffffffffffffffffffffffffffffffffffffffffffffffffffffff'));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_null(''));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_null(NULL));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_null('\0'));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_null('00'));"
    qt_sql "SELECT hex(ipv6_string_to_num_or_null('aaaa:aaaa:ffff:ffff:ffff:ffff:aaaa:aaaa'));"
    qt_sql "SELECT hex(inet6_aton('192.168.0.1'));"
    qt_sql "SELECT hex(inet6_aton('2a02:6b8::11'));"
    qt_sql "SELECT hex(inet6_aton(''));"
    qt_sql "SELECT hex(inet6_aton(NULL));"
    qt_sql "SELECT hex(inet6_aton('KK'));"

    qt_sql "SELECT is_ipv4_compat(inet6_aton('::10.0.5.9'));"
    qt_sql "SELECT is_ipv4_compat(inet6_aton('::ffff:10.0.5.9'));"
    qt_sql "SELECT is_ipv4_compat(inet6_aton('::'));"
    qt_sql "SELECT is_ipv4_compat(inet6_aton('::c0a8:0001'));"
    qt_sql "SELECT is_ipv4_compat(inet6_aton('::0.0.0.0'));"
    qt_sql "SELECT is_ipv4_compat(inet6_aton('::255.255.255.255'));"
    qt_sql "SELECT is_ipv4_compat(inet6_aton(''));"
    qt_sql "SELECT is_ipv4_compat(inet6_aton(NULL));"
    qt_sql "SELECT is_ipv4_compat(inet6_aton('KK'));"

    qt_sql "SELECT is_ipv4_mapped(inet6_aton('::10.0.5.9'));"
    qt_sql "SELECT is_ipv4_mapped(inet6_aton('::ffff:10.0.5.9'));"
    qt_sql "SELECT is_ipv4_mapped(inet6_aton('::'));"
    qt_sql "SELECT is_ipv4_mapped(inet6_aton('::ffff:c0a8:0001'));"
    qt_sql "SELECT is_ipv4_mapped(inet6_aton(''));"
    qt_sql "SELECT is_ipv4_mapped(inet6_aton(NULL));"
    qt_sql "SELECT is_ipv4_mapped(inet6_aton('KK'));"

    qt_sql "SELECT ipv6_num_to_string(ipv6_string_to_num('192.168.0.1'));"
    qt_sql "SELECT ipv6_num_to_string(ipv6_string_to_num('::ffff:10.0.5.9'));"
    qt_sql "SELECT ipv6_num_to_string(ipv6_string_to_num('::ffff:c0a8:0001'));"
    qt_sql "SELECT ipv6_num_to_string(ipv6_string_to_num('::'));"
    qt_sql "SELECT ipv6_num_to_string(ipv6_string_to_num('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff'));"
    // we should test the _null and _default
    sql """ DROP TABLE IF EXISTS  table_100_undef_partitions2_keys3_properties4_distributed_by5 """
    sql """
    create table table_100_undef_partitions2_keys3_properties4_distributed_by5 (
    pk int,
    col_varchar_255__undef_signed varchar(255)  null  ,
    col_varchar_255__undef_signed_index_inverted varchar(255)  null  ,
    col_varchar_255__undef_signed_not_null varchar(255)  not null  ,
    col_varchar_255__undef_signed_not_null_index_inverted varchar(255)  not null  ,
    col_ipv4_undef_signed ipv4  null  ,
    col_ipv4_undef_signed_not_null ipv4  not null  ,
    col_ipv6_undef_signed ipv6  null  ,
    col_ipv6_undef_signed_not_null ipv6  not null  ,
    col_ipv4_undef_signed2 ipv4  null  ,
    col_ipv4_undef_signed_not_null2 ipv4  not null  ,
    col_ipv6_undef_signed2 ipv6  null  ,
    col_ipv6_undef_signed_not_null2 ipv6  not null  ,
    INDEX col_varchar_255__undef_signed_index_inverted_idx (`col_varchar_255__undef_signed_index_inverted`) USING INVERTED,
    INDEX col_varchar_255__undef_signed_not_null_index_inverted_idx (`col_varchar_255__undef_signed_not_null_index_inverted`) USING INVERTED
    ) engine=olap
    DUPLICATE KEY(pk)
    distributed by hash(pk) buckets 10
    properties("replication_num" = "1");
    """
        sql """ insert into table_100_undef_partitions2_keys3_properties4_distributed_by5(pk,col_varchar_255__undef_signed,col_varchar_255__undef_signed_index_inverted,col_varchar_255__undef_signed_not_null,col_varchar_255__undef_signed_not_null_index_inverted,col_ipv4_undef_signed,col_ipv4_undef_signed_not_null,col_ipv6_undef_signed,col_ipv6_undef_signed_not_null,col_ipv4_undef_signed2,col_ipv4_undef_signed_not_null2,col_ipv6_undef_signed2,col_ipv6_undef_signed_not_null2) values (0,'you','74.159.168.12','82.236.83.26','56d3:b4ac:9869:667:b045:609b:92cf:efb7','180.96.153.30','111.137.75.242','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','4dd1:bebe:5b19:3c37:f5e0:fab1:a57:51e5','182.254.101.36','181.10.66.245',null,'f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa'),(1,'7bd9:1122:2cc1:e782:2115:5246:ef55:f2d3','2cd1:f7ec:de4c:c82c:77e0:1e46:75a5:ad20','154.157.221.150','fcd7:2c04:ade0:a974:25c2:c1e7:4f2c:f1bb', "87.107.240.72",'26.38.190.186','ed15:1fb4:2659:9c52:7272:f222:367e:a718','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa',null,'114.64.135.74',null,'953a:72ea:48a7:cecf:5707:dfbe:818e:f9bb'),(2,'5.227.53.212','102.182.15.80','196.102.26.147','196.102.26.147','71.1.182.234','234.91.217.44','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','111.137.75.242','100.25.232.101','f569:61c:c38:e82f:cb9d:5d19:2261:2d00','f2ea:28a3:313b:6613:54a:4a81:9a33:ce63'),(3,'a7fe:653a:a25:d2bd:8cda:98b3:a021:24a9','out','74.159.168.12','25.61.173.172',null,'134.175.53.13','322c:b281:25b6:883d:6521:af7f:5c94:17eb','4eed:72fb:70a6:c35a:8abe:d187:e197:7ab5',null,'178.179.8.92','e77:45b9:eda6:87cb:168:d7a1:da21:9c4c','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(4,'158.238.49.95','111.136.169.170','67.188.237.200','18.97.166.70','229.202.234.213','111.137.75.242','4174:9b35:d03c:d418:9e5c:5a0b:cd7d:9858','9782:8a73:6669:c8ac:a5b1:8740:766:8a51',null,'46.33.99.33','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(5,'fcd7:2c04:ade0:a974:25c2:c1e7:4f2c:f1bb','196.193.118.94','7bd9:1122:2cc1:e782:2115:5246:ef55:f2d3','196.193.118.94','74.0.92.11','200.85.65.0','5928:9f17:43b7:3848:1174:4bc4:96c9:7d3a','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','187.176.239.246','111.137.75.242','9aba:1565:fa7:e72c:d033:7aac:f787:6a95','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(6,'5.227.53.212','73b:a410:a0d2:5c99:c673:e6da:8d3a:ee5c','648a:1db3:25af:5348:6ca1:3497:af4a:a803','254.162.27.94','71.1.182.234','71.1.182.234','44cb:d47:aa01:5b79:87fa:dc53:16cc:29f5','2ad4:fbfb:ae6:9f38:c246:9267:22ec:43b6','111.137.75.242','102.117.115.251','5a67:8510:d16f:7d72:430:7ea4:46ad:aabc','1f5c:c77a:5abd:2870:59b6:97ce:ec67:5822'),(7,'7efd:c3ed:e53b:679b:6fba:7ee1:6fba:fe3b','232.83.151.78','56d3:b4ac:9869:667:b045:609b:92cf:efb7','92:b192:bc62:fac:bb89:3156:d7b5:82cf','28.113.15.9','111.137.75.242','b4bc:16e2:4294:bf6c:d6:9192:71a3:595c','6dbf:1375:a12d:5de1:4eb5:7741:7198:ff66','65.120.6.181', "87.107.240.72",'c3e:fa4e:8ba9:d52f:41a8:3957:bc61:2912','4582:43a1:138b:257:b17b:e007:8fbb:b67e'),(8,'67.188.237.200','25.61.173.172','158.238.49.95','5e75:ed9:67af:fa6:c3f8:67cb:cb3c:9a1e','125.156.30.14','124.249.96.7','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','10.30.160.136','76.14.208.234','433f:b27:b0ea:ddea:e10b:1e47:9144:c9a1','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(9,'147.6.144.124','7efd:c3ed:e53b:679b:6fba:7ee1:6fba:fe3b','f05b:559c:2da5:365a:94f7:d991:f86a:7731','9a7:f88f:84dc:7041:7d2a:8238:88ca:f56c','11.229.65.58','124.171.230.193','718f:1026:848c:9a4c:fc87:f474:d745:275c','c971:35c0:1096:51e6:2cdf:8d8e:adda:c5d2','111.137.75.242','71.1.182.234','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(10,'82.236.83.26','35.28.154.21','a30d:a198:7ecd:e0bb:161b:5189:3be7:7cd0','946c:7a3f:dc20:7dce:664a:b332:e0aa:325a','49.23.152.57', "87.107.240.72",'c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','8cb4:968a:ff93:5ae:bbd:b982:8388:6e36','111.137.75.242','107.206.6.160','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','f6c8:50fb:bc4b:440b:a459:88fa:c29f:b37'),(11,'102.182.15.80','143.192.0.85','169.245.104.184','b1bb:f2eb:5d3f:cfaa:37be:a3f5:e6e1:89c7','254.208.29.26','119.12.145.234','75d3:620a:2096:e4fb:cd8b:dde0:b226:298a','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','120.215.231.132','71.1.182.234','d0a0:45e0:5dc0:bbee:7027:7a1:4a95:e444','a416:3d8b:dde8:827e:fad8:ad61:7948:6cd3'),(12,'25.61.173.172','5.227.53.212','102.182.15.80','182.116.182.196','146.35.0.136','85.154.38.122','3e9:cfe0:e466:32f6:2b5e:69a5:2af5:63c4','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907', "87.107.240.72",'166.137.118.208','acca:b9f5:dc40:713e:46cd:380f:2891:9755','aefe:cc40:f3f9:9c8f:8b74:59f4:1f61:fc09'),(13,'232.83.151.78','fe21:6efe:e832:a674:62bb:f616:fc2c:c2af','106.252.189.23','182.116.182.196','77.182.40.170','111.137.75.242','63da:4c86:a07c:61c1:b03a:2b0d:f80e:666f','8da:1fbd:a018:514e:a7a5:b8c5:ee06:e027','65.211.102.103','71.1.182.234','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','9f6f:34a1:4c82:999b:5280:f5f6:bd31:3759'),(14,'82.236.83.26','77c7:c0d:dd9c:d356:16ac:565a:88d4:ce2a','6317:40cc:a7f3:c208:71fd:e897:2339:5fb9','67.188.237.200','174.125.135.106','205.147.238.71','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','91.75.133.230','111.137.75.242','c542:9054:ef66:4055:cad:bdc9:cd5c:22f5','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa'),(15,'dd29:515f:42c3:fe22:435:d73c:22c0:701f','158.238.49.95','b0da:79e:240a:f4ff:17c8:24ec:4a6:8d5f','5.227.53.212','15.28.12.159', "87.107.240.72",'edc3:b4d1:6623:729c:fe1d:57ca:8800:76fc','f5ab:3244:54d4:5207:19a7:9531:643c:1572','131.26.102.223','34.105.141.131','c10d:e1f2:1fc1:fcf:91cd:4053:76e1:19d3','46de:a732:2f08:61ff:d259:980:a5e5:2b0c'),(16,'29a4:9e8c:43f3:c82d:2e7c:9336:5c4d:8fe','fcc2:a56c:2dff:fb0f:7cf:8fb7:d5d4:598','196.102.26.147','102.182.15.80','206.163.145.152','111.137.75.242','ba65:34c0:96bc:7f87:e5a7:6aab:ad20:65a4','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','84.7.89.104','228.73.85.134',null,'c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(17,'fcd7:2c04:ade0:a974:25c2:c1e7:4f2c:f1bb','9a7:f88f:84dc:7041:7d2a:8238:88ca:f56c','167.140.31.217','91.177.240.72','111.137.75.242','19.81.141.199','181e:68d:6699:6b9e:f86d:173:35b7:7dc7','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','71.1.182.234', "87.107.240.72",'f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','5bb4:75b:5cf2:36d6:8561:541c:457f:b681'),(18,'1a2e:70e8:5fe:5c92:ffe0:1cb8:30af:66c','648a:1db3:25af:5348:6ca1:3497:af4a:a803','fcc2:a56c:2dff:fb0f:7cf:8fb7:d5d4:598','fcd7:2c04:ade0:a974:25c2:c1e7:4f2c:f1bb','149.115.16.131','71.1.182.234','3db6:1304:5154:d25c:af84:dfa6:644c:a5ee','df47:7e16:df72:a764:dd07:28aa:a9c9:ac95','71.1.182.234','101.17.219.251','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa'),(19,'92:b192:bc62:fac:bb89:3156:d7b5:82cf','196.193.118.94','69.122.173.184','fe21:6efe:e832:a674:62bb:f616:fc2c:c2af','193.239.119.5','149.67.140.205',null,'f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','232.135.148.247','110.184.19.40','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(20,'22.87.217.77','154.157.221.150','e8b2:fa6f:bf0a:2a93:70e1:5d45:5af0:2fbc','2cd1:f7ec:de4c:c82c:77e0:1e46:75a5:ad20','166.168.32.148', "87.107.240.72",null,'a214:da86:d374:4537:3fe5:6445:85d9:8576','63.53.82.198','203.137.142.235',null,'7794:b848:aca5:47e5:363a:4024:f96b:1545'),(21,'f05b:559c:2da5:365a:94f7:d991:f86a:7731','dd29:515f:42c3:fe22:435:d73c:22c0:701f','56d3:b4ac:9869:667:b045:609b:92cf:efb7','38.207.140.76','111.137.75.242','111.137.75.242','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','35:c065:8a8d:6938:cb84:d340:a6b1:f4d1','71.1.182.234','56.251.96.74','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','59ff:3b1b:ea82:6c64:72b2:98a5:52dd:6a16'),(22,'77c7:c0d:dd9c:d356:16ac:565a:88d4:ce2a','232.83.151.78','29a4:9e8c:43f3:c82d:2e7c:9336:5c4d:8fe','7bd9:1122:2cc1:e782:2115:5246:ef55:f2d3','71.1.182.234','228.89.212.64','c405:c8f:e50d:633:1f64:837f:eac6:fb01','f905:f5e2:e3ba:cb2a:ec52:db5b:41a4:9081','24.21.13.75', "87.107.240.72",'c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','7211:6c25:4916:9616:8dc0:799d:4a5f:1894'),(23,'9a7:f88f:84dc:7041:7d2a:8238:88ca:f56c','a7fe:653a:a25:d2bd:8cda:98b3:a021:24a9','29a4:9e8c:43f3:c82d:2e7c:9336:5c4d:8fe','6317:40cc:a7f3:c208:71fd:e897:2339:5fb9','113.189.84.23','4.107.153.214','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','96e7:523a:1ed5:cea0:7940:a04b:be30:2038','137.13.21.169','102.167.26.72','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','6281:1237:d712:edb:3e93:a6ef:39ac:ac'),(24,'73b:a410:a0d2:5c99:c673:e6da:8d3a:ee5c','5e75:ed9:67af:fa6:c3f8:67cb:cb3c:9a1e','648a:1db3:25af:5348:6ca1:3497:af4a:a803','25.61.173.172','181.32.104.92','207.130.36.127','345c:7b30:9dc6:423f:fbce:7af:7f14:cf7a','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','233.107.225.93','23.178.157.76','46c5:3e21:255c:e4dc:5c1e:a34c:ce85:c609','6feb:f5d3:da2:b3f0:8232:d3b8:34ca:353f'),(25,'fe21:6efe:e832:a674:62bb:f616:fc2c:c2af','b1bb:f2eb:5d3f:cfaa:37be:a3f5:e6e1:89c7','106.252.189.23','102.182.15.80','71.1.182.234','169.97.145.39','c4b0:f148:8206:fe85:ddb5:96d6:e0ff:603c','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','71.1.182.234','112.173.74.74','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(26,'7bd9:1122:2cc1:e782:2115:5246:ef55:f2d3','22.87.217.77','dd29:515f:42c3:fe22:435:d73c:22c0:701f','3856:1aff:7b09:6688:a449:9224:563:3e67','207.218.202.51','233.80.153.8','db02:eaa9:9a99:687:7362:3524:40c8:5c2c','146f:436a:35aa:23c5:a39f:10f4:abbf:ff21',null,'71.1.182.234','ae49:838f:dea2:b960:8bd0:feb5:8b28:1bf1','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(27,'fe21:6efe:e832:a674:62bb:f616:fc2c:c2af','74.159.168.12','154.157.221.150','22.87.217.77','71.1.182.234','100.42.115.83','32fd:fe95:5927:ec9f:287a:6fd8:5cd9:cb4c','8719:b0d5:8661:eabc:9f5b:ecac:2e9a:cd90','139.115.154.209','111.137.75.242','4170:5e0b:c52e:b134:bd8b:37a3:ba9c:6497','d4e9:1afb:c9bb:6b8a:bb48:6e49:d7dd:9c18'),(28,'182.116.182.196','232.83.151.78','101.94.182.88','b0da:79e:240a:f4ff:17c8:24ec:4a6:8d5f','171.19.213.58','71.1.182.234','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','7d3:c219:9958:be20:c72c:59d1:7528:fd7b','39.124.39.240','250.127.11.43','5dc2:1c70:a734:35ea:6279:b3a8:fc08:20fd','7fbd:eaf6:4df9:7a69:c051:499b:4115:42a2'),(29,'5e75:ed9:67af:fa6:c3f8:67cb:cb3c:9a1e','38.207.140.76','143.192.0.85','1a2e:70e8:5fe:5c92:ffe0:1cb8:30af:66c','28.107.247.94','111.137.75.242','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','242.138.214.41','239.184.79.226','12d5:1f1c:ff85:84fa:9399:293e:64a4:43bf','9afd:6cb0:b6cb:7565:dc2d:5309:c592:c176'),(30,'167.140.31.217','946c:7a3f:dc20:7dce:664a:b332:e0aa:325a','182.116.182.196','29a4:9e8c:43f3:c82d:2e7c:9336:5c4d:8fe','111.137.75.242','37.139.218.190','dba3:4260:9d5a:35c8:614d:b879:73bf:73e3','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','212.249.75.157','39.54.109.55','1986:96c2:3c59:d29:511b:71b:c0e:12e1','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(31,'73b:a410:a0d2:5c99:c673:e6da:8d3a:ee5c','56d3:b4ac:9869:667:b045:609b:92cf:efb7','91.177.240.72','f05b:559c:2da5:365a:94f7:d991:f86a:7731','152.238.101.46','71.1.182.234',null,'7f81:d131:9355:7e7d:6b9:556f:f572:b6c8',null,'129.178.61.173','3776:6bb5:98c6:115b:42d7:9c47:5c0b:4d8a','d016:8e16:f5ef:6966:5f29:4e84:2ccf:b7ad'),(32,'5.227.53.212','a30d:a198:7ecd:e0bb:161b:5189:3be7:7cd0','e8b2:fa6f:bf0a:2a93:70e1:5d45:5af0:2fbc','9701:dad3:adfe:a6b5:3c3b:cbfa:471c:edbf','13.149.183.230','111.137.75.242','ee74:6667:b504:614d:d0ac:b1de:1111:a7a0','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa',null,'31.156.95.184','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(33,'acda:a803:9f63:5fd8:30bb:76ce:880b:6531','196.102.26.147','7bd9:1122:2cc1:e782:2115:5246:ef55:f2d3','69.122.173.184',null,'144.108.169.153','2bc7:f838:8b81:c675:9a9a:ea06:1bbc:96b8','9bc1:de31:86d7:103e:b599:f6a8:db13:a1e9','71.1.182.234', "87.107.240.72",'d228:135c:675d:c50a:4f72:f4d6:e2e0:f16e','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa'),(34,'87.64.101.251','232.83.151.78','7bd9:1122:2cc1:e782:2115:5246:ef55:f2d3','56d3:b4ac:9869:667:b045:609b:92cf:efb7', "87.107.240.72",'232.54.198.166','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','9927:3aba:5203:4516:f470:ebab:3f96:de0e','111.137.75.242','202.184.2.122','45bf:9ec:3d4b:5cff:ffa3:4ee9:4658:c65e','ae62:98bf:3060:6bd4:1149:c169:67c0:2de9'),(35,'1a2e:70e8:5fe:5c92:ffe0:1cb8:30af:66c','18.97.166.70','7bd9:1122:2cc1:e782:2115:5246:ef55:f2d3','69.122.173.184',null,'22.133.104.210','6511:9600:28f1:595b:8284:74cd:d5c3:fafa','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907',null,'71.1.182.234','3e18:8dea:46fe:30fd:ee1f:89ae:e48b:fe5e','8bc4:c3f7:64ad:abac:6122:a0ef:35cd:1817'),(36,'35.28.154.21','get','182.116.182.196','dd29:515f:42c3:fe22:435:d73c:22c0:701f','71.1.182.234','19.229.213.204',null,'b266:ff5b:8799:c764:d0f7:9d17:e99d:8130','111.137.75.242','16.89.118.192','c91:b450:1870:57e3:bc9:70d9:9b1:2e4d','5552:c3da:f8b7:8c44:b98d:4fa4:6e54:1159'),(37,'25.61.173.172','92:b192:bc62:fac:bb89:3156:d7b5:82cf','5.227.53.212','254.125.153.251',null,'87.254.49.84','b0ee:762f:1675:3607:dacd:c2c3:9e57:a97','3ae:33a6:9f48:161c:d36f:4e9e:728:7505', "87.107.240.72",'39.241.219.127','5c69:e372:6481:ec6:2ca4:dba5:7959:8cf2','3f8b:7512:6cee:8e90:1232:9944:fa96:9659'),(38,'143.192.0.85','fe21:6efe:e832:a674:62bb:f616:fc2c:c2af','147.6.144.124','5e75:ed9:67af:fa6:c3f8:67cb:cb3c:9a1e','189.122.69.219','111.137.75.242',null,'76e4:177b:24f3:6bd7:70ce:3b4e:87f3:fb42','157.4.35.154','10.53.31.20',null,'a9aa:85d1:9e26:1e1b:3104:8be:e869:63a9'),(39,'101.94.182.88','fcc2:a56c:2dff:fb0f:7cf:8fb7:d5d4:598','dd29:515f:42c3:fe22:435:d73c:22c0:701f','25.61.173.172','158.99.31.43','4.48.25.90','2fe4:ad76:a07e:4309:c5e:5823:3051:7d88','ce41:eafc:5c58:e1aa:8d0a:e133:650b:395c','103.138.202.74', "87.107.240.72",'798f:c27c:6ed4:e721:372c:764:5a0a:48cc','f7fa:1ae7:109f:7165:273c:4cf3:352b:1e78'),(40,'196.102.26.147','147.6.144.124','106.252.189.23','254.162.27.94', "87.107.240.72",'60.104.110.4','2708:3175:10be:fba5:3f96:588c:7d2f:8b3c','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','174.32.46.246', "87.107.240.72",'3d80:d9e8:e29f:9786:d6b8:617d:68db:40ac','edd8:50c4:1ec0:5aa0:586e:4122:c572:4528'),(41,'91.177.240.72','946c:7a3f:dc20:7dce:664a:b332:e0aa:325a','196.193.118.94','fcc2:a56c:2dff:fb0f:7cf:8fb7:d5d4:598','182.114.162.179','223.163.100.252','f6bd:51dc:2265:7fa9:3821:3633:f389:cfe0','920:566:355d:c22c:f3d8:27e1:5377:2e5b','209.62.66.128', "87.107.240.72",'df49:d3bc:6ac5:b609:3969:5cef:61b6:2816','9a54:960b:d28c:7af2:55ac:1a8e:2369:b085'),(42,'7bd9:1122:2cc1:e782:2115:5246:ef55:f2d3','82.219.33.81','9a7:f88f:84dc:7041:7d2a:8238:88ca:f56c','7efd:c3ed:e53b:679b:6fba:7ee1:6fba:fe3b', "87.107.240.72",'62.44.228.111','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','62.24.201.40','51.223.10.79','f252:3187:e33a:30d5:bcdd:b9e1:a76e:6d42','4648:6bb6:b661:606c:86ac:9092:824f:e5b1'),(43,'23.13.206.243','e8b2:fa6f:bf0a:2a93:70e1:5d45:5af0:2fbc','69.122.173.184','22.87.217.77','114.115.188.61','111.137.75.242','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','5845:16f7:40a9:d707:a6c2:2bef:2cfd:7c70','235.125.36.176','69.134.119.71','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa'),(44,'a298:f78f:e4df:ed9d:c1c3:f245:ff48:bd87','a298:f78f:e4df:ed9d:c1c3:f245:ff48:bd87','143.192.0.85','23.13.206.243','101.239.167.196','89.12.151.47','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','238.25.105.28','133.237.226.149','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(45,'5e75:ed9:67af:fa6:c3f8:67cb:cb3c:9a1e','91.177.240.72','7efd:c3ed:e53b:679b:6fba:7ee1:6fba:fe3b','9a7:f88f:84dc:7041:7d2a:8238:88ca:f56c','88.169.95.27','158.214.2.122','baad:d9ad:6127:87a0:2cad:1f38:5293:3bd6','fd33:1942:e950:f13f:6242:cf89:a06f:722','217.109.200.4','162.171.178.69','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','87:6ef7:d1ab:8ce2:e86d:80f7:6c4a:7519'),(46,'169.245.104.184','22.87.217.77','648a:1db3:25af:5348:6ca1:3497:af4a:a803','a7fe:653a:a25:d2bd:8cda:98b3:a021:24a9','148.233.203.178','129.61.145.225','68c2:b5a8:ec59:85c8:c8e5:9512:c97a:f67f','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','78.195.109.215','180.207.232.254','389b:7af3:97a0:70f:e6fe:a4b6:9127:2973','d2e1:e88a:1a68:476b:2573:97b0:7336:1328'),(47,'77c7:c0d:dd9c:d356:16ac:565a:88d4:ce2a','a30d:a198:7ecd:e0bb:161b:5189:3be7:7cd0','946c:7a3f:dc20:7dce:664a:b332:e0aa:325a','22.87.217.77','122.57.9.5', "87.107.240.72",'1008:9628:7179:a3ca:b1f4:52a2:7857:bdb9','8b57:fb69:cc8:62a4:9fd:638f:b855:d5a0','26.104.152.136','111.137.75.242','7f07:3a7f:cf8b:4cae:b556:e63c:a0b0:8e39','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(48,'9a7:f88f:84dc:7041:7d2a:8238:88ca:f56c','23.13.206.243','b1bb:f2eb:5d3f:cfaa:37be:a3f5:e6e1:89c7','67.188.237.200','179.242.92.5','26.215.6.40','febf:db1:1bab:aee1:d13a:4fa8:5145:59fa','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907',null,'111.137.75.242','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','a8b3:41bc:b2e5:98c6:c431:edb7:c8a9:bc5a'),(49,'196.193.118.94','7bd9:1122:2cc1:e782:2115:5246:ef55:f2d3','35.28.154.21','7bd9:1122:2cc1:e782:2115:5246:ef55:f2d3','239.200.169.213','134.100.204.155','b130:5b42:b85a:5a13:dfa6:783c:4de4:4ced','a2af:d940:176c:4975:647d:c8b:ad07:9c85','134.110.167.166','111.137.75.242','fb62:8119:28d7:7ba5:1790:cd77:1f90:ef2f','cdc8:4a2f:22c9:1720:31e2:c307:a528:6197'),(50,'232.83.151.78','87.64.101.251','a30d:a198:7ecd:e0bb:161b:5189:3be7:7cd0','254.125.153.251','156.33.67.117','180.41.138.68','324d:890b:abe4:df00:99c0:ad88:5197:5251','85fe:b070:d42a:55ab:d46b:9fa0:1c5f:b623','143.166.185.189','233.45.158.8','e051:7c27:4257:2bfc:6178:68b1:d2c3:4888','6ed3:4d64:ecd3:be98:fa33:bf27:1ca5:56ec'),(51,'254.125.153.251','102.182.15.80','5.227.53.212','196.102.26.147','176.49.100.44','111.137.75.242','b2bf:df4d:e85e:ca08:b190:a5ed:f430:9f8e','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','63.179.168.173','71.1.182.234','ca2b:19c1:574f:f187:bfc6:b11b:c29a:8dac','2d1d:161e:6910:df3e:729e:c65f:18fa:1102'),(52,'3856:1aff:7b09:6688:a449:9224:563:3e67','a298:f78f:e4df:ed9d:c1c3:f245:ff48:bd87','254.125.153.251','92:b192:bc62:fac:bb89:3156:d7b5:82cf','116.250.175.157','73.203.86.77','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','b5f0:2cf7:c649:f5ab:98e7:cafe:d56a:8757','111.137.75.242','250.252.52.4','d288:92b9:9c94:9600:c6a8:56e6:af13:5783','bc61:7b65:f199:a4ad:6fc2:c920:a5da:35d8'),(53,'e8b2:fa6f:bf0a:2a93:70e1:5d45:5af0:2fbc','946c:7a3f:dc20:7dce:664a:b332:e0aa:325a','87.64.101.251','254.162.27.94','25.223.6.226','129.139.248.194','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','e849:bd8:25bc:4300:6a8c:2f43:873:4f90',null,'73.38.220.78',null,'fc77:83f8:b249:1dfb:da24:db56:d7b2:3ddf'),(54,'196.193.118.94','87.64.101.251','18.97.166.70','6317:40cc:a7f3:c208:71fd:e897:2339:5fb9','165.181.7.125','221.110.112.8','74b7:b1d9:d180:6439:27ee:9232:cb0d:c9fe','774e:68d9:b72b:2780:7eae:c2cd:f498:5527','17.140.203.84','247.90.137.74','745:ad89:b0f3:2824:f4c3:4b8f:659e:8a90','980a:1116:1f3b:2bf2:8b99:e162:6c5b:c63'),(55,'fcc2:a56c:2dff:fb0f:7cf:8fb7:d5d4:598','56d3:b4ac:9869:667:b045:609b:92cf:efb7','182.116.182.196','254.125.153.251','12.222.97.229', "87.107.240.72",'f2d7:2f9f:a9bd:f858:6c4c:5482:93a:29bb','aa04:df19:305d:56ed:9762:9c68:7ff7:37d5','36.240.227.29','253.244.74.41','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','272b:dfd5:59f2:b905:2f9c:d2b0:1fee:511e'),(56,'b0da:79e:240a:f4ff:17c8:24ec:4a6:8d5f','3856:1aff:7b09:6688:a449:9224:563:3e67','fcc2:a56c:2dff:fb0f:7cf:8fb7:d5d4:598','yeah','162.42.92.147','80.167.190.133','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','2b9e:9fa7:a3f5:b99:1abe:1d2c:2cf7:dc58','188.190.231.9','71.1.182.234','32d8:8b35:12ba:2ca7:7e57:c23f:b419:9242','faf1:5291:5206:80c3:5390:3a9d:83b1:9a74'),(57,'f05b:559c:2da5:365a:94f7:d991:f86a:7731','29a4:9e8c:43f3:c82d:2e7c:9336:5c4d:8fe','92:b192:bc62:fac:bb89:3156:d7b5:82cf','9701:dad3:adfe:a6b5:3c3b:cbfa:471c:edbf','211.226.87.192','219.35.231.153','fa85:d36c:e50e:650:e521:8add:5c3d:fe2','e775:899c:b4e6:d882:a39f:1cc7:71a5:bcb9','171.25.40.67','61.126.33.219','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','7180:8f9a:4898:8e67:b409:aa2e:9d17:8ec5'),(58,'b0da:79e:240a:f4ff:17c8:24ec:4a6:8d5f','8ae9:9a78:ca90:e5e9:a2a0:ca4e:d9f9:3bea','c0c2:a55f:88db:e618:5dc2:7779:34c1:d4c','fcc2:a56c:2dff:fb0f:7cf:8fb7:d5d4:598', "87.107.240.72",'111.137.75.242','24c1:f8b7:7366:735a:c3fe:a557:e069:74f9','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','30.133.232.197','10.46.183.233','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','3a3d:7693:1752:7838:6b3e:4b70:515f:f021'),(59,'a298:f78f:e4df:ed9d:c1c3:f245:ff48:bd87','254.162.27.94','18.97.166.70','dd29:515f:42c3:fe22:435:d73c:22c0:701f','111.137.75.242','244.225.0.248','5182:2344:5bc4:fb8b:398e:2661:f1ac:adfb','6ba3:87a0:1a06:9f93:d56:59bc:ecc6:935a','86.150.57.68','21.13.208.151','b2f9:e54e:cf57:13e4:eda3:3582:b043:90e0','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(60,'5e75:ed9:67af:fa6:c3f8:67cb:cb3c:9a1e','e8b2:fa6f:bf0a:2a93:70e1:5d45:5af0:2fbc','196.102.26.147','196.102.26.147','240.29.133.65','90.141.63.157','630a:1b4f:54f8:3b6:cbf2:16e7:4904:b72d','9014:ed41:b0b8:fa7c:4ccb:86dd:903f:523e','254.119.98.200','219.198.106.49','332d:cb6c:5851:b660:a31f:e0e0:1be6:7a5d','9e15:1fa6:345:7f54:527a:8f56:f120:5a6'),(61,'1a2e:70e8:5fe:5c92:ffe0:1cb8:30af:66c','56d3:b4ac:9869:667:b045:609b:92cf:efb7','196.193.118.94','254.125.153.251','58.123.156.98','249.19.161.6','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','fdd2:4d0:79ae:6511:82bb:8fb7:8f43:e30c','71.1.182.234', "87.107.240.72",'6ab5:84f:12ef:4ca3:4bf5:f93d:4042:bc9c','b9ac:115f:828e:737d:90ee:3960:ee19:df73'),(62,'101.94.182.88','b1bb:f2eb:5d3f:cfaa:37be:a3f5:e6e1:89c7','1a2e:70e8:5fe:5c92:ffe0:1cb8:30af:66c','25.61.173.172','111.137.75.242','71.104.26.174','641:a3de:a344:94c:c94f:c391:770c:12d4','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','71.1.182.234','154.247.241.35','d56f:f13f:b9fd:d341:faaa:db9:7119:6063','3c84:878e:10fb:33a5:915d:4557:1508:ec28'),(63,'23.13.206.243','946c:7a3f:dc20:7dce:664a:b332:e0aa:325a','56d3:b4ac:9869:667:b045:609b:92cf:efb7','106.252.189.23','170.164.206.42','115.193.227.65',null,'ded:dee8:1731:7677:2b4d:cb72:ff52:aa6', "87.107.240.72",'34.187.182.112','ae81:f8dd:35b7:ee78:2895:1181:33da:aae','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(64,'6317:40cc:a7f3:c208:71fd:e897:2339:5fb9','22.87.217.77','182.116.182.196','23.13.206.243','38.110.180.25','71.1.182.234','2eb1:740c:b05c:c9d4:b31a:7a64:2c15:5a10','b78f:98:f844:8950:e29d:72b6:af6c:2fd5','225.246.80.30','51.239.195.19','60bf:f8c8:832c:3a61:301f:7d66:b0da:5151','d8c3:e107:f4f4:1164:8c28:6038:fb8c:2532'),(65,'154.157.221.150','18.97.166.70','2cd1:f7ec:de4c:c82c:77e0:1e46:75a5:ad20','b0da:79e:240a:f4ff:17c8:24ec:4a6:8d5f', "87.107.240.72",'50.74.228.146',null,'27d6:38cd:29a3:9e9f:8d58:3750:1d2b:8074',null,'11.221.166.15','e020:33ef:8773:d47:de5c:3bbe:4d13:5ab6','7d7f:2b0e:690:a3c5:3080:6647:5dc9:7de'),(66,'7bd9:1122:2cc1:e782:2115:5246:ef55:f2d3','143.192.0.85','why','fe21:6efe:e832:a674:62bb:f616:fc2c:c2af',null,'171.140.4.64','1a4c:fbb8:be8e:a36b:1da5:35c0:538d:cc77','4f8c:d815:6bb9:6671:3943:8202:8ee3:3e2b','87.51.227.1','111.137.75.242','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(67,'18.97.166.70','232.83.151.78','101.94.182.88','254.162.27.94','71.1.182.234','111.137.75.242','9b70:6907:73f2:30ea:8c1:1189:14cc:672a','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907',null,'15.203.131.183','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(68,'29a4:9e8c:43f3:c82d:2e7c:9336:5c4d:8fe','e8b2:fa6f:bf0a:2a93:70e1:5d45:5af0:2fbc','56d3:b4ac:9869:667:b045:609b:92cf:efb7','18.97.166.70','140.25.246.161','71.1.182.234','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','4a2c:4021:6059:67e5:b741:1886:606:4833','111.137.75.242','35.173.193.29','9ed9:fbfa:f41e:5f89:e0ad:5cbd:22c9:750d','d40c:9766:f39d:13b8:df41:9943:7050:6f86'),(69,'38.207.140.76','acda:a803:9f63:5fd8:30bb:76ce:880b:6531','232.83.151.78','18.97.166.70','77.47.242.185','55.165.182.9','2ebd:fcc4:cc8d:ef8e:9cae:1d61:bda0:a180','3015:44af:e60f:3e3e:6ae:9196:7884:1818','223.135.18.206','173.226.38.155','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','f014:a389:16a4:f288:7b39:b1d7:19ce:9f6e'),(70,'22.87.217.77','648a:1db3:25af:5348:6ca1:3497:af4a:a803','1a2e:70e8:5fe:5c92:ffe0:1cb8:30af:66c','38.207.140.76','142.8.137.255','71.1.182.234','524a:a424:237b:4933:de9b:69b8:2d07:f0a0','a148:7202:fe75:324a:eeb8:fa54:4d17:c2fa','237.43.107.32','71.1.182.234','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','a8f8:d947:3b21:20b:9c0e:8af2:a45b:c08d'),(71,'fcd7:2c04:ade0:a974:25c2:c1e7:4f2c:f1bb','77c7:c0d:dd9c:d356:16ac:565a:88d4:ce2a','69.122.173.184','f05b:559c:2da5:365a:94f7:d991:f86a:7731','28.250.114.155','112.62.14.161','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','f11e:a1a1:a453:32e0:8d61:48c8:5d27:a6a3','104.4.131.30','167.0.244.108','a659:1431:cd84:bfeb:8e8f:fe3a:7f83:53b5','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(72,'196.193.118.94','143.192.0.85','35.28.154.21','8ae9:9a78:ca90:e5e9:a2a0:ca4e:d9f9:3bea','152.185.99.3','216.27.191.231','e87b:cdfc:8c9f:c138:3a9a:3d7f:bdaa:f25e','2ede:6ef8:4c2f:bd54:e00b:c271:95e1:aeae','153.43.70.100','255.212.242.168','9200:f594:b4dc:2abc:7454:bd38:77db:e92b','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(73,'c0c2:a55f:88db:e618:5dc2:7779:34c1:d4c','a7fe:653a:a25:d2bd:8cda:98b3:a021:24a9','2cd1:f7ec:de4c:c82c:77e0:1e46:75a5:ad20','a30d:a198:7ecd:e0bb:161b:5189:3be7:7cd0','158.225.215.44','65.215.134.172','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','3f90:8e60:c2fa:7b64:7372:91ca:b362:419a','144.64.10.138','33.57.35.227','4a58:535d:b592:fd7f:b978:ebaa:49c5:755a','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa'),(74,'73b:a410:a0d2:5c99:c673:e6da:8d3a:ee5c','67.188.237.200','182.116.182.196','fcc2:a56c:2dff:fb0f:7cf:8fb7:d5d4:598','123.203.71.43','200.169.119.193','d1af:8f2a:5975:c867:1b43:6c70:bd61:b034','5b9:57a4:d38b:4d6a:a863:fa08:f0e1:4e88', "87.107.240.72", "87.107.240.72",'3e48:10b8:ad9:1e94:e6a1:c4e8:28d0:6031','b1a0:8e5c:eb96:4159:c523:6e4c:53b3:6c7a'),(75,'29a4:9e8c:43f3:c82d:2e7c:9336:5c4d:8fe','101.94.182.88','56d3:b4ac:9869:667:b045:609b:92cf:efb7','acda:a803:9f63:5fd8:30bb:76ce:880b:6531','16.90.186.81','138.190.75.150',null,'9d3d:c6bb:8e3c:8e73:cab6:eb3b:4e09:3999','111.137.75.242','53.56.122.93','c018:c733:552:e853:a808:4770:238:caa5','b927:2483:e93f:81c0:509d:4555:c94f:3c32'),(76,'b0da:79e:240a:f4ff:17c8:24ec:4a6:8d5f','1a2e:70e8:5fe:5c92:ffe0:1cb8:30af:66c','167.140.31.217','5.227.53.212','98.169.185.191','118.192.102.111','7146:d717:686f:93c3:d319:f61f:95a5:cd4d','a260:704d:54e4:10ea:3867:f8d7:c10f:b83f',null,'65.215.141.66','7d04:1199:57ca:8fea:27be:b739:26f:f64d','c536:e22b:c9e8:6164:3355:e3ab:9625:e5a2'),(77,'5.227.53.212','c0c2:a55f:88db:e618:5dc2:7779:34c1:d4c','196.193.118.94','3856:1aff:7b09:6688:a449:9224:563:3e67','71.1.182.234','218.143.93.172',null,'8366:20b1:62ea:c6c0:3cb6:f6bf:7a72:54d','244.20.54.47','183.67.34.59','1e3c:e113:877f:74ff:6c26:64ef:c615:c8c1','e677:9950:bb09:583a:d407:5d32:13a6:ca96'),(78,'147.6.144.124','5e75:ed9:67af:fa6:c3f8:67cb:cb3c:9a1e','1a2e:70e8:5fe:5c92:ffe0:1cb8:30af:66c','111.136.169.170', "87.107.240.72",'36.149.63.156','8318:fbf8:b6ad:8c77:2a8b:5e10:6385:ed46','64fe:5fcb:efed:c953:17d3:b80b:ca79:d3c7','126.224.136.84','22.54.161.234','7275:337c:2507:e158:2121:ff3e:f34a:a2c2','29d5:9fd8:253c:c4a1:17d2:f686:ff0a:f62b'),(79,'9701:dad3:adfe:a6b5:3c3b:cbfa:471c:edbf','f05b:559c:2da5:365a:94f7:d991:f86a:7731','18.97.166.70','87.64.101.251','131.144.104.189','33.161.65.17','ea38:f737:3ac6:960e:2898:166e:4b39:ad8a','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907',null,'117.12.89.114','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','c74f:e3c3:fcd7:1b00:e92a:912e:c3fc:c57c'),(80,'25.61.173.172','3856:1aff:7b09:6688:a449:9224:563:3e67','3856:1aff:7b09:6688:a449:9224:563:3e67','5.227.53.212','71.1.182.234','111.137.75.242','5d93:9f45:1c56:78fb:34f6:7954:7539:43ba','6af5:9425:a340:6d07:32bb:35da:88ac:99f','111.137.75.242','245.118.40.32','a1f9:58ab:e220:492a:7d05:7814:c458:7b4e','378a:9fd8:b715:dadf:9682:72ec:1e3b:dca4'),(81,'6317:40cc:a7f3:c208:71fd:e897:2339:5fb9','b1bb:f2eb:5d3f:cfaa:37be:a3f5:e6e1:89c7','fe21:6efe:e832:a674:62bb:f616:fc2c:c2af','22.87.217.77','86.70.38.185','115.92.31.171','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','9426:fba9:8cd0:86c8:6d48:73ff:7f8f:a260',null,'167.226.63.201','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','e29f:1928:1438:8423:bf14:ab5c:ee9:9285'),(82,'158.238.49.95','22.87.217.77','8ae9:9a78:ca90:e5e9:a2a0:ca4e:d9f9:3bea','69.122.173.184','48.40.117.228','111.137.75.242','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','101.121.91.237','57.88.160.225','b059:6e07:bccd:561e:6471:ddac:f9c7:6cd3','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(83,'fcd7:2c04:ade0:a974:25c2:c1e7:4f2c:f1bb','106.252.189.23','9701:dad3:adfe:a6b5:3c3b:cbfa:471c:edbf','35.28.154.21','177.32.201.10','148.21.201.60','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','86af:7dcc:647:6e96:35f:37eb:50d0:7b71','198.164.147.218','202.80.165.196','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','cade:2d26:8007:2bd0:8f16:7dda:5784:aedb'),(84,'56d3:b4ac:9869:667:b045:609b:92cf:efb7','9a7:f88f:84dc:7041:7d2a:8238:88ca:f56c','8ae9:9a78:ca90:e5e9:a2a0:ca4e:d9f9:3bea','2cd1:f7ec:de4c:c82c:77e0:1e46:75a5:ad20','55.173.81.202','232.29.75.141','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','71.1.182.234','111.137.75.242','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','8e54:7945:17a3:d540:4879:4f13:9b36:34e3'),(85,'c0c2:a55f:88db:e618:5dc2:7779:34c1:d4c','74.159.168.12','f05b:559c:2da5:365a:94f7:d991:f86a:7731','b0da:79e:240a:f4ff:17c8:24ec:4a6:8d5f','84.183.102.92','40.239.171.40','84ad:e322:6b67:e136:79a2:1f7d:cf4f:9b79','4ed3:9e36:6402:a9dd:dfac:712f:136e:ea45', "87.107.240.72",'131.77.161.107','b8b4:b817:b39:636d:542b:10db:42a9:6357','b792:c244:ab61:d64f:9904:36d7:9b7e:2489'),(86,'87.64.101.251','b1bb:f2eb:5d3f:cfaa:37be:a3f5:e6e1:89c7','5.227.53.212','91.177.240.72','47.91.80.40', "87.107.240.72",'cb3b:a5dd:b1d:4cc4:e4e5:6ff5:c5bc:d875','431e:c6b5:d733:2e37:8570:850f:e848:509','193.146.50.98','121.115.66.13','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa'),(87,'a30d:a198:7ecd:e0bb:161b:5189:3be7:7cd0','154.157.221.150','143.192.0.85','77c7:c0d:dd9c:d356:16ac:565a:88d4:ce2a',null, "87.107.240.72",'2190:29b5:a52d:45e3:47c2:9e0c:6aa9:bf86','556e:f14c:2080:b8e0:7c:c103:e636:c15','25.92.100.234','215.121.124.253','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa'),(88,'67.188.237.200','254.162.27.94','a30d:a198:7ecd:e0bb:161b:5189:3be7:7cd0','23.13.206.243','134.87.154.77','72.76.48.74','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','2b7c:289b:1faa:49b5:33a9:732:dae7:2687','130.131.246.208','3.17.236.120',null,'c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(89,'82.219.33.81','fcd7:2c04:ade0:a974:25c2:c1e7:4f2c:f1bb','254.125.153.251','b1bb:f2eb:5d3f:cfaa:37be:a3f5:e6e1:89c7',null,'18.139.82.102','a4d0:b53f:2a0e:b33f:d3:a779:a22e:d660','c438:fee5:8fc:a3fa:b32c:d9f4:fd1f:ab82','71.1.182.234','217.202.211.89','661c:930d:2050:56c4:41e9:b97f:1d77:a743','bd34:525e:d556:7414:f62d:95b2:8775:d65c'),(90,'82.236.83.26','87.64.101.251','147.6.144.124','111.136.169.170','40.44.186.245','159.42.95.118','ca92:6c99:b7e3:331f:fadd:170a:8bb8:463b','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','40.9.137.17','17.13.245.36','4ed3:2ddd:b7b1:da95:848d:7bf7:c6fb:e83','13b3:7894:5908:c5cc:2f1:6ddb:bd26:d57b'),(91,'196.193.118.94','82.219.33.81','77c7:c0d:dd9c:d356:16ac:565a:88d4:ce2a','e8b2:fa6f:bf0a:2a93:70e1:5d45:5af0:2fbc','71.1.182.234','213.230.203.167',null,'f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa','106.184.5.120','64.84.166.96','c7f5:558d:712d:a879:6e87:1a09:7611:d165','29b2:aa00:295:789a:75f3:384:43b6:6389'),(92,'102.182.15.80','648a:1db3:25af:5348:6ca1:3497:af4a:a803','106.252.189.23','74.159.168.12','29.20.229.184','122.3.222.165','a3bf:8ab5:3411:840c:6a64:274:af9a:d3f7','138f:b810:7c4e:ce2b:14bc:1f1f:469d:e1b1','71.1.182.234','116.248.99.99','865b:28b0:a582:edf9:e7a5:a668:7b0:d8b','1143:fffc:658:dee5:fa3d:9dcb:e807:615a'),(93,'648a:1db3:25af:5348:6ca1:3497:af4a:a803','38.207.140.76','b0da:79e:240a:f4ff:17c8:24ec:4a6:8d5f','147.6.144.124','214.68.215.229','236.47.192.237',null,'c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','99.15.73.209','38.155.182.39','18f6:c88f:6e6b:a7dc:6ec3:7439:5dc6:69e9','e6e2:e333:eef7:960b:a237:6baf:50ed:4e63'),(94,'22.87.217.77','8ae9:9a78:ca90:e5e9:a2a0:ca4e:d9f9:3bea','25.61.173.172','102.182.15.80','16.104.12.128','64.94.211.6','ce38:f0a:87fc:22c9:fd43:888a:7269:9fde','2756:315c:9a36:23cb:5433:d19f:58ba:c8f1','51.64.36.6', "87.107.240.72",null,'5be5:49f6:e389:3955:4168:73ee:2d31:d565'),(95,'82.219.33.81','143.192.0.85','18.97.166.70','1a2e:70e8:5fe:5c92:ffe0:1cb8:30af:66c','71.1.182.234','71.1.182.234','4048:14da:9559:f84a:73f3:cb60:ea65:dca2','458:a415:6794:2699:22ca:edd:3e40:1de0','34.214.186.166','71.1.182.234','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907'),(96,'38.207.140.76','946c:7a3f:dc20:7dce:664a:b332:e0aa:325a','101.94.182.88','147.6.144.124','71.1.182.234','73.220.237.32','937e:9546:5956:fe80:5cf8:5ebd:d443:3fc8','ca23:f19d:c660:58ed:ff6b:1bd0:c3c7:acdc','35.154.205.13','160.22.23.90','aba0:ecf2:e895:f50b:721b:c98c:92dd:ee6b','f7a7:e0e8:847d:9707:59e2:97d3:b886:33aa'),(97,'35.28.154.21','fcc2:a56c:2dff:fb0f:7cf:8fb7:d5d4:598','6317:40cc:a7f3:c208:71fd:e897:2339:5fb9','6317:40cc:a7f3:c208:71fd:e897:2339:5fb9','71.1.182.234','85.107.205.105','d89d:af2c:4544:c775:e9f3:a1de:ba67:fdc','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','71.1.182.234','22.179.254.64','c27f:5d3:6e23:e4a2:4f61:f804:4557:c907','4b7f:df47:a083:13f9:bd5f:2019:e3d5:c9d2'),(98,'91.177.240.72','101.94.182.88','77c7:c0d:dd9c:d356:16ac:565a:88d4:ce2a','167.140.31.217','114.125.86.220','119.188.89.241','d90f:a6e0:26dc:b1a6:4fec:fdb0:b4a2:240','b835:20fc:b063:d29b:4a8c:1578:b853:2a8d','111.137.75.242','21.8.105.106',null,'8451:eab6:3318:108a:f202:6e89:fa55:8e7c'),(99,'18.97.166.70','946c:7a3f:dc20:7dce:664a:b332:e0aa:325a','2cd1:f7ec:de4c:c82c:77e0:1e46:75a5:ad20','fcd7:2c04:ade0:a974:25c2:c1e7:4f2c:f1bb','4.247.80.17','111.137.75.242','211b:dd01:783c:f790:1be2:7c58:7618:abe3','a050:f2a7:de05:675:6a8a:1dee:21c0:88bc','133.159.138.176','245.9.121.26',null,'78e1:5246:c4b5:48ed:78e5:b056:ee1b:9cbe');
"""
    order_qt_sql """ select hex(inet6_aton(col_varchar_255__undef_signed_index_inverted)) col_alias5 from table_100_undef_partitions2_keys3_properties4_distributed_by5 order by pk """
    order_qt_sql """ select hex(ipv4_string_to_num_or_null(col_varchar_255__undef_signed_index_inverted)) col_alias5 from table_100_undef_partitions2_keys3_properties4_distributed_by5 order by pk"""
    order_qt_sql """ select hex(ipv4_string_to_num_or_default(col_varchar_255__undef_signed_index_inverted)) col_alias5 from table_100_undef_partitions2_keys3_properties4_distributed_by5 order by pk """
}
