// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

#pragma once

#include "common/status.h"
#include "vec/sink/async_writer_sink.h"
#include "vec/sink/writer/iceberg/viceberg_table_writer.h"

namespace doris {

class ObjectPool;
class RowDescriptor;

namespace vectorized {

inline constexpr char VICEBERG_TABLE_SINK[] = "VIcebergTableSink";

class VIcebergTableSink final : public AsyncWriterSink<VIcebergTableWriter, VICEBERG_TABLE_SINK> {
public:
    // Construct from thrift struct which is generated by FE.
    VIcebergTableSink(ObjectPool* pool, const RowDescriptor& row_desc,
                      const std::vector<TExpr>& texprs);

    ~VIcebergTableSink() override;

    Status init(const TDataSink& sink) override;

    Status close(RuntimeState* state, Status exec_status) override;

private:
    ObjectPool* _pool = nullptr;

    Status _close_status = Status::OK();
};

} // namespace vectorized
} // namespace doris
