/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.option.OptionName;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TemplateOptionName;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.transformer.om.FieldHelper;
import org.apache.torque.templates.transformer.om.FindHelper;
import org.apache.torque.templates.transformer.om.ForeignKeyAttributeName;
import org.apache.torque.templates.transformer.om.ForeignKeyChildAttributeName;
import org.apache.torque.templates.transformer.om.ForeignKeyChildElementName;
import org.apache.torque.templates.transformer.om.JavaFieldAttributeName;
import org.apache.torque.templates.transformer.om.ReferenceChildElementName;
import org.apache.torque.templates.transformer.om.TableAttributeName;
import org.apache.torque.templates.transformer.om.TableChildElementName;

public class OMForeignKeyTransformer {
    public void transform(SourceElement foreignKey, ControllerState controllerState) throws SourceTransformerException {
        if (!TorqueSchemaElementName.FOREIGN_KEY.getName().equals(foreignKey.getName())) {
            throw new IllegalArgumentException("Illegal element Name " + foreignKey.getName());
        }
        SourceElement localTable = foreignKey.getParent();
        SourceElement database = localTable.getParent();
        String foreignTableName = (String)foreignKey.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.FOREIGN_TABLE);
        SourceElement foreignTable = FindHelper.findTable(database, foreignTableName, true);
        foreignKey.getChildren().add(foreignTable);
        for (SourceElement reference : foreignKey.getChildren((SourceElementName)TorqueSchemaElementName.REFERENCE)) {
            this.createLocalElementForReference(localTable, reference);
            this.createForeignElementForReference(foreignTable, reference);
        }
        StringBuilder localParentPath = new StringBuilder();
        this.getParentPath(localTable, localParentPath);
        StringBuilder foreignParentPath = new StringBuilder();
        this.getParentPath(foreignTable, foreignParentPath);
        if (foreignParentPath.toString().startsWith(localParentPath.toString())) {
            this.addLocalField(foreignKey, controllerState);
            this.addLocalFieldInBean(foreignKey, controllerState);
        }
        if (localParentPath.toString().startsWith(foreignParentPath.toString())) {
            this.addForeignField(foreignKey, controllerState);
            this.addForeignFieldInBean(foreignKey, controllerState);
        }
        this.setForeignKeyAttributes(foreignKey, controllerState);
    }

    public void transformSecondPass(SourceElement foreignKey, ControllerState controllerState) throws SourceTransformerException {
        this.modifyForeignFieldSecondPass(foreignKey, controllerState);
    }

    private void addForeignField(SourceElement foreignKey, ControllerState controllerState) {
        SourceElement localTable = foreignKey.getParent();
        SourceElement foreignTable = foreignKey.getChild((SourceElementName)TorqueSchemaElementName.TABLE);
        String referencedBySuffix = OMForeignKeyTransformer.getForeignReferencedBySuffix(foreignKey, controllerState);
        String foreignFieldName = (String)controllerState.getOption((OptionName)TemplateOptionName.OM_FOREIGN_FIELD_NAME_PREFIX) + localTable.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_CLASS_NAME) + controllerState.getOption((OptionName)TemplateOptionName.OM_FOREIGN_FIELD_NAME_SUFFIX) + referencedBySuffix;
        String getterSetterFieldName = (String)localTable.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_CLASS_NAME) + referencedBySuffix;
        SourceElement foreignFieldElement = new SourceElement((SourceElementName)ForeignKeyChildElementName.FOREIGN_FIELD);
        foreignFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME, (Object)foreignFieldName);
        foreignFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_ACCESS_MODIFIER, (Object)"protected");
        String criteriaFieldName = "last" + StringUtils.capitalize((String)getterSetterFieldName) + "Criteria";
        foreignFieldElement.setAttribute((SourceAttributeName)ForeignKeyChildAttributeName.FOREIGN_COLUMN_CRITERIA_CACHE_FIELD, (Object)criteriaFieldName);
        String fieldContainedType = (String)localTable.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME);
        foreignFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_CONTAINED_TYPE, (Object)fieldContainedType);
        String fieldType = (String)controllerState.getOption((OptionName)TemplateOptionName.OM_FOREIGN_FIELD_TYPE) + "<" + fieldContainedType + ">";
        foreignFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_TYPE, (Object)fieldType);
        foreignFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.DEFAULT_VALUE, (Object)"null");
        String getterName = FieldHelper.getGetterName(getterSetterFieldName, fieldType, controllerState) + "s";
        foreignFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.GETTER_NAME, (Object)getterName);
        String setterName = FieldHelper.getSetterName(getterSetterFieldName) + "s";
        foreignFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.SETTER_NAME, (Object)setterName);
        String adderName = FieldHelper.getAdderName(getterSetterFieldName, controllerState);
        foreignFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.ADDER_NAME, (Object)adderName);
        adderName = FieldHelper.getResetterName(getterSetterFieldName, controllerState);
        foreignFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.RESETTER_NAME, (Object)adderName);
        String initializerName = FieldHelper.getInitializerName(getterSetterFieldName, controllerState);
        foreignFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.INITIALIZER_NAME, (Object)initializerName);
        String isInitializedName = FieldHelper.getIsInitializedName(getterSetterFieldName, controllerState);
        foreignFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.IS_INITIALIZED_NAME, (Object)isInitializedName);
        String initType = (String)controllerState.getOption((OptionName)TemplateOptionName.OM_FOREIGN_FIELD_INIT_TYPE) + "<" + fieldContainedType + ">";
        foreignFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.INITIALIZER_TYPE, (Object)initType);
        String fillerName = FieldHelper.getFillerName(getterSetterFieldName, "", controllerState);
        foreignFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FILLER_NAME, (Object)fillerName);
        String setAndSaveMethodName = FieldHelper.getSetAndSaveMethodName(getterSetterFieldName, "", controllerState);
        foreignFieldElement.setAttribute("setAndSaveMethodName", (Object)setAndSaveMethodName);
        String peerJoinSelectMethodName = "doSelectJoin" + foreignTable.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME) + referencedBySuffix;
        foreignFieldElement.setAttribute((SourceAttributeName)ForeignKeyChildAttributeName.PEER_JOIN_SELECT_METHOD, (Object)peerJoinSelectMethodName);
        String peerJoinAllExceptSelectMethodName = "doSelectJoinAllExcept" + foreignTable.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME) + referencedBySuffix;
        foreignFieldElement.setAttribute((SourceAttributeName)ForeignKeyChildAttributeName.PEER_JOIN_ALL_EXCEPT_SELECT_METHOD, (Object)peerJoinAllExceptSelectMethodName);
        foreignKey.getChildren().add(foreignFieldElement);
    }

    private void modifyForeignFieldSecondPass(SourceElement foreignKey, ControllerState controllerState) {
        SourceElement foreignFieldElement = foreignKey.getChild((SourceElementName)ForeignKeyChildElementName.FOREIGN_FIELD);
        if (foreignFieldElement == null) {
            return;
        }
        String setterName = (String)foreignFieldElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.SETTER_NAME);
        String regularSetterName = setterName.substring(0, setterName.length() - 1);
        String fieldName = FieldHelper.getFieldNameFromSetterName(regularSetterName);
        String fillerName = FieldHelper.getFillerName(fieldName, "", controllerState);
        SourceElement referencedTable = foreignKey.getChild((SourceElementName)TorqueSchemaElementName.TABLE);
        boolean fillerNamingConflictFound = false;
        for (SourceElement referencedTableForeignKey : referencedTable.getChildren((SourceElementName)TorqueSchemaElementName.FOREIGN_KEY)) {
            String referencedTableFiller;
            SourceElement referencedTableLocalField = referencedTableForeignKey.getChild((SourceElementName)ForeignKeyChildElementName.LOCAL_FIELD);
            if (referencedTableLocalField == null || !fillerName.equals(referencedTableFiller = (String)referencedTableLocalField.getAttribute((SourceAttributeName)JavaFieldAttributeName.FILLER_NAME))) continue;
            fillerNamingConflictFound = true;
            break;
        }
        if (fillerNamingConflictFound) {
            fillerName = FieldHelper.getFillerName(fieldName, (String)controllerState.getOption((OptionName)TemplateOptionName.OM_FILLER_REFERENCING_DISTICTION), controllerState);
        }
        foreignFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FILLER_NAME, (Object)fillerName);
    }

    private void addForeignFieldInBean(SourceElement foreignKey, ControllerState controllerState) {
        SourceElement localTable = foreignKey.getParent();
        String referencedBySuffix = OMForeignKeyTransformer.getForeignReferencedBySuffix(foreignKey, controllerState);
        String beanGetterSetterFieldName = (String)localTable.getAttribute((SourceAttributeName)TableAttributeName.BEAN_CLASS_NAME) + referencedBySuffix;
        String foreignFieldInBeanName = (String)controllerState.getOption((OptionName)TemplateOptionName.OM_FOREIGN_FIELD_NAME_PREFIX) + localTable.getAttribute((SourceAttributeName)TableAttributeName.BEAN_CLASS_NAME) + controllerState.getOption((OptionName)TemplateOptionName.OM_FOREIGN_FIELD_NAME_SUFFIX) + referencedBySuffix;
        SourceElement foreignFieldInBeanElement = new SourceElement((SourceElementName)ForeignKeyChildElementName.FOREIGN_FIELD_IN_BEAN);
        foreignFieldInBeanElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME, (Object)foreignFieldInBeanName);
        foreignFieldInBeanElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_ACCESS_MODIFIER, (Object)"protected");
        String fieldContainedType = (String)localTable.getAttribute((SourceAttributeName)TableAttributeName.BEAN_CLASS_NAME);
        foreignFieldInBeanElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_CONTAINED_TYPE, (Object)fieldContainedType);
        String fieldType = (String)controllerState.getOption((OptionName)TemplateOptionName.OM_FOREIGN_FIELD_TYPE) + "<" + fieldContainedType + ">";
        foreignFieldInBeanElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_TYPE, (Object)fieldType);
        String initType = (String)controllerState.getOption((OptionName)TemplateOptionName.OM_FOREIGN_FIELD_INIT_TYPE) + "<" + fieldContainedType + ">";
        foreignFieldInBeanElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.INITIALIZER_TYPE, (Object)initType);
        foreignFieldInBeanElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.DEFAULT_VALUE, (Object)"null");
        String getterName = FieldHelper.getGetterName(beanGetterSetterFieldName, fieldType, controllerState) + "s";
        foreignFieldInBeanElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.GETTER_NAME, (Object)getterName);
        String setterName = FieldHelper.getSetterName(beanGetterSetterFieldName) + "s";
        foreignFieldInBeanElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.SETTER_NAME, (Object)setterName);
        foreignKey.getChildren().add(foreignFieldInBeanElement);
    }

    private void addLocalFieldInBean(SourceElement foreignKey, ControllerState controllerState) {
        SourceElement foreignTable = foreignKey.getChild((SourceElementName)TorqueSchemaElementName.TABLE);
        String referencedBySuffix = this.getLocalReferencedBySuffix(foreignKey, controllerState);
        String beanGetterSetterFieldName = (String)foreignTable.getAttribute((SourceAttributeName)TableAttributeName.BEAN_CLASS_NAME) + referencedBySuffix;
        String localBeanFieldName = (String)controllerState.getOption((OptionName)TemplateOptionName.OM_LOCAL_FIELD_NAME_PREFIX) + foreignTable.getAttribute((SourceAttributeName)TableAttributeName.BEAN_CLASS_NAME) + controllerState.getOption((OptionName)TemplateOptionName.OM_LOCAL_FIELD_NAME_SUFFIX) + referencedBySuffix;
        SourceElement localFieldInBeanElement = new SourceElement((SourceElementName)ForeignKeyChildElementName.LOCAL_FIELD_IN_BEAN);
        localFieldInBeanElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME, (Object)localBeanFieldName.toString());
        String fieldType = (String)foreignTable.getAttribute((SourceAttributeName)TableAttributeName.BEAN_CLASS_NAME);
        localFieldInBeanElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_TYPE, (Object)fieldType);
        localFieldInBeanElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.DEFAULT_VALUE, (Object)"null");
        String getterName = FieldHelper.getGetterName(beanGetterSetterFieldName, fieldType, controllerState);
        localFieldInBeanElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.GETTER_NAME, (Object)getterName);
        String setterName = FieldHelper.getSetterName(beanGetterSetterFieldName);
        localFieldInBeanElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.SETTER_NAME, (Object)setterName);
        foreignKey.getChildren().add(localFieldInBeanElement);
    }

    private void addLocalField(SourceElement foreignKey, ControllerState controllerState) {
        SourceElement foreignTable = foreignKey.getChild((SourceElementName)TorqueSchemaElementName.TABLE);
        String referencedBySuffix = this.getLocalReferencedBySuffix(foreignKey, controllerState);
        String localFieldName = (String)controllerState.getOption((OptionName)TemplateOptionName.OM_LOCAL_FIELD_NAME_PREFIX) + foreignTable.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_CLASS_NAME) + controllerState.getOption((OptionName)TemplateOptionName.OM_LOCAL_FIELD_NAME_SUFFIX) + referencedBySuffix;
        String getterSetterFieldName = (String)foreignTable.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_CLASS_NAME) + referencedBySuffix;
        SourceElement localFieldElement = new SourceElement((SourceElementName)ForeignKeyChildElementName.LOCAL_FIELD);
        localFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME, (Object)localFieldName.toString());
        localFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.PROPERTY_NAME, (Object)getterSetterFieldName.toString());
        String fieldType = (String)foreignTable.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_CLASS_NAME);
        localFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_TYPE, (Object)fieldType);
        localFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.DEFAULT_VALUE, (Object)"null");
        String getterName = FieldHelper.getGetterName(getterSetterFieldName, fieldType, controllerState);
        localFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.GETTER_NAME, (Object)getterName);
        String setterName = FieldHelper.getSetterName(getterSetterFieldName);
        localFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.SETTER_NAME, (Object)setterName);
        String fillerName = FieldHelper.getFillerName(getterSetterFieldName, "", controllerState);
        localFieldElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FILLER_NAME, (Object)fillerName);
        foreignKey.getChildren().add(localFieldElement);
    }

    private String getLocalReferencedBySuffix(SourceElement foreignKey, ControllerState controllerState) {
        SourceElement localTable = foreignKey.getParent();
        String localTableName = (String)localTable.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        String foreignTableName = (String)foreignKey.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.FOREIGN_TABLE);
        StringBuilder result = new StringBuilder();
        List<SourceElement> referencesToSameTable = FindHelper.findForeignKeyByReferencedTable(localTable, foreignTableName);
        if (referencesToSameTable.size() > 1 || foreignKey.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.FOREIGN_TABLE).equals(localTableName)) {
            result.append((String)controllerState.getOption((OptionName)TemplateOptionName.OM_LOCAL_FIELD_NAME_RELATED_BY));
            for (SourceElement reference : foreignKey.getChildren((SourceElementName)TorqueSchemaElementName.REFERENCE)) {
                SourceElement localColumnElement = (SourceElement)reference.getChildren((SourceElementName)ReferenceChildElementName.LOCAL_COLUMN).get(0);
                SourceElement localColumn = (SourceElement)localColumnElement.getChildren((SourceElementName)TorqueSchemaElementName.COLUMN).get(0);
                String fieldName = (String)localColumn.getAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME);
                result.append(StringUtils.capitalize((String)fieldName));
            }
        }
        return result.toString();
    }

    static String getForeignReferencedBySuffix(SourceElement foreignKey, ControllerState controllerState) {
        SourceElement localTable = foreignKey.getParent();
        String foreignTableName = (String)foreignKey.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.FOREIGN_TABLE);
        StringBuilder result = new StringBuilder();
        List<SourceElement> referencingSameTable = FindHelper.findForeignKeyByReferencedTable(localTable, foreignTableName);
        if (referencingSameTable.size() > 1) {
            result.append((String)controllerState.getOption((OptionName)TemplateOptionName.OM_FOREIGN_FIELD_NAME_RELATED_BY));
            for (SourceElement reference : foreignKey.getChildren((SourceElementName)TorqueSchemaElementName.REFERENCE)) {
                SourceElement localColumnElement = (SourceElement)reference.getChildren((SourceElementName)ReferenceChildElementName.LOCAL_COLUMN).get(0);
                SourceElement localColumn = (SourceElement)localColumnElement.getChildren((SourceElementName)TorqueSchemaElementName.COLUMN).get(0);
                String fieldName = (String)localColumn.getAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME);
                result.append(StringUtils.capitalize((String)fieldName));
            }
        }
        return result.toString();
    }

    private void createForeignElementForReference(SourceElement foreignTable, SourceElement reference) {
        String foreignColumnName = (String)reference.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.FOREIGN);
        SourceElement foreignColumnElement = new SourceElement((SourceElementName)ReferenceChildElementName.FOREIGN_COLUMN);
        SourceElement column = FindHelper.findColumn(foreignTable, foreignColumnName);
        foreignColumnElement.getChildren().add(column);
        reference.getChildren().add(foreignColumnElement);
    }

    protected void createLocalElementForReference(SourceElement localTable, SourceElement reference) throws SourceTransformerException {
        String localColumnName = (String)reference.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.LOCAL);
        SourceElement localColumnElement = new SourceElement((SourceElementName)ReferenceChildElementName.LOCAL_COLUMN);
        SourceElement column = FindHelper.findColumn(localTable, localColumnName);
        if (column == null) {
            Object localTableName = localTable.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
            throw new SourceTransformerException("Error defining foreign key in table " + localTableName + " : Could not find local column " + localColumnName + " in table " + localTableName);
        }
        localColumnElement.getChildren().add(column);
        reference.getChildren().add(localColumnElement);
    }

    private void setForeignKeyAttributes(SourceElement foreignKey, ControllerState controllerState) {
        SourceElement foreignTable = foreignKey.getChild((SourceElementName)TorqueSchemaElementName.TABLE);
        String referencedBySuffix = this.getLocalReferencedBySuffix(foreignKey, controllerState);
        String foreignKeyGetterName = (String)controllerState.getOption((OptionName)TemplateOptionName.OM_FOREIGN_KEY_GETTER_PREFIX) + foreignTable.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_CLASS_NAME) + controllerState.getOption((OptionName)TemplateOptionName.OM_FOREIGN_KEY_GETTER_SUFFIX) + referencedBySuffix;
        foreignKey.setAttribute((SourceAttributeName)ForeignKeyAttributeName.FOREIGN_KEY_GETTER, (Object)foreignKeyGetterName);
        boolean referencesPrimaryKey = false;
        List foreignTablePrimaryKeys = foreignTable.getChild((SourceElementName)TableChildElementName.PRIMARY_KEYS).getChildren((SourceElementName)TorqueSchemaElementName.COLUMN);
        ArrayList<SourceElement> foreignTableForeignKeyColumns = new ArrayList<SourceElement>();
        for (SourceElement reference : foreignKey.getChildren((SourceElementName)TorqueSchemaElementName.REFERENCE)) {
            SourceElement column = reference.getChild((SourceElementName)ReferenceChildElementName.FOREIGN_COLUMN).getChild((SourceElementName)TorqueSchemaElementName.COLUMN);
            foreignTableForeignKeyColumns.add(column);
        }
        if (foreignTablePrimaryKeys.size() == foreignTableForeignKeyColumns.size()) {
            referencesPrimaryKey = true;
            for (int i = 0; i < foreignTablePrimaryKeys.size(); ++i) {
                if (foreignTablePrimaryKeys.get(i) == foreignTableForeignKeyColumns.get(i)) continue;
                referencesPrimaryKey = false;
                break;
            }
        }
        foreignKey.setAttribute((SourceAttributeName)ForeignKeyAttributeName.REFERENCES_PRIMARY_KEY, (Object)referencesPrimaryKey);
    }

    private void getParentPath(SourceElement sourceElement, StringBuilder result) {
        SourceElement parent = sourceElement.getParent();
        if (parent == null) {
            return;
        }
        result.append(parent.getName());
        if (TorqueSchemaElementName.EXTERNAL_SCHEMA.getName().equals(parent.getName())) {
            result.append("[").append(parent.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.FILENAME)).append("]");
        }
        result.append("/");
        this.getParentPath(parent, result);
    }
}

