/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.source;

import java.util.ArrayList;
import java.util.List;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.source.ConfigurableClassSaxHandler;
import org.apache.torque.generator.source.SourceProcessConfiguration;
import org.apache.torque.generator.source.SourceProvider;
import org.apache.torque.generator.source.SourceTransformerDefinition;
import org.apache.torque.generator.source.transform.SourceTransformer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SourceSaxHandler
extends DefaultHandler {
    private final ConfigurationProvider configurationProvider;
    private final UnitDescriptor unitDescriptor;
    private final ConfigurationHandlers configurationHandlers;
    private SourceProcessConfiguration sourceProcessConfiguration;
    private List<SourceTransformerDefinition> transformerDefinitions = new ArrayList<SourceTransformerDefinition>();
    private ConfigurableClassSaxHandler<SourceTransformer> transformerSaxHandler;
    private boolean finished = false;

    public SourceSaxHandler(ConfigurationProvider configurationProvider, UnitDescriptor unitDescriptor, ConfigurationHandlers configurationHandlers) {
        if (configurationProvider == null) {
            throw new NullPointerException("configurationProvider must not be null");
        }
        if (unitDescriptor == null) {
            throw new NullPointerException("unitDescriptor must not be null");
        }
        if (configurationHandlers == null) {
            throw new NullPointerException("configurationHandlers must not be null");
        }
        this.configurationProvider = configurationProvider;
        this.unitDescriptor = unitDescriptor;
        this.configurationHandlers = configurationHandlers;
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        if (this.transformerSaxHandler != null) {
            this.transformerSaxHandler.startElement(uri, localName, rawName, attributes);
        } else if ("transformer".equals(rawName)) {
            this.transformerSaxHandler = new ConfigurableClassSaxHandler(this.configurationProvider, this.unitDescriptor, "transformer");
            this.transformerSaxHandler.startElement(uri, localName, rawName, attributes);
        } else if (rawName.equals("source")) {
            this.sourceProcessConfiguration = new SourceProcessConfiguration();
            this.sourceProcessConfiguration.setStartElementsPath(attributes.getValue("elements"));
            try {
                this.sourceProcessConfiguration.setSkipDecider(attributes.getValue("skipDecider"), this.unitDescriptor);
            }
            catch (ConfigurationException e) {
                throw new SAXException("Could not create source: " + e.getMessage(), e);
            }
        } else {
            throw new SAXException("Unknown element " + rawName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String rawName) throws SAXException {
        if (this.transformerSaxHandler != null) {
            this.transformerSaxHandler.endElement(uri, localName, rawName);
            if (this.transformerSaxHandler.isFinished()) {
                this.transformerDefinitions.add(new SourceTransformerDefinition(this.transformerSaxHandler.getConfiguredClass()));
                this.transformerSaxHandler = null;
            }
        } else if (rawName.equals("source")) {
            this.sourceProcessConfiguration.setSourceTransformerDefinitions(this.transformerDefinitions);
            this.transformerDefinitions = new ArrayList<SourceTransformerDefinition>();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.transformerSaxHandler != null) {
            this.transformerSaxHandler.characters(ch, start, length);
        }
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public ConfigurationHandlers getConfigurationHandlers() {
        return this.configurationHandlers;
    }

    public UnitDescriptor getUnitDescriptor() {
        return this.unitDescriptor;
    }

    public boolean isFinished() {
        return this.finished;
    }

    protected void finished() {
        this.finished = true;
    }

    public abstract SourceProvider getSourceProvider();

    public SourceProcessConfiguration getSourceProcessConfiguration() {
        return this.sourceProcessConfiguration;
    }
}

