/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.jdbc;

import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.Source;
import org.apache.torque.generator.source.SourceProvider;
import org.apache.torque.generator.source.jdbc.JdbcMetadataSource;

public class JdbcMetadataSourceProvider
extends SourceProvider {
    private String urlOption;
    private String driverOption;
    private String usernameOption;
    private String passwordOption;
    private String schemaOption;
    private String url;
    private String driver;
    private String username;
    private String password;
    private String schema;
    private boolean nextCalled = false;

    public JdbcMetadataSourceProvider(String urlOption, String driverOption, String usernameOption, String passwordOption, String schemaOption) throws ConfigurationException {
        if (urlOption == null) {
            throw new ConfigurationException("JdbcMetadataSourceProvider: urlOption must not be null");
        }
        if (driverOption == null) {
            throw new ConfigurationException("JdbcMetadataSourceProvider: driverOption must not be null");
        }
        this.urlOption = urlOption;
        this.driverOption = driverOption;
        this.usernameOption = usernameOption;
        this.passwordOption = passwordOption;
        this.schemaOption = schemaOption;
    }

    @Override
    public void initInternal(ConfigurationHandlers configurationHandlers, ControllerState controllerState) throws ConfigurationException {
        this.driver = controllerState.getStringOption(this.driverOption);
        this.url = controllerState.getStringOption(this.urlOption);
        if (this.usernameOption != null) {
            this.username = controllerState.getStringOption(this.usernameOption);
        }
        if (this.passwordOption != null) {
            this.password = controllerState.getStringOption(this.passwordOption);
        }
        if (this.schemaOption != null) {
            this.schema = controllerState.getStringOption(this.schemaOption);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.nextCalled;
    }

    @Override
    public Source next() {
        if (this.nextCalled) {
            throw new IndexOutOfBoundsException();
        }
        this.nextCalled = true;
        return new JdbcMetadataSource(this.driver, this.url, this.username, this.password, this.schema);
    }

    @Override
    protected void resetInternal(ConfigurationHandlers configurationHandlers, ControllerState controllerState) throws ConfigurationException {
        this.driver = null;
        this.url = null;
        this.username = null;
        this.password = null;
        this.schema = null;
        this.nextCalled = false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String getUrlOption() {
        return this.urlOption;
    }

    public String getDriverOption() {
        return this.driverOption;
    }

    public String getUsernameOption() {
        return this.usernameOption;
    }

    public String getPasswordOption() {
        return this.passwordOption;
    }

    public String getSchemaOption() {
        return this.schemaOption;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSchema() {
        return this.schema;
    }

    @Override
    public SourceProvider copy() throws ConfigurationException {
        JdbcMetadataSourceProvider result = new JdbcMetadataSourceProvider(this.urlOption, this.driverOption, this.usernameOption, this.passwordOption, this.schemaOption);
        return result;
    }

    @Override
    public void copyNotSetSettingsFrom(SourceProvider sourceProvider) {
    }
}

