package org.apache.torque.criteria;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.util.List;
import java.util.Map;

import org.apache.torque.Column;
import org.apache.torque.sql.OrderBy;
import org.apache.torque.util.UniqueColumnList;
import org.apache.torque.util.UniqueList;

/**
 *
 * Interface for both the old org.apache.torque.util and the new
 * org.apache.torque.criteria Criteria class.
 *
 * @param <T> the implementation class
 *
 * @version $Id: CriteriaInterface.java 1449216 2013-02-22 21:16:37Z tfischer $
 *
 * @deprecated This interface will only exist temporarily and will be removed
 * as soon as the class org.apache.torque.util.Criteria is removed.
 */
@Deprecated
public interface CriteriaInterface<T>
{
    /**
     * Get the column aliases.
     *
     * @return A Map which map the column alias names
     * to the alias clauses.
     */
    Map<String, Column> getAsColumns();

    /**
     * Get the table aliases.
     *
     * @return A Map which maps the table alias names to the actual table names.
     */
    Map<String, ? extends Object> getAliases();

    /**
     * Allows one to specify an alias for a table that can
     * be used in various parts of the SQL.
     *
     * @param alias a <code>String</code> value
     * @param table a <code>String</code> value
     */
    T addAlias(String alias, String table);

    /**
     * Returns the table name associated with an alias.
     *
     * @param alias a <code>String</code> value
     * @return a <code>String</code> value
     */
    String getTableForAlias(String alias);

    /**
     * Get the Database(Map) name.
     *
     * @return A String with the Database(Map) name. May be null.
     */
    String getDbName();

    /**
     * Set the DatabaseMap name.  If <code>null</code> is supplied, uses value
     * provided by <code>Torque.getDefaultDB()</code>.
     *
     * @param dbName A String with the Database(Map) name.
     */
    void setDbName(String dbName);

    /**
     * get the List of Joins.  This method is meant to
     * be called by BasePeerImpl.
     * @return a List which contains objects of type Join.
     *         If the criteria does not contains any joins, the list is empty
     */
    List<Join> getJoins();

    /**
     * Adds &quot;ALL &quot; to the SQL statement.
     */
    void setAll();

    /**
     * Adds &quot;DISTINCT &quot; to the SQL statement.
     */
    void setDistinct();

    /**
     * Returns whether case should be ignored in where clauses and order by
     * whenever String columns are encountered.
     *
     * @return True if case is ignored.
     */
    boolean isIgnoreCase();

    /**
     * Is single record?
     *
     * @return True if a single record is being returned.
     */
    boolean isSingleRecord();

    /**
     * Get limit.
     *
     * @return An int with the value for limit.
     */
    int getLimit();

    /**
     * Get offset.
     *
     * @return An int with the value for offset.
     */
    long getOffset();

    /**
     * Get select columns.
     *
     * @return An List with the names of the select columns.
     */
    UniqueColumnList getSelectColumns();

    /**
     * Get select modifiers.
     *
     * @return An UniqueList with the select modifiers.
     */
    UniqueList<String> getSelectModifiers();

    /**
     * Get order by columns.
     *
     * @return An UniqueList with the name of the order columns, not null.
     */
    UniqueList<OrderBy> getOrderByColumns();

    /**
     * Get group by columns.
     *
     * @return An UniqueList with the name of the groupBy clause, not null.
     */
    UniqueColumnList getGroupByColumns();

    /**
     * Set a limit for the query
     *
     * @param limit The upper limit for the number of records returned
     *        by a query.
     * @return A modified Criteria object.
     */
    T setLimit(int limit);

    /**
     * Set the offset.
     *
     * @param offset how many records should be skipped at the start of the
     *        result.
     * @return A modified Criteria object.
     */
    T setOffset(long offset);
}
