/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceProvider
implements Iterator<Source> {
    private static Log log = LogFactory.getLog(SourceProvider.class);
    private boolean initialized;

    public final synchronized void init(ConfigurationHandlers configurationHandlers, ControllerState controllerState) throws ConfigurationException {
        if (this.initialized) {
            log.warn((Object)"init() called more than once, ignoring this call");
            return;
        }
        this.initInternal(configurationHandlers, controllerState);
        this.initialized = true;
    }

    public final synchronized void reset(ConfigurationHandlers configurationHandlers, ControllerState controllerState) throws ConfigurationException {
        if (!this.initialized) {
            log.warn((Object)"reset() called on uninitialized SourceProvider, ignoring this call");
            return;
        }
        this.resetInternal(configurationHandlers, controllerState);
        this.initialized = false;
    }

    protected abstract void initInternal(ConfigurationHandlers var1, ControllerState var2) throws ConfigurationException;

    protected abstract void resetInternal(ConfigurationHandlers var1, ControllerState var2) throws ConfigurationException;

    public boolean isInit() {
        return this.initialized;
    }

    public abstract SourceProvider copy() throws ConfigurationException;

    public abstract void copyNotSetSettingsFrom(SourceProvider var1);
}

