/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public final class ReplicationPrimaryIsStoppingMessage
extends PacketImpl {
    private PrimaryStopping primaryStopping;

    public ReplicationPrimaryIsStoppingMessage() {
        super((byte)121);
    }

    public ReplicationPrimaryIsStoppingMessage(PrimaryStopping b) {
        this();
        this.primaryStopping = b;
    }

    public int expectedEncodeSize() {
        return 17;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.primaryStopping.code);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.primaryStopping = buffer.readInt() == 0 ? PrimaryStopping.STOP_CALLED : PrimaryStopping.FAIL_OVER;
    }

    public PrimaryStopping isFinalMessage() {
        return this.primaryStopping;
    }

    protected String getPacketString() {
        return super.getPacketString() + ", primaryStopping=" + this.primaryStopping;
    }

    public static enum PrimaryStopping {
        STOP_CALLED(0),
        FAIL_OVER(1);

        private final int code;

        private PrimaryStopping(int code) {
            this.code = code;
        }
    }
}

