/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.iteration;

import java.util.NoSuchElementException;
import org.wildfly.common.iteration.CodePointIterator;

final class CharArrayIterator
extends CodePointIterator {
    private final int len;
    private final char[] chars;
    private final int offs;
    private int idx;
    private int offset;

    CharArrayIterator(int len, char[] chars, int offs) {
        this.len = len;
        this.chars = chars;
        this.offs = offs;
        this.idx = 0;
        this.offset = 0;
    }

    @Override
    public boolean hasNext() {
        return this.idx < this.len;
    }

    @Override
    public boolean hasPrevious() {
        return this.idx > 0;
    }

    @Override
    public int next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            ++this.offset;
            int n = Character.codePointAt(this.chars, this.offs + this.idx);
            return n;
        }
        finally {
            this.idx = Character.offsetByCodePoints(this.chars, this.offs, this.len, this.offs + this.idx, 1) - this.offs;
        }
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return Character.codePointAt(this.chars, this.offs + this.idx);
    }

    @Override
    public int previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.idx = Character.offsetByCodePoints(this.chars, this.offs, this.len, this.offs + this.idx, -1) - this.offs;
        --this.offset;
        return Character.codePointAt(this.chars, this.offs + this.idx);
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return Character.codePointBefore(this.chars, this.offs + this.idx);
    }

    @Override
    public long getIndex() {
        return this.offset;
    }
}

