/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.platform.commons.util.Preconditions;

class NullArgumentsProvider
implements ArgumentsProvider {
    private static final Arguments nullArguments = Arguments.arguments(new Object[]{null});

    NullArgumentsProvider() {
    }

    @Override
    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        Method testMethod = context.getRequiredTestMethod();
        Preconditions.condition(testMethod.getParameterCount() > 0, () -> String.format("@NullSource cannot provide a null argument to method [%s]: the method does not declare any formal parameters.", testMethod.toGenericString()));
        return Stream.of(nullArguments);
    }
}

