/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ZipFileObjectTest {
    private static final String NESTED_FILE_1 = "/read-xml-tests/file1.xml";
    private static final String NESTED_FILE_2 = "/read-xml-tests/file2.xml";

    private void assertDelete(Path fileObject) throws IOException {
        Files.delete(fileObject);
    }

    private Path createTempFile() throws IOException {
        Path zipFile = Paths.get("src/test/resources/test-data/read-xml-tests.zip", new String[0]);
        Path newZipFile = Files.createTempFile(this.getClass().getSimpleName(), ".zip", new FileAttribute[0]);
        newZipFile.toFile().deleteOnExit();
        Files.copy(zipFile, newZipFile, StandardCopyOption.REPLACE_EXISTING);
        return newZipFile;
    }

    private void getInputStreamAndAssert(FileObject fileObject, String expectedId) throws FileSystemException, IOException {
        this.readAndAssert(fileObject, fileObject.getContent().getInputStream(), expectedId);
    }

    private void readAndAssert(FileObject fileObject, InputStream inputStream, String expectedId) throws IOException {
        String streamData = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        String fileObjectString = fileObject.toString();
        Assertions.assertNotNull((Object)fileObjectString, (String)streamData);
        Assertions.assertEquals((Object)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Root" + expectedId + ">foo" + expectedId + "</Root" + expectedId + ">\r\n"), (Object)streamData, (String)fileObjectString);
    }

    private void resolveReadAssert(FileObject zipFileObject, String path) throws IOException, FileSystemException {
        try (FileObject zipFileObject2 = zipFileObject.resolveFile(path);
             InputStream inputStream = zipFileObject2.getContent().getInputStream();){
            this.readAndAssert(zipFileObject2, inputStream, "2");
        }
    }

    @Test
    @Disabled(value="Shows that leaving a stream open and not closing any resource leaves the container file locked")
    public void testLeaveNestedFileOpen() throws IOException {
        Path newZipFile = this.createTempFile();
        FileSystemManager manager = VFS.getManager();
        try (FileObject zipFileObject = manager.resolveFile("zip:file:" + newZipFile.toAbsolutePath());){
            FileObject zipFileObject1 = zipFileObject.resolveFile(NESTED_FILE_1);
            this.getInputStreamAndAssert(zipFileObject1, "1");
        }
        this.assertDelete(newZipFile);
    }

    @Test
    public void testReadingFilesInZipFile() throws IOException {
        Path newZipFile = this.createTempFile();
        FileSystemManager manager = VFS.getManager();
        try (FileObject zipFileObject = manager.resolveFile("zip:file:" + newZipFile.toAbsolutePath());){
            try (FileObject zipFileObject1 = zipFileObject.resolveFile(NESTED_FILE_1);
                 InputStream inputStream = zipFileObject1.getContent().getInputStream();){
                this.readAndAssert(zipFileObject1, inputStream, "1");
            }
            this.resolveReadAssert(zipFileObject, NESTED_FILE_2);
        }
        this.assertDelete(newZipFile);
    }

    @Test
    public void testReadingOneAfterClosingAnotherFile() throws IOException {
        InputStream inputStream1;
        FileObject zipFileObject1;
        Path newZipFile = this.createTempFile();
        FileSystemManager manager = VFS.getManager();
        try (FileObject zipFileObject = manager.resolveFile("zip:file:" + newZipFile.toAbsolutePath());){
            zipFileObject1 = zipFileObject.resolveFile(NESTED_FILE_1);
            inputStream1 = zipFileObject1.getContent().getInputStream();
        }
        this.readAndAssert(zipFileObject1, inputStream1, "1");
        zipFileObject1.close();
        this.assertDelete(newZipFile);
    }

    @Test
    public void testReadingOneAfterClosingAnotherStream() throws IOException {
        InputStream inputStream1;
        FileObject zipFileObject1;
        Path newZipFile = this.createTempFile();
        FileSystemManager manager = VFS.getManager();
        try (FileObject zipFileObject = manager.resolveFile("zip:file:" + newZipFile.toAbsolutePath());){
            zipFileObject1 = zipFileObject.resolveFile(NESTED_FILE_1);
            inputStream1 = zipFileObject1.getContent().getInputStream();
            this.resolveReadAssert(zipFileObject, NESTED_FILE_2);
        }
        this.readAndAssert(zipFileObject1, inputStream1, "1");
        zipFileObject1.close();
        this.assertDelete(newZipFile);
    }

    @Test
    public void testReadSpecialNameFileInZipFile() throws FileSystemException {
        File testFile = new File("src/test/resources/test-data/special_fileName.zip");
        String[] fileNames = new String[]{"file.txt", "file^.txt", "file~.txt", "file?.txt", "file@.txt", "file$.txt", "file*.txt", "file&.txt", "file#.txt", "file%.txt", "file!.txt"};
        FileSystemManager manager = VFS.getManager();
        String baseUrl = "zip:file:" + testFile.getAbsolutePath();
        try (FileObject fileObject = manager.resolveFile(baseUrl);){
            Assertions.assertEquals((int)fileObject.getChildren().length, (int)fileNames.length);
            for (String fileName : fileNames) {
                Assertions.assertNotNull((Object)fileObject.getChild(fileName), () -> "can't read file " + fileName);
            }
        }
    }

    @Test
    public void testResolveNestedFileWithoutCleanup() throws IOException {
        Path newZipFile = this.createTempFile();
        FileSystemManager manager = VFS.getManager();
        try (FileObject zipFileObject = manager.resolveFile("zip:file:" + newZipFile.toAbsolutePath());){
            FileObject fileObject = zipFileObject.resolveFile(NESTED_FILE_1);
        }
        this.assertDelete(newZipFile);
    }
}

