/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import org.apache.commons.vfs2.UserAuthenticationData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UserAuthenticationDataTest {
    @Test
    public void testCharacterBasedData() {
        UserAuthenticationData data = new UserAuthenticationData();
        char[] array = "PMC".toCharArray();
        data.setData(UserAuthenticationData.USERNAME, array);
        data.setData(UserAuthenticationData.DOMAIN, "Apache".toCharArray());
        Assertions.assertSame((Object)array, (Object)data.getData(UserAuthenticationData.USERNAME));
        Assertions.assertArrayEquals((char[])"Apache".toCharArray(), (char[])data.getData(UserAuthenticationData.DOMAIN));
        data.setData(UserAuthenticationData.DOMAIN, "Apache Commons".toCharArray());
        Assertions.assertArrayEquals((char[])"Apache Commons".toCharArray(), (char[])data.getData(UserAuthenticationData.DOMAIN));
        Assertions.assertNull((Object)data.getData(UserAuthenticationData.PASSWORD));
        data.cleanup();
        Assertions.assertNull((Object)data.getData(UserAuthenticationData.USERNAME));
        Assertions.assertNull((Object)data.getData(UserAuthenticationData.DOMAIN));
        char[] nulls = new char[]{'\u0000', '\u0000', '\u0000'};
        Assertions.assertArrayEquals((char[])nulls, (char[])array);
    }

    @Test
    public void testCustomType() {
        UserAuthenticationData.Type type = new UserAuthenticationData.Type("JUNIT");
        UserAuthenticationData data = new UserAuthenticationData();
        char[] array = "test".toCharArray();
        data.setData(type, array);
        Assertions.assertSame((Object)array, (Object)data.getData(type));
    }
}

