/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.ProviderTestConfig;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.VfsTestUtils;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.temp.TemporaryFileProvider;
import org.apache.commons.vfs2.provider.webdav.WebdavFileProvider;
import org.apache.commons.vfs2.provider.webdav.WebdavFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.webdav.test.JackrabbitMain;
import org.apache.commons.vfs2.provider.webdav.test.JcrUtils;
import org.apache.commons.vfs2.util.FreeSocketPortUtil;
import org.apache.jackrabbit.core.TransientRepository;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Test;

public class WebdavProviderTestCase
extends AbstractProviderTestConfig {
    private static final char[] PASSWORD = new char[0];
    private static final String USER_ID = "admin";
    private static int SocketPort;
    private static final String TEST_URI = "test.webdav.uri";
    private static JackrabbitMain JrMain;
    private static String ConnectionUri;
    private static Path RepoDirectory;
    private static final boolean DEBUG;

    static Path createTempDirectory() throws IOException {
        Path base = Paths.get("target/test", new String[0]).normalize();
        Files.createDirectories(base, new FileAttribute[0]);
        Path tempFile = Files.createTempFile(base, "WebdavProviderTestCase_", ".tmp", new FileAttribute[0]);
        Files.delete(tempFile);
        Files.createDirectories(base, new FileAttribute[0]);
        if (DEBUG) {
            System.out.println("Working in " + tempFile);
        }
        return tempFile;
    }

    private static void dump(Node node) throws RepositoryException {
        WebdavProviderTestCase.message(node.getPath());
        if (node.getName().equals("jcr:system") || node.getName().equals("jcr:content")) {
            return;
        }
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            if (property.getDefinition().isMultiple()) {
                Value[] values;
                for (Value value : values = property.getValues()) {
                    WebdavProviderTestCase.message(property.getPath() + " = " + value.getString());
                }
                continue;
            }
            WebdavProviderTestCase.message(property.getPath() + " = " + property.getString());
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            WebdavProviderTestCase.dump(nodes.nextNode());
        }
    }

    private static void dump(Path repoDirectory) throws Exception {
        TransientRepository repository = WebdavProviderTestCase.getTransientRepository(repoDirectory);
        try {
            Session session = WebdavProviderTestCase.getSession(repository);
            WebdavProviderTestCase.message("Root node dump:");
            WebdavProviderTestCase.dump(session.getRootNode());
            session.logout();
        }
        finally {
            repository.shutdown();
        }
    }

    private static Session getSession(TransientRepository repository) throws RepositoryException {
        return repository.login((Credentials)new SimpleCredentials(USER_ID, PASSWORD));
    }

    private static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    private static TransientRepository getTransientRepository(Path repoDirectory) throws IOException {
        return new TransientRepository(repoDirectory.resolve("repository.xml").toString(), repoDirectory.toString());
    }

    private static void importFiles(Node parent, File sourceDir) throws RepositoryException, IOException {
        File[] files;
        for (File file : files = sourceDir.listFiles()) {
            if (file.isFile()) {
                try (InputStream data = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    WebdavProviderTestCase.message("Importing file " + file);
                    JcrUtils.putFile(parent, file.getName(), "application/octet-stream", data);
                    continue;
                }
            }
            if (!file.isDirectory()) continue;
            WebdavProviderTestCase.message("Importing folder " + file);
            Node folder = JcrUtils.getOrAddFolder(parent, file.getName());
            WebdavProviderTestCase.importFiles(folder, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importFiles(Path repoDirectory, File sourceDir) throws Exception {
        TransientRepository repository = WebdavProviderTestCase.getTransientRepository(repoDirectory);
        try {
            Session session = WebdavProviderTestCase.getSession(repository);
            WebdavProviderTestCase.importFiles(session.getRootNode(), sourceDir);
            session.save();
            session.logout();
        }
        finally {
            repository.shutdown();
        }
    }

    private static void message(IOException e) {
        if (DEBUG) {
            e.printStackTrace();
        }
    }

    private static void message(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    private static void setUpClass() throws Exception {
        RepoDirectory = WebdavProviderTestCase.createTempDirectory();
        WebdavProviderTestCase.message("Created temp directory " + RepoDirectory);
        WebdavProviderTestCase.importFiles(RepoDirectory, new File(VfsTestUtils.getTestDirectory()));
        WebdavProviderTestCase.dump(RepoDirectory);
        WebdavProviderTestCase.startJackrabbit(RepoDirectory);
        WebdavProviderTestCase.message("Returned from org.apache.jackrabbit.standalone.Main " + SocketPort);
    }

    private static void startJackrabbit(Path repoDirectory) throws Exception {
        boolean quiet = false;
        if (!DEBUG) {
            Logger.getLogger((String)"org.apache.jackrabbit").setLevel(Level.WARN);
            Logger.getLogger((String)"org.apache.commons.httpclient").setLevel(Level.ERROR);
            Logger.getLogger((String)"org.apache.commons.vfs2").setLevel(Level.WARN);
            Logger.getLogger((String)"org.mortbay").setLevel(Level.WARN);
            quiet = true;
        }
        JrMain = new JackrabbitMain(new String[]{"--port", Integer.toString(SocketPort), "--repo", repoDirectory.toString(), quiet ? "--quiet" : ""});
        JrMain.run();
    }

    public static junit.framework.Test suite() throws Exception {
        return new ProviderTestSuite((ProviderTestConfig)new WebdavProviderTestCase()){

            protected void addBaseTests() throws Exception {
                super.addBaseTests();
                this.addTests(WebdavProviderTestCase.class);
            }

            protected void setUp() throws Exception {
                if (WebdavProviderTestCase.getSystemTestUriOverride() == null) {
                    WebdavProviderTestCase.setUpClass();
                }
                super.setUp();
            }

            protected void tearDown() throws Exception {
                WebdavProviderTestCase.tearDownClass();
                super.tearDown();
            }
        };
    }

    private static void tearDownClass() throws Exception {
        JrMain.shutdown();
        if (DEBUG) {
            WebdavProviderTestCase.message("Skipping cleanup of " + RepoDirectory);
            return;
        }
        try {
            WebdavProviderTestCase.message("Deleting temp directory " + RepoDirectory);
            PathUtils.deleteDirectory((Path)RepoDirectory);
        }
        catch (IOException e) {
            WebdavProviderTestCase.message(e);
            try {
                Files.delete(RepoDirectory);
            }
            catch (IOException e1) {
                WebdavProviderTestCase.message("Directory will be deleted on VM exit " + RepoDirectory);
                RepoDirectory.toFile().deleteOnExit();
            }
        }
    }

    public WebdavProviderTestCase() throws IOException {
        SocketPort = FreeSocketPortUtil.findFreeLocalPort();
        WebdavProviderTestCase.message("FreeSocketPortUtil.findFreeLocalPort() = " + SocketPort);
        ConnectionUri = String.format("webdav://%s@localhost:%d/repository/default", USER_ID, SocketPort);
    }

    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = WebdavProviderTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = ConnectionUri;
        }
        WebdavFileSystemConfigBuilder builder = (WebdavFileSystemConfigBuilder)manager.getFileSystemConfigBuilder("webdav");
        FileSystemOptions opts = new FileSystemOptions();
        builder.setRootURI(opts, uri);
        return manager.resolveFile(uri, opts);
    }

    public boolean isFileSystemRootAccessible() {
        return false;
    }

    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("webdav", (FileProvider)new WebdavFileProvider());
        manager.addProvider("tmp", (FileProvider)new TemporaryFileProvider());
    }

    @Test
    public void testResolveIPv6Url() throws Exception {
        String ipv6Url = "webdav://user:pass@[fe80::1c42:dae:8370:aea6%en1]/file.txt";
        FileObject fileObject = VFS.getManager().resolveFile("webdav://user:pass@[fe80::1c42:dae:8370:aea6%en1]/file.txt", new FileSystemOptions());
        WebdavProviderTestCase.assertEquals((String)"webdav://user:pass@[fe80::1c42:dae:8370:aea6%en1]/", (String)fileObject.getFileSystem().getRootURI());
        WebdavProviderTestCase.assertEquals((String)"webdav://user:pass@[fe80::1c42:dae:8370:aea6%en1]/file.txt", (String)fileObject.getName().getURI());
    }

    static {
        DEBUG = Boolean.getBoolean("WebdavProviderTestCase.Debug");
    }
}

