/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigInteger;
import org.apache.commons.statistics.descriptive.IntStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.Statistics;

public final class IntMax
implements IntStatistic,
StatisticAccumulator<IntMax> {
    private int maximum = Integer.MIN_VALUE;

    private IntMax() {
    }

    public static IntMax create() {
        return new IntMax();
    }

    public static IntMax of(int ... values) {
        return Statistics.add(new IntMax(), values);
    }

    public static IntMax ofRange(int[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return IntMax.createFromRange(values, from, to);
    }

    static IntMax createFromRange(int[] values, int from, int to) {
        return Statistics.add(new IntMax(), values, from, to);
    }

    @Override
    public void accept(int value) {
        this.maximum = Math.max(this.maximum, value);
    }

    @Override
    public int getAsInt() {
        return this.maximum;
    }

    @Override
    public long getAsLong() {
        return this.maximum;
    }

    @Override
    public double getAsDouble() {
        return this.maximum;
    }

    @Override
    public BigInteger getAsBigInteger() {
        return BigInteger.valueOf(this.maximum);
    }

    @Override
    public IntMax combine(IntMax other) {
        this.accept(other.getAsInt());
        return this;
    }
}

