/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.function.DoubleUnaryOperator;
import org.apache.commons.numbers.core.NativeOperators;

public final class DD
extends Number
implements NativeOperators<DD>,
Serializable {
    public static final DD ONE = new DD(1.0, 0.0);
    public static final DD ZERO = new DD(0.0, 0.0);
    private static final double MULTIPLIER = 1.34217729E8;
    private static final int EXP_MASK = 2047;
    private static final int CMP_UNSIGNED_2046 = -2147481602;
    private static final int CMP_UNSIGNED_MINUS_1 = Integer.MAX_VALUE;
    private static final int CMP_UNSIGNED_1022 = -2147482626;
    private static final double TWO_POW_512 = 1.3407807929942597E154;
    private static final double TWO_POW_M512 = 7.458340731200207E-155;
    private static final double TWO_POW_53 = 9.007199254740992E15;
    private static final long HIGH32_MASK = -4294967296L;
    private static final long UNSIGN_MASK = Long.MAX_VALUE;
    private static final long MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final int EXPONENT_OFFSET = 1023;
    private static final double HALF = 0.5;
    private static final double SAFE_MULTIPLY = 3.273390607896142E150;
    private static final int TO_STRING_SIZE = 64;
    private static final char FORMAT_START = '(';
    private static final char FORMAT_END = ')';
    private static final char FORMAT_SEP = ',';
    private static final long serialVersionUID = 20230701L;
    private final double x;
    private final double xx;

    private DD(double x, double xx) {
        this.x = x;
        this.xx = xx;
    }

    public static DD of(double x) {
        return new DD(x, 0.0);
    }

    static DD of(double x, double xx) {
        return new DD(x, xx);
    }

    public static DD of(int x) {
        return new DD(x, 0.0);
    }

    public static DD of(long x) {
        long a = x & 0xFFFFFFFF00000000L;
        long b = x - a;
        return DD.fastTwoSum(a, b);
    }

    public static DD from(BigDecimal x) {
        double z = x.doubleValue();
        double zz = Double.isInfinite(z) ? 0.0 : x.subtract(new BigDecimal(z)).doubleValue();
        return new DD(z, zz);
    }

    public static DD ofSum(double x, double y) {
        return DD.twoSum(x, y);
    }

    public static DD ofDifference(double x, double y) {
        return DD.twoDiff(x, y);
    }

    public static DD ofProduct(double x, double y) {
        return DD.twoProd(x, y);
    }

    public static DD ofSquare(double x) {
        return DD.twoSquare(x);
    }

    public static DD fromQuotient(double x, double y) {
        double q0 = x / y;
        double p0 = q0 * y;
        double p1 = DD.twoProductLow(q0, y, p0);
        double r0 = x - p0;
        double r1 = DD.twoDiffLow(x, p0, r0) - p1;
        double q1 = (r0 + r1) / y;
        return new DD(q0, q1);
    }

    public double hi() {
        return this.x;
    }

    public double lo() {
        return this.xx;
    }

    public boolean isFinite() {
        return Double.isFinite(this.x + this.xx);
    }

    @Override
    public double doubleValue() {
        return this.x + this.xx;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public int intValue() {
        return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, this.longValue()));
    }

    @Override
    public long longValue() {
        long a = (long)this.x;
        if ((double)a == this.x) {
            long a2;
            long a1;
            if (Math.abs(this.x) > 9.007199254740992E15) {
                a2 = a1 = (long)(this.x * 0.5);
            } else {
                a1 = a;
                a2 = 0L;
            }
            long b = (long)(a < 0L ? Math.ceil(this.xx) : Math.floor(this.xx));
            long sum = a1 + b + a2;
            if ((sum ^ a) >= 0L) {
                return sum;
            }
        }
        return a;
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.x).add(new BigDecimal(this.xx));
    }

    static DD fastTwoSum(double a, double b) {
        double x = a + b;
        return new DD(x, DD.fastTwoSumLow(a, b, x));
    }

    static double fastTwoSumLow(double a, double b, double x) {
        return b - (x - a);
    }

    static DD fastTwoDiff(double a, double b) {
        double x = a - b;
        return new DD(x, DD.fastTwoDiffLow(a, b, x));
    }

    private static double fastTwoDiffLow(double a, double b, double x) {
        return a - x - b;
    }

    static DD twoSum(double a, double b) {
        double x = a + b;
        return new DD(x, DD.twoSumLow(a, b, x));
    }

    static double twoSumLow(double a, double b, double x) {
        double bVirtual = x - a;
        return a - (x - bVirtual) + (b - bVirtual);
    }

    static DD twoDiff(double a, double b) {
        double x = a - b;
        return new DD(x, DD.twoDiffLow(a, b, x));
    }

    private static double twoDiffLow(double a, double b, double x) {
        double bVirtual = a - x;
        return a - (x + bVirtual) - (b - bVirtual);
    }

    static DD twoProd(double x, double y) {
        double xy = x * y;
        return new DD(xy, DD.twoProductLow(x, y, xy));
    }

    static double twoProductLow(double x, double y, double xy) {
        double hx = DD.highPart(x);
        double lx = x - hx;
        double hy = DD.highPart(y);
        double ly = y - hy;
        return DD.twoProductLow(hx, lx, hy, ly, xy);
    }

    static double twoProductLow(double hx, double lx, double hy, double ly, double xy) {
        return lx * ly - (xy - hx * hy - lx * hy - hx * ly);
    }

    static DD twoSquare(double x) {
        double xx = x * x;
        return new DD(xx, DD.twoSquareLow(x, xx));
    }

    static double twoSquareLow(double x, double x2) {
        double hx = DD.highPart(x);
        double lx = x - hx;
        return DD.twoSquareLow(hx, lx, x2);
    }

    static double twoSquareLow(double hx, double lx, double x2) {
        return lx * lx - (x2 - hx * hx - 2.0 * lx * hx);
    }

    static double highPart(double value) {
        double c = 1.34217729E8 * value;
        return c - (c - value);
    }

    @Override
    public DD negate() {
        return new DD(-this.x, -this.xx);
    }

    public DD abs() {
        if (this.x < 0.0) {
            return this.negate();
        }
        return this.x == 0.0 ? ZERO : this;
    }

    public DD floor() {
        return DD.floorOrCeil(this.x, this.xx, Math::floor);
    }

    public DD ceil() {
        return DD.floorOrCeil(this.x, this.xx, Math::ceil);
    }

    private static DD floorOrCeil(double x, double xx, DoubleUnaryOperator op) {
        double y = op.applyAsDouble(x);
        if (y == x) {
            if (DD.isNotNormal(y)) {
                return new DD(y, 0.0);
            }
            double yy = op.applyAsDouble(xx) + 0.0;
            return DD.fastTwoSum(y, yy);
        }
        return new DD(y, 0.0);
    }

    @Override
    public DD add(double y) {
        double s0 = this.x + y;
        double s1 = DD.twoSumLow(this.x, y, s0);
        return DD.fastTwoSum(s0, s1 + this.xx);
    }

    @Override
    public DD add(DD y) {
        return DD.add(this.x, this.xx, y.x, y.xx);
    }

    static DD add(double x, double xx, double y, double yy) {
        double s0 = x + y;
        double s1 = DD.twoSumLow(x, y, s0);
        double t0 = xx + yy;
        double t1 = DD.twoSumLow(xx, yy, t0);
        DD zz = DD.fastTwoSum(s0, s1 + t0);
        return DD.fastTwoSum(zz.x, zz.xx + t1);
    }

    static DD accurateAdd(double x, double xx, double y) {
        DD s = DD.twoSum(xx, y);
        double s2 = s.xx;
        s = DD.twoSum(x, s.x);
        double s0 = s.x;
        double s1 = s.xx;
        s = DD.fastTwoSum(s1, s2);
        s2 = s.xx;
        s = DD.fastTwoSum(s0, s.x);
        return DD.fastTwoSum(s.x, s2 + s.xx);
    }

    static DD accurateAdd(double x, double xx, double y, double yy) {
        DD s = DD.twoSum(xx, yy);
        double s3 = s.xx;
        s = DD.twoSum(x, s.x);
        double s0 = s.x;
        s = DD.twoSum(s.xx, y);
        double s2 = s.xx;
        s = DD.twoSum(s0, s.x);
        s0 = s.x;
        s = DD.fastTwoSum(s.xx, s2);
        double s1 = s.x;
        s = DD.fastTwoSum(s.xx, s3);
        s3 = s.xx;
        s = DD.fastTwoSum(s1, s.x);
        s2 = s.xx;
        s = DD.fastTwoSum(s0, s.x);
        return DD.fastTwoSum(s.x, s3 + s2 + s.xx);
    }

    @Override
    public DD subtract(double y) {
        return this.add(-y);
    }

    @Override
    public DD subtract(DD y) {
        return DD.add(this.x, this.xx, -y.x, -y.xx);
    }

    @Override
    public DD multiply(double y) {
        return DD.multiply(this.x, this.xx, y);
    }

    private static DD multiply(double x, double xx, double y) {
        double hi = x * y;
        double lo = DD.twoProductLow(x, y, hi);
        return DD.fastTwoSum(hi, lo + xx * y);
    }

    @Override
    public DD multiply(DD y) {
        return DD.multiply(this.x, this.xx, y.x, y.xx);
    }

    private static DD multiply(double x, double xx, double y, double yy) {
        double hi = x * y;
        double lo = DD.twoProductLow(x, y, hi);
        return DD.fastTwoSum(hi, lo + (x * yy + xx * y));
    }

    public DD square() {
        return DD.square(this.x, this.xx);
    }

    private static DD square(double x, double xx) {
        double hi = x * x;
        double lo = DD.twoSquareLow(x, hi);
        return DD.fastTwoSum(hi, lo + 2.0 * x * xx);
    }

    @Override
    public DD divide(double y) {
        return DD.divide(this.x, this.xx, y);
    }

    private static DD divide(double x, double xx, double y) {
        double q0 = x / y;
        DD p = DD.twoProd(y, q0);
        DD r = DD.accurateAdd(x, xx, -p.x, -p.xx);
        double q1 = r.x / y;
        p = DD.twoProd(y, q1);
        r = DD.add(r.x, r.xx, -p.x, -p.xx);
        double q2 = r.x / y;
        DD q = DD.fastTwoSum(q0, q1);
        return DD.twoSum(q.x, q.xx + q2);
    }

    @Override
    public DD divide(DD y) {
        return DD.divide(this.x, this.xx, y.x, y.xx);
    }

    private static DD divide(double x, double xx, double y, double yy) {
        double q0 = x / y;
        DD p = DD.multiply(y, yy, q0);
        DD r = DD.accurateAdd(x, xx, -p.x, -p.xx);
        double q1 = r.x / y;
        p = DD.multiply(y, yy, q1);
        r = DD.add(r.x, r.xx, -p.x, -p.xx);
        double q2 = r.x / y;
        DD q = DD.fastTwoSum(q0, q1);
        return DD.twoSum(q.x, q.xx + q2);
    }

    @Override
    public DD reciprocal() {
        return DD.reciprocal(this.x, this.xx);
    }

    private static DD reciprocal(double y, double yy) {
        double q0 = 1.0 / y;
        DD p = DD.multiply(y, yy, q0);
        DD r = DD.accurateAdd(-p.x, -p.xx, 1.0);
        double q1 = r.x / y;
        p = DD.multiply(y, yy, q1);
        r = DD.add(r.x, r.xx, -p.x, -p.xx);
        double q2 = r.x / y;
        DD q = DD.fastTwoSum(q0, q1);
        return DD.twoSum(q.x, q.xx + q2);
    }

    public DD sqrt() {
        double c = Math.sqrt(this.x);
        if (DD.isNotNormal(c)) {
            return new DD(c, 0.0);
        }
        double hc = DD.highPart(c);
        double lc = c - hc;
        double u = c * c;
        double uu = DD.twoSquareLow(hc, lc, u);
        double cc = (this.x - u - uu + this.xx) * 0.5 / c;
        return DD.fastTwoSum(c, cc);
    }

    static boolean isNotNormal(double a) {
        int baisedExponent = (int)(Double.doubleToRawLongBits(a) >>> 52) & 0x7FF;
        return baisedExponent + Integer.MAX_VALUE >= -2147481602;
    }

    public DD scalb(int exp) {
        double z1;
        double z0;
        double p;
        int m;
        int n;
        if (exp + -2147482626 < -2147481602) {
            double s = DD.twoPow(exp);
            return new DD(this.x * s, this.xx * s);
        }
        if (exp < 0) {
            n = -exp >>> 9;
            m = -(-exp & 0x1FF);
            p = 7.458340731200207E-155;
        } else {
            n = exp >>> 9;
            m = exp & 0x1FF;
            p = 1.3407807929942597E154;
        }
        if (n >= 5) {
            p *= p * 0.5;
            double z02 = this.x * p * p * p;
            double z12 = this.xx * p * p * p;
            return new DD(z02, z12);
        }
        double s = DD.twoPow(m);
        if (n == 4) {
            z0 = this.x * s * p * p * p * p;
            z1 = this.xx * s * p * p * p * p;
        } else if (n == 3) {
            z0 = this.x * s * p * p * p;
            z1 = this.xx * s * p * p * p;
        } else if (n == 2) {
            z0 = this.x * s * p * p;
            z1 = this.xx * s * p * p;
        } else {
            z0 = this.x * s * p;
            z1 = this.xx * s * p;
        }
        return new DD(z0, z1);
    }

    static double twoPow(int n) {
        return Double.longBitsToDouble((long)(n + 1023) << 52);
    }

    public DD frexp(int[] exp) {
        exp[0] = DD.getScale(this.x);
        if (exp[0] == 1024) {
            exp[0] = 0;
            return this;
        }
        exp[0] = exp[0] + 1;
        DD f = this.scalb(-exp[0]);
        if (Math.abs(f.x) == 0.5 && 2.0 * f.x * f.xx < 0.0) {
            f = new DD(f.x * 2.0, f.xx * 2.0);
            exp[0] = exp[0] - 1;
        }
        return f;
    }

    private static int getScale(double a) {
        long bits = Double.doubleToRawLongBits(a) & Long.MAX_VALUE;
        int exp = (int)(bits >>> 52) - 1023;
        if (exp == -1023) {
            if (bits == 0L) {
                return 1024;
            }
            long mantissa = bits & 0xFFFFFFFFFFFFFL;
            exp -= Long.numberOfLeadingZeros(mantissa << 12);
        }
        return exp;
    }

    @Override
    public DD pow(int n) {
        if (n == 1) {
            return this;
        }
        if (n == 0) {
            return ONE;
        }
        if (DD.isNotNormal(this.x)) {
            return new DD(Math.pow(this.x, n), 0.0);
        }
        if (n == -1) {
            return this.reciprocal();
        }
        if (n < 0) {
            return DD.computePow(this.x, this.xx, -n).reciprocal();
        }
        return DD.computePow(this.x, this.xx, n);
    }

    private static DD computePow(double x, double xx, int n) {
        double xh = DD.highPart(x);
        double xl = x - xh;
        double f0 = x;
        double f1 = xx;
        int shift = Integer.numberOfLeadingZeros(n) + 1;
        int bits = n << shift;
        int i = 32 - shift;
        while (i != 0) {
            double u = f0 * f0;
            double v = DD.twoSquareLow(f0, u);
            double w = v + 2.0 * f0 * f1;
            f0 = u + w;
            f1 = DD.fastTwoSumLow(u, w, f0);
            if (bits < 0) {
                u = DD.highPart(f0);
                v = f0 - u;
                w = f0 * x;
                v = DD.twoProductLow(u, v, xh, xl, w);
                u = v + (f0 * xx + f1 * x);
                f0 = w + u;
                f1 = DD.fastTwoSumLow(w, u, f0);
            }
            --i;
            bits <<= 1;
        }
        return new DD(f0, f1);
    }

    public DD pow(int n, long[] exp) {
        if (n == 0) {
            exp[0] = 1L;
            return new DD(0.5, 0.0);
        }
        if (!Double.isFinite(this.x) || this.x == 0.0) {
            exp[0] = 0L;
            return new DD(Math.pow(this.x, n), 0.0);
        }
        int[] ie = new int[]{0};
        DD f = this.frexp(ie);
        long b = ie[0];
        if (Math.abs(f.x) == 0.5 && f.xx == 0.0) {
            double y0 = 0.5 * Math.pow(2.0 * f.x, n);
            double y1 = Math.copySign(0.0, y0 * f.x * this.xx);
            exp[0] = 1L + (b - 1L) * (long)n;
            return new DD(y0, y1);
        }
        if (n < 0) {
            f = DD.computePowScaled(b, f.x, f.xx, -n, exp);
            f = DD.reciprocal(f.x, f.xx);
            f = f.frexp(ie);
            exp[0] = (long)ie[0] - exp[0];
            return f;
        }
        return DD.computePowScaled(b, f.x, f.xx, n, exp);
    }

    private static DD computePowScaled(long b, double x, double xx, int n, long[] exp) {
        long be = b - 1L;
        double b0 = x * 2.0;
        double b1 = xx * 2.0;
        double b0h = DD.highPart(b0);
        double b0l = b0 - b0h;
        long fe = be;
        double f0 = b0;
        double f1 = b1;
        int shift = Integer.numberOfLeadingZeros(n) + 1;
        int bits = n << shift;
        int i = 32 - shift;
        while (i != 0) {
            fe <<= 1;
            double u = f0 * f0;
            double v = DD.twoSquareLow(f0, u);
            double w = v + 2.0 * f0 * f1;
            f0 = u + w;
            f1 = DD.fastTwoSumLow(u, w, f0);
            if (Math.abs(f0) > 3.273390607896142E150) {
                int e = Math.getExponent(f0);
                double s = DD.twoPow(-e);
                fe += (long)e;
                f0 *= s;
                f1 *= s;
            }
            if (bits < 0) {
                fe += be;
                u = DD.highPart(f0);
                v = f0 - u;
                w = f0 * b0;
                v = DD.twoProductLow(u, v, b0h, b0l, w);
                u = v + (f0 * b1 + f1 * b0);
                f0 = w + u;
                f1 = DD.fastTwoSumLow(w, u, f0);
            }
            --i;
            bits <<= 1;
        }
        int[] e = new int[]{0};
        DD f = new DD(f0, f1).frexp(e);
        exp[0] = fe + (long)e[0];
        return f;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DD) {
            DD c = (DD)other;
            return DD.equals(this.x, c.x) && DD.equals(this.xx, c.xx);
        }
        return false;
    }

    public int hashCode() {
        return 31 * (31 + Double.hashCode(this.x + 0.0)) + Double.hashCode(this.xx + 0.0);
    }

    private static boolean equals(double x, double y) {
        return Double.doubleToLongBits(x + 0.0) == Double.doubleToLongBits(y + 0.0);
    }

    public String toString() {
        return new StringBuilder(64).append('(').append(this.x).append(',').append(this.xx).append(')').toString();
    }

    @Override
    public DD zero() {
        return ZERO;
    }

    @Override
    public boolean isZero() {
        return this.x == 0.0;
    }

    @Override
    public DD one() {
        return ONE;
    }

    @Override
    public boolean isOne() {
        return this.x == 1.0 && this.xx == 0.0;
    }

    @Override
    public DD multiply(int n) {
        return DD.multiply(this.x, this.xx, n);
    }
}

