/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.junit.Assert;
import org.junit.Test;

public class LUDecompositionTest {
    private double[][] testData = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 3.0}, {1.0, 0.0, 8.0}};
    private double[][] testDataMinus = new double[][]{{-1.0, -2.0, -3.0}, {-2.0, -5.0, -3.0}, {-1.0, 0.0, -8.0}};
    private double[][] luData = new double[][]{{2.0, 3.0, 3.0}, {0.0, 5.0, 7.0}, {6.0, 9.0, 8.0}};
    private double[][] singular = new double[][]{{2.0, 3.0}, {2.0, 3.0}};
    private double[][] bigSingular = new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 5.0, 3.0, 4.0}, {7.0, 3.0, 256.0, 1930.0}, {3.0, 7.0, 6.0, 8.0}};
    private static final double entryTolerance = 1.0E-15;
    private static final double normTolerance = 1.0E-13;

    @Test
    public void testDimensions() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])this.testData);
        LUDecomposition LU = new LUDecomposition(matrix);
        Assert.assertEquals((long)this.testData.length, (long)LU.getL().getRowDimension());
        Assert.assertEquals((long)this.testData.length, (long)LU.getL().getColumnDimension());
        Assert.assertEquals((long)this.testData.length, (long)LU.getU().getRowDimension());
        Assert.assertEquals((long)this.testData.length, (long)LU.getU().getColumnDimension());
        Assert.assertEquals((long)this.testData.length, (long)LU.getP().getRowDimension());
        Assert.assertEquals((long)this.testData.length, (long)LU.getP().getColumnDimension());
    }

    @Test
    public void testNonSquare() {
        try {
            new LUDecomposition(MatrixUtils.createRealMatrix((double[][])new double[3][2]));
            Assert.fail((String)"Expecting NonSquareMatrixException");
        }
        catch (NonSquareMatrixException nonSquareMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testPAEqualLU() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])this.testData);
        LUDecomposition lu = new LUDecomposition(matrix);
        RealMatrix l = lu.getL();
        RealMatrix u = lu.getU();
        RealMatrix p = lu.getP();
        double norm = l.multiply(u).subtract(p.multiply(matrix)).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)1.0E-13);
        matrix = MatrixUtils.createRealMatrix((double[][])this.testDataMinus);
        lu = new LUDecomposition(matrix);
        l = lu.getL();
        u = lu.getU();
        p = lu.getP();
        norm = l.multiply(u).subtract(p.multiply(matrix)).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)1.0E-13);
        matrix = MatrixUtils.createRealIdentityMatrix((int)17);
        lu = new LUDecomposition(matrix);
        l = lu.getL();
        u = lu.getU();
        p = lu.getP();
        norm = l.multiply(u).subtract(p.multiply(matrix)).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)1.0E-13);
        matrix = MatrixUtils.createRealMatrix((double[][])this.singular);
        lu = new LUDecomposition(matrix);
        Assert.assertFalse((boolean)lu.getSolver().isNonSingular());
        Assert.assertNull((Object)lu.getL());
        Assert.assertNull((Object)lu.getU());
        Assert.assertNull((Object)lu.getP());
        matrix = MatrixUtils.createRealMatrix((double[][])this.bigSingular);
        lu = new LUDecomposition(matrix);
        Assert.assertFalse((boolean)lu.getSolver().isNonSingular());
        Assert.assertNull((Object)lu.getL());
        Assert.assertNull((Object)lu.getU());
        Assert.assertNull((Object)lu.getP());
    }

    @Test
    public void testLLowerTriangular() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])this.testData);
        RealMatrix l = new LUDecomposition(matrix).getL();
        for (int i = 0; i < l.getRowDimension(); ++i) {
            Assert.assertEquals((double)l.getEntry(i, i), (double)1.0, (double)1.0E-15);
            for (int j = i + 1; j < l.getColumnDimension(); ++j) {
                Assert.assertEquals((double)l.getEntry(i, j), (double)0.0, (double)1.0E-15);
            }
        }
    }

    @Test
    public void testUUpperTriangular() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])this.testData);
        RealMatrix u = new LUDecomposition(matrix).getU();
        for (int i = 0; i < u.getRowDimension(); ++i) {
            for (int j = 0; j < i; ++j) {
                Assert.assertEquals((double)u.getEntry(i, j), (double)0.0, (double)1.0E-15);
            }
        }
    }

    @Test
    public void testPPermutation() {
        double e;
        int otherCount;
        int oneCount;
        int zeroCount;
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])this.testData);
        RealMatrix p = new LUDecomposition(matrix).getP();
        RealMatrix ppT = p.multiply(p.transpose());
        RealMatrix id = MatrixUtils.createRealIdentityMatrix((int)p.getRowDimension());
        Assert.assertEquals((double)0.0, (double)ppT.subtract(id).getNorm(), (double)1.0E-13);
        for (int i = 0; i < p.getRowDimension(); ++i) {
            zeroCount = 0;
            oneCount = 0;
            otherCount = 0;
            for (int j = 0; j < p.getColumnDimension(); ++j) {
                e = p.getEntry(i, j);
                if (e == 0.0) {
                    ++zeroCount;
                    continue;
                }
                if (e == 1.0) {
                    ++oneCount;
                    continue;
                }
                ++otherCount;
            }
            Assert.assertEquals((long)(p.getColumnDimension() - 1), (long)zeroCount);
            Assert.assertEquals((long)1L, (long)oneCount);
            Assert.assertEquals((long)0L, (long)otherCount);
        }
        for (int j = 0; j < p.getColumnDimension(); ++j) {
            zeroCount = 0;
            oneCount = 0;
            otherCount = 0;
            for (int i = 0; i < p.getRowDimension(); ++i) {
                e = p.getEntry(i, j);
                if (e == 0.0) {
                    ++zeroCount;
                    continue;
                }
                if (e == 1.0) {
                    ++oneCount;
                    continue;
                }
                ++otherCount;
            }
            Assert.assertEquals((long)(p.getRowDimension() - 1), (long)zeroCount);
            Assert.assertEquals((long)1L, (long)oneCount);
            Assert.assertEquals((long)0L, (long)otherCount);
        }
    }

    @Test
    public void testSingular() {
        LUDecomposition lu = new LUDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData));
        Assert.assertTrue((boolean)lu.getSolver().isNonSingular());
        lu = new LUDecomposition(MatrixUtils.createRealMatrix((double[][])this.singular));
        Assert.assertFalse((boolean)lu.getSolver().isNonSingular());
        lu = new LUDecomposition(MatrixUtils.createRealMatrix((double[][])this.bigSingular));
        Assert.assertFalse((boolean)lu.getSolver().isNonSingular());
    }

    @Test
    public void testMatricesValues1() {
        LUDecomposition lu = new LUDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData));
        RealMatrix lRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.5, 1.0, 0.0}, {0.5, 0.2, 1.0}});
        RealMatrix uRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{2.0, 5.0, 3.0}, {0.0, -2.5, 6.5}, {0.0, 0.0, 0.2}});
        RealMatrix pRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}});
        int[] pivotRef = new int[]{1, 2, 0};
        RealMatrix l = lu.getL();
        Assert.assertEquals((double)0.0, (double)l.subtract(lRef).getNorm(), (double)1.0E-13);
        RealMatrix u = lu.getU();
        Assert.assertEquals((double)0.0, (double)u.subtract(uRef).getNorm(), (double)1.0E-13);
        RealMatrix p = lu.getP();
        Assert.assertEquals((double)0.0, (double)p.subtract(pRef).getNorm(), (double)1.0E-13);
        int[] pivot = lu.getPivot();
        for (int i = 0; i < pivotRef.length; ++i) {
            Assert.assertEquals((long)pivotRef[i], (long)pivot[i]);
        }
        Assert.assertTrue((l == lu.getL() ? 1 : 0) != 0);
        Assert.assertTrue((u == lu.getU() ? 1 : 0) != 0);
        Assert.assertTrue((p == lu.getP() ? 1 : 0) != 0);
    }

    @Test
    public void testMatricesValues2() {
        LUDecomposition lu = new LUDecomposition(MatrixUtils.createRealMatrix((double[][])this.luData));
        RealMatrix lRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.3333333333333333, 0.0, 1.0}});
        RealMatrix uRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{6.0, 9.0, 8.0}, {0.0, 5.0, 7.0}, {0.0, 0.0, 0.3333333333333333}});
        RealMatrix pRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}});
        int[] pivotRef = new int[]{2, 1, 0};
        RealMatrix l = lu.getL();
        Assert.assertEquals((double)0.0, (double)l.subtract(lRef).getNorm(), (double)1.0E-13);
        RealMatrix u = lu.getU();
        Assert.assertEquals((double)0.0, (double)u.subtract(uRef).getNorm(), (double)1.0E-13);
        RealMatrix p = lu.getP();
        Assert.assertEquals((double)0.0, (double)p.subtract(pRef).getNorm(), (double)1.0E-13);
        int[] pivot = lu.getPivot();
        for (int i = 0; i < pivotRef.length; ++i) {
            Assert.assertEquals((long)pivotRef[i], (long)pivot[i]);
        }
        Assert.assertTrue((l == lu.getL() ? 1 : 0) != 0);
        Assert.assertTrue((u == lu.getU() ? 1 : 0) != 0);
        Assert.assertTrue((p == lu.getP() ? 1 : 0) != 0);
    }
}

