/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.junit.Assert;
import org.junit.Test;

public class NormalDistributionTest
extends RealDistributionAbstractTest {
    protected double defaultTolerance = 1.0E-9;

    public NormalDistribution makeDistribution() {
        return new NormalDistribution(2.1, 1.4);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{-2.226325228634938, -1.156887023657177, -0.643949578356075, -0.2027950777320613, 0.305827808237559, 6.42632522863494, 5.35688702365718, 4.843949578356074, 4.40279507773206, 3.89417219176244};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.001, 0.01, 0.025, 0.05, 0.1, 0.999, 0.99, 0.975, 0.95, 0.9};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.00240506434076, 0.019037244431, 0.0417464784322, 0.0736683145538, 0.12535595138, 0.00240506434076, 0.019037244431, 0.0417464784322, 0.0736683145538, 0.12535595138};
    }

    public void setUp() {
        super.setUp();
        this.setTolerance(this.defaultTolerance);
    }

    private void verifyQuantiles() {
        NormalDistribution distribution = (NormalDistribution)this.getDistribution();
        double mu = distribution.getMean();
        double sigma = distribution.getStandardDeviation();
        this.setCumulativeTestPoints(new double[]{mu - 2.0 * sigma, mu - sigma, mu, mu + sigma, mu + 2.0 * sigma, mu + 3.0 * sigma, mu + 4.0 * sigma, mu + 5.0 * sigma});
        this.setCumulativeTestValues(new double[]{0.02275013194817921, 0.158655253931457, 0.5, 0.841344746068543, 0.977249868051821, 0.99865010196837, 0.999968328758167, 0.999999713348428});
        this.verifyCumulativeProbabilities();
    }

    @Test
    public void testQuantiles() {
        this.setDensityTestValues(new double[]{0.0385649760808, 0.172836231799, 0.284958771715, 0.172836231799, 0.0385649760808, 0.00316560600853, 9.55930184035E-5, 1.06194251052E-6});
        this.verifyQuantiles();
        this.verifyDensities();
        this.setDistribution((RealDistribution)new NormalDistribution(0.0, 1.0));
        this.setDensityTestValues(new double[]{0.0539909665132, 0.241970724519, 0.398942280401, 0.241970724519, 0.0539909665132, 0.00443184841194, 1.33830225765E-4, 1.48671951473E-6});
        this.verifyQuantiles();
        this.verifyDensities();
        this.setDistribution((RealDistribution)new NormalDistribution(0.0, 0.1));
        this.setDensityTestValues(new double[]{0.539909665132, 2.41970724519, 3.98942280401, 2.41970724519, 0.539909665132, 0.0443184841194, 0.00133830225765, 1.48671951473E-5});
        this.verifyQuantiles();
        this.verifyDensities();
    }

    @Test
    public void testInverseCumulativeProbabilityExtremes() {
        this.setInverseCumulativeTestPoints(new double[]{0.0, 1.0});
        this.setInverseCumulativeTestValues(new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY});
        this.verifyInverseCumulativeProbabilities();
    }

    @Test
    public void testCumulativeProbability() {
        NormalDistribution dist = new NormalDistribution(0.0, 1.0);
        double x = -10.0;
        double expected = 7.61985E-24;
        double v = dist.cumulativeProbability(x);
        Assert.assertEquals((double)1.0, (double)(v / expected), (double)1.0E-5);
    }

    @Test
    public void testGetMean() {
        NormalDistribution distribution = (NormalDistribution)this.getDistribution();
        Assert.assertEquals((double)2.1, (double)distribution.getMean(), (double)0.0);
    }

    @Test
    public void testGetStandardDeviation() {
        NormalDistribution distribution = (NormalDistribution)this.getDistribution();
        Assert.assertEquals((double)1.4, (double)distribution.getStandardDeviation(), (double)0.0);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testPreconditions() {
        new NormalDistribution(1.0, 0.0);
    }

    @Test
    public void testDensity() {
        double[] x = new double[]{-2.0, -1.0, 0.0, 1.0, 2.0};
        this.checkDensity(0.0, 1.0, x, new double[]{0.05399096651, 0.24197072452, 0.3989422804, 0.24197072452, 0.05399096651});
        this.checkDensity(1.1, 1.0, x, new double[]{0.003266819056, 0.04398359598, 0.217852177033, 0.396952547477, 0.266085249899});
    }

    private void checkDensity(double mean, double sd, double[] x, double[] expected) {
        NormalDistribution d = new NormalDistribution(mean, sd);
        for (int i = 0; i < x.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)d.density(x[i]), (double)1.0E-9);
        }
    }

    @Test
    public void testExtremeValues() {
        NormalDistribution distribution = new NormalDistribution(0.0, 1.0);
        for (int i = 0; i < 100; ++i) {
            double lowerTail = distribution.cumulativeProbability((double)(-i));
            double upperTail = distribution.cumulativeProbability((double)i);
            if (i < 9) {
                Assert.assertTrue((lowerTail > 0.0 ? 1 : 0) != 0);
                Assert.assertTrue((upperTail < 1.0 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((lowerTail < 1.0E-5 ? 1 : 0) != 0);
            Assert.assertTrue((upperTail > 0.99999 ? 1 : 0) != 0);
        }
        Assert.assertEquals((double)distribution.cumulativeProbability(Double.MAX_VALUE), (double)1.0, (double)0.0);
        Assert.assertEquals((double)distribution.cumulativeProbability(-1.7976931348623157E308), (double)0.0, (double)0.0);
        Assert.assertEquals((double)distribution.cumulativeProbability(Double.POSITIVE_INFINITY), (double)1.0, (double)0.0);
        Assert.assertEquals((double)distribution.cumulativeProbability(Double.NEGATIVE_INFINITY), (double)0.0, (double)0.0);
    }

    @Test
    public void testMath280() {
        NormalDistribution normal = new NormalDistribution(0.0, 1.0);
        double result = normal.inverseCumulativeProbability(0.9986501019683698);
        Assert.assertEquals((double)3.0, (double)result, (double)this.defaultTolerance);
        result = normal.inverseCumulativeProbability(0.841344746068543);
        Assert.assertEquals((double)1.0, (double)result, (double)this.defaultTolerance);
        result = normal.inverseCumulativeProbability(0.9999683287581673);
        Assert.assertEquals((double)4.0, (double)result, (double)this.defaultTolerance);
        result = normal.inverseCumulativeProbability(0.9772498680518209);
        Assert.assertEquals((double)2.0, (double)result, (double)this.defaultTolerance);
    }

    @Test
    public void testMoments() {
        double tol = 1.0E-9;
        NormalDistribution dist = new NormalDistribution(0.0, 1.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)0.0, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)1.0, (double)1.0E-9);
        dist = new NormalDistribution(2.2, 1.4);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)2.2, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)1.9599999999999997, (double)1.0E-9);
        dist = new NormalDistribution(-2000.9, 10.4);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)-2000.9, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)108.16000000000001, (double)1.0E-9);
    }
}

