/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.util;

import java.util.BitSet;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.util.FluentBitSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FluentBitSetTest
extends AbstractLangTest {
    private BitSet eightBs;
    private FluentBitSet eightFbs;

    FluentBitSetTest() {
    }

    @BeforeEach
    public void beforeEach() {
        this.eightFbs = this.newInstance();
        for (int i = 0; i < 8; ++i) {
            this.eightFbs.set(i);
        }
        this.eightBs = this.eightFbs.bitSet();
    }

    private FluentBitSet newInstance() {
        return new FluentBitSet();
    }

    private FluentBitSet newInstance(int nbits) {
        return new FluentBitSet(nbits);
    }

    @Test
    void test_and() {
        int i;
        FluentBitSet bs = this.newInstance(128);
        for (i = 64; i < 128; ++i) {
            bs.set(i);
        }
        this.eightFbs.and(bs);
        Assertions.assertNotEquals((Object)this.eightFbs, (Object)bs, (String)"AND failed to clear bits");
        this.eightFbs.set(3);
        bs.set(3);
        this.eightFbs.and(bs);
        Assertions.assertTrue((boolean)bs.get(3), (String)"AND failed to maintain set bits");
        bs.and(this.eightFbs);
        for (i = 64; i < 128; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)"Failed to clear extra bits in the receiver BitSet");
        }
    }

    @Test
    void test_and_BitSet() {
        int i;
        FluentBitSet bs = this.newInstance(128);
        for (i = 64; i < 128; ++i) {
            bs.set(i);
        }
        this.eightFbs.and(bs.bitSet());
        Assertions.assertNotEquals((Object)this.eightFbs, (Object)bs, (String)"AND failed to clear bits");
        this.eightFbs.set(3);
        bs.set(3);
        this.eightFbs.and(bs.bitSet());
        Assertions.assertTrue((boolean)bs.get(3), (String)"AND failed to maintain set bits");
        bs.and(this.eightBs);
        for (i = 64; i < 128; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)"Failed to clear extra bits in the receiver BitSet");
        }
    }

    @Test
    void test_andNot() {
        FluentBitSet bs = (FluentBitSet)this.eightFbs.clone();
        bs.clear(5);
        FluentBitSet bs2 = this.newInstance();
        bs2.set(2);
        bs2.set(3);
        bs.andNot(bs2);
        Assertions.assertEquals((Object)"{0, 1, 4, 6, 7}", (Object)bs.toString(), (String)"Incorrect bitset after andNot");
        bs = this.newInstance(0);
        bs.andNot(bs2);
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Incorrect size");
    }

    @Test
    void test_andNot_BitSet() {
        FluentBitSet bs = (FluentBitSet)this.eightFbs.clone();
        bs.clear(5);
        FluentBitSet bs2 = this.newInstance();
        bs2.set(2);
        bs2.set(3);
        bs.andNot(bs2.bitSet());
        Assertions.assertEquals((Object)"{0, 1, 4, 6, 7}", (Object)bs.toString(), (String)"Incorrect bitset after andNot");
        bs = this.newInstance(0);
        bs.andNot(bs2.bitSet());
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Incorrect size");
    }

    @Test
    void test_cardinality() {
        FluentBitSet bs = this.newInstance(500);
        bs.set(5);
        bs.set(32);
        bs.set(63);
        bs.set(64);
        bs.set(71, 110);
        bs.set(127, 130);
        bs.set(193);
        bs.set(450);
        Assertions.assertEquals((int)48, (int)bs.cardinality(), (String)"cardinality() returned wrong value");
        bs.flip(0, 500);
        Assertions.assertEquals((int)452, (int)bs.cardinality(), (String)"cardinality() returned wrong value");
        bs.clear();
        Assertions.assertEquals((int)0, (int)bs.cardinality(), (String)"cardinality() returned wrong value");
        bs.set(0, 500);
        Assertions.assertEquals((int)500, (int)bs.cardinality(), (String)"cardinality() returned wrong value");
    }

    @Test
    void test_clear() {
        this.eightFbs.clear();
        for (int i = 0; i < 8; ++i) {
            Assertions.assertFalse((boolean)this.eightFbs.get(i), (String)("Clear didn't clear bit " + i));
        }
        Assertions.assertEquals((int)0, (int)this.eightFbs.length(), (String)"Test1: Wrong length");
        FluentBitSet bs = this.newInstance(3400);
        bs.set(0, bs.size() - 1);
        bs.set(bs.size() - 1);
        bs.clear();
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test2: Wrong length");
        Assertions.assertTrue((boolean)bs.isEmpty(), (String)"Test2: isEmpty() returned incorrect value");
        Assertions.assertEquals((int)0, (int)bs.cardinality(), (String)"Test2: cardinality() returned incorrect value");
    }

    @Test
    void test_clearI() {
        this.eightFbs.clear(7);
        Assertions.assertFalse((boolean)this.eightFbs.get(7), (String)"Failed to clear bit");
        for (int i = 0; i < 7; ++i) {
            Assertions.assertTrue((boolean)this.eightFbs.get(i), (String)"Clear cleared incorrect bits");
        }
        this.eightFbs.clear(165);
        Assertions.assertFalse((boolean)this.eightFbs.get(165), (String)"Failed to clear bit");
        LangAssertions.assertIndexOutOfBoundsException(() -> this.eightFbs.clear(-1));
        FluentBitSet bs = this.newInstance(0);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test1: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test1: Wrong size,");
        bs.clear(0);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test2: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test2: Wrong size,");
        bs.clear(60);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test3: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test3: Wrong size,");
        bs.clear(120);
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test4: Wrong size,");
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test4: Wrong length,");
        bs.set(25);
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test5: Wrong size,");
        Assertions.assertEquals((int)26, (int)bs.length(), (String)"Test5: Wrong length,");
        bs.clear(80);
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test6: Wrong size,");
        Assertions.assertEquals((int)26, (int)bs.length(), (String)"Test6: Wrong length,");
        bs.clear(25);
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test7: Wrong size,");
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test7: Wrong length,");
    }

    @Test
    void test_clearII() {
        int i;
        FluentBitSet bitset = this.newInstance();
        for (int i2 = 0; i2 < 20; ++i2) {
            bitset.set(i2);
        }
        bitset.clear(10, 10);
        FluentBitSet bs = this.newInstance(16);
        int initialSize = bs.size();
        bs.set(0, initialSize);
        bs.clear(5);
        bs.clear(15);
        bs.clear(7, 11);
        for (i = 0; i < 7; ++i) {
            if (i == 5) {
                Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
                continue;
            }
            Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have cleared bit " + i));
        }
        for (i = 7; i < 11; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Failed to clear bit " + i));
        }
        for (i = 11; i < initialSize; ++i) {
            if (i == 15) {
                Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
                continue;
            }
            Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have cleared bit " + i));
        }
        for (i = initialSize; i < bs.size(); ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
        }
        bs = this.newInstance(16);
        initialSize = bs.size();
        bs.set(0, initialSize);
        bs.clear(7, 64);
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Failed to grow BitSet");
        for (i = 0; i < 7; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have cleared bit " + i));
        }
        for (i = 7; i < 64; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Failed to clear bit " + i));
        }
        for (i = 64; i < bs.size(); ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
        }
        bs = this.newInstance(32);
        initialSize = bs.size();
        bs.set(0, initialSize);
        bs.clear(0, 64);
        for (i = 0; i < 64; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Failed to clear bit " + i));
        }
        for (i = 64; i < bs.size(); ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
        }
        bs = this.newInstance(32);
        initialSize = bs.size();
        bs.set(0, initialSize);
        bs.clear(0, 65);
        for (i = 0; i < 65; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Failed to clear bit " + i));
        }
        for (i = 65; i < bs.size(); ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
        }
        bs = this.newInstance(128);
        initialSize = bs.size();
        bs.set(0, initialSize);
        bs.clear(7);
        bs.clear(110);
        bs.clear(9, 74);
        for (i = 0; i < 9; ++i) {
            if (i == 7) {
                Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
                continue;
            }
            Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have cleared bit " + i));
        }
        for (i = 9; i < 74; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Failed to clear bit " + i));
        }
        for (i = 74; i < initialSize; ++i) {
            if (i == 110) {
                Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
                continue;
            }
            Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have cleared bit " + i));
        }
        for (i = initialSize; i < bs.size(); ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
        }
        bs = this.newInstance(256);
        bs.set(0, 256);
        bs.clear(7);
        bs.clear(255);
        bs.clear(9, 219);
        for (i = 0; i < 9; ++i) {
            if (i == 7) {
                Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
                continue;
            }
            Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have cleared bit " + i));
        }
        for (i = 9; i < 219; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("failed to clear bit " + i));
        }
        for (i = 219; i < 255; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have cleared bit " + i));
        }
        for (i = 255; i < bs.size(); ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
        }
        bs = this.newInstance(10);
        LangAssertions.assertIndexOutOfBoundsException(() -> this.newInstance(10).clear(-1, 3), "Test1: Attempt to flip with negative index failed to generate exception");
        LangAssertions.assertIndexOutOfBoundsException(() -> this.newInstance(10).clear(2, -1), "Test2: Attempt to flip with negative index failed to generate exception");
        bs.set(2, 4);
        bs.clear(2, 2);
        Assertions.assertTrue((boolean)bs.get(2), (String)"Bit got cleared incorrectly ");
        LangAssertions.assertIndexOutOfBoundsException(() -> this.newInstance(10).clear(4, 2), "Test4: Attempt to flip with illegal args failed to generate exception");
        bs = this.newInstance(0);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test1: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test1: Wrong size,");
        bs.clear(0, 2);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test2: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test2: Wrong size,");
        bs.clear(60, 64);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test3: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test3: Wrong size,");
        bs.clear(64, 120);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test4: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test4: Wrong size,");
        bs.set(25);
        Assertions.assertEquals((int)26, (int)bs.length(), (String)"Test5: Wrong length,");
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test5: Wrong size,");
        bs.clear(60, 64);
        Assertions.assertEquals((int)26, (int)bs.length(), (String)"Test6: Wrong length,");
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test6: Wrong size,");
        bs.clear(64, 120);
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test7: Wrong size,");
        Assertions.assertEquals((int)26, (int)bs.length(), (String)"Test7: Wrong length,");
        bs.clear(80);
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test8: Wrong size,");
        Assertions.assertEquals((int)26, (int)bs.length(), (String)"Test8: Wrong length,");
        bs.clear(25);
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test9: Wrong size,");
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test9: Wrong length,");
    }

    @Test
    void test_clearIntArray() {
        this.eightFbs.clear(new int[]{7});
        Assertions.assertFalse((boolean)this.eightFbs.get(7), (String)"Failed to clear bit");
        for (int i = 0; i < 7; ++i) {
            Assertions.assertTrue((boolean)this.eightFbs.get(i), (String)"Clear cleared incorrect bits");
        }
        this.eightFbs.clear(165);
        Assertions.assertFalse((boolean)this.eightFbs.get(165), (String)"Failed to clear bit");
        LangAssertions.assertIndexOutOfBoundsException(() -> this.eightFbs.clear(-1));
        FluentBitSet bs = this.newInstance(0);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test1: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test1: Wrong size,");
        bs.clear(new int[]{0});
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test2: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test2: Wrong size,");
        bs.clear(new int[]{60});
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test3: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test3: Wrong size,");
        bs.clear(new int[]{120});
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test4: Wrong size,");
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test4: Wrong length,");
        bs.set(25);
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test5: Wrong size,");
        Assertions.assertEquals((int)26, (int)bs.length(), (String)"Test5: Wrong length,");
        bs.clear(new int[]{80});
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test6: Wrong size,");
        Assertions.assertEquals((int)26, (int)bs.length(), (String)"Test6: Wrong length,");
        bs.clear(new int[]{25});
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test7: Wrong size,");
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test7: Wrong length,");
    }

    @Test
    void test_clone() {
        FluentBitSet bs = (FluentBitSet)this.eightFbs.clone();
        Assertions.assertEquals((Object)bs, (Object)this.eightFbs, (String)"clone failed to return equal BitSet");
    }

    @Test
    void test_Constructor() {
        FluentBitSet bs = this.newInstance();
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Create FluentBitSet of incorrect size");
        Assertions.assertEquals((Object)"{}", (Object)bs.toString(), (String)"New FluentBitSet had invalid string representation");
    }

    @Test
    void test_ConstructorInt() {
        FluentBitSet bs = this.newInstance(128);
        Assertions.assertEquals((int)128, (int)bs.size(), (String)"Create FluentBitSet of incorrect size");
        Assertions.assertEquals((Object)"{}", (Object)bs.toString(), (String)("New FluentBitSet had invalid string representation: " + bs));
        bs = this.newInstance(89);
        Assertions.assertEquals((int)128, (int)bs.size(), (String)"Failed to round FluentBitSet element size");
        Assertions.assertThrows(NegativeArraySizeException.class, () -> this.newInstance(-9));
    }

    @Test
    void test_equals() {
        FluentBitSet bs = (FluentBitSet)this.eightFbs.clone();
        Assertions.assertEquals((Object)this.eightFbs, (Object)this.eightFbs, (String)"Same FluentBitSet returned false");
        Assertions.assertEquals((Object)bs, (Object)this.eightFbs, (String)"Identical FluentBitSet returned false");
        bs.clear(6);
        Assertions.assertNotEquals((Object)bs, (Object)this.eightFbs, (String)"Different BitSets returned true");
        Assertions.assertFalse((boolean)this.eightFbs.equals(null), (String)"Different BitSets returned true");
        Assertions.assertFalse((boolean)this.eightFbs.equals(new Object()), (String)"Different BitSets returned true");
        bs = (FluentBitSet)this.eightFbs.clone();
        bs.set(128);
        Assertions.assertNotEquals((Object)bs, (Object)this.eightFbs, (String)"Different sized FluentBitSet with higher bit set returned true");
        bs.clear(128);
        Assertions.assertEquals((Object)bs, (Object)this.eightFbs, (String)"Different sized FluentBitSet with higher bits not set returned false");
    }

    @Test
    void test_flipI() {
        FluentBitSet bs = this.newInstance();
        bs.clear(8);
        bs.clear(9);
        bs.set(10);
        bs.flip(9);
        Assertions.assertFalse((boolean)bs.get(8), (String)"Failed to flip bit");
        Assertions.assertTrue((boolean)bs.get(9), (String)"Failed to flip bit");
        Assertions.assertTrue((boolean)bs.get(10), (String)"Failed to flip bit");
        bs.set(8);
        bs.set(9);
        bs.clear(10);
        bs.flip(9);
        Assertions.assertTrue((boolean)bs.get(8), (String)"Failed to flip bit");
        Assertions.assertFalse((boolean)bs.get(9), (String)"Failed to flip bit");
        Assertions.assertFalse((boolean)bs.get(10), (String)"Failed to flip bit");
        LangAssertions.assertIndexOutOfBoundsException(() -> this.newInstance().flip(-1), "Attempt to flip at negative index failed to generate exception");
        bs.flip(128);
        Assertions.assertEquals((int)192, (int)bs.size(), (String)"Failed to grow BitSet");
        Assertions.assertTrue((boolean)bs.get(128), (String)"Failed to flip bit");
        bs = this.newInstance(64);
        int i = bs.size();
        while (--i >= 0) {
            bs.flip(i);
            Assertions.assertTrue((boolean)bs.get(i), (String)("Test1: Incorrectly flipped bit" + i));
            Assertions.assertEquals((int)(i + 1), (int)bs.length(), (String)"Incorrect length");
            int j = bs.size();
            while (--j > i) {
                Assertions.assertFalse((boolean)bs.get(j), (String)("Test2: Incorrectly flipped bit" + j));
            }
            j = i;
            while (--j >= 0) {
                Assertions.assertFalse((boolean)bs.get(j), (String)("Test3: Incorrectly flipped bit" + j));
            }
            bs.flip(i);
        }
        FluentBitSet bs0 = this.newInstance(0);
        Assertions.assertEquals((int)0, (int)bs0.size(), (String)"Test1: Wrong size");
        Assertions.assertEquals((int)0, (int)bs0.length(), (String)"Test1: Wrong length");
        bs0.flip(0);
        Assertions.assertEquals((int)bs0.size(), (int)64, (String)"Test2: Wrong size");
        Assertions.assertEquals((int)1, (int)bs0.length(), (String)"Test2: Wrong length");
        bs0.flip(63);
        Assertions.assertEquals((int)64, (int)bs0.size(), (String)"Test3: Wrong size");
        Assertions.assertEquals((int)64, (int)bs0.length(), (String)"Test3: Wrong length");
        this.eightFbs.flip(7);
        Assertions.assertFalse((boolean)this.eightFbs.get(7), (String)"Failed to flip bit 7");
        for (int i2 = 0; i2 < 7; ++i2) {
            Assertions.assertTrue((boolean)this.eightFbs.get(i2), (String)"Flip flipped incorrect bits");
        }
        this.eightFbs.flip(127);
        Assertions.assertTrue((boolean)this.eightFbs.get(127), (String)"Failed to flip bit 127");
        this.eightFbs.flip(127);
        Assertions.assertFalse((boolean)this.eightFbs.get(127), (String)"Failed to flip bit 127");
    }

    @Test
    void test_flipII() {
        int i;
        FluentBitSet bitset = this.newInstance();
        for (int i2 = 0; i2 < 20; ++i2) {
            bitset.set(i2);
        }
        bitset.flip(10, 10);
        FluentBitSet bs = this.newInstance(16);
        bs.set(7);
        bs.set(10);
        bs.flip(7, 11);
        for (i = 0; i < 7; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(7), (String)"Failed to flip bit 7");
        Assertions.assertTrue((boolean)bs.get(8), (String)"Failed to flip bit 8");
        Assertions.assertTrue((boolean)bs.get(9), (String)"Failed to flip bit 9");
        Assertions.assertFalse((boolean)bs.get(10), (String)"Failed to flip bit 10");
        for (i = 11; i < bs.size(); ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
        }
        bs = this.newInstance(16);
        bs.set(7);
        bs.set(10);
        bs.flip(7, 64);
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Failed to grow BitSet");
        for (i = 0; i < 7; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(7), (String)"Failed to flip bit 7");
        Assertions.assertTrue((boolean)bs.get(8), (String)"Failed to flip bit 8");
        Assertions.assertTrue((boolean)bs.get(9), (String)"Failed to flip bit 9");
        Assertions.assertFalse((boolean)bs.get(10), (String)"Failed to flip bit 10");
        for (i = 11; i < 64; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("failed to flip bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(64), (String)"Shouldn't have flipped bit 64");
        bs = this.newInstance(32);
        bs.flip(0, 64);
        for (i = 0; i < 64; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("Failed to flip bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(64), (String)"Shouldn't have flipped bit 64");
        bs = this.newInstance(32);
        bs.flip(0, 65);
        for (i = 0; i < 65; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("Failed to flip bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(65), (String)"Shouldn't have flipped bit 65");
        bs = this.newInstance(128);
        bs.set(7);
        bs.set(10);
        bs.set(72);
        bs.set(110);
        bs.flip(9, 74);
        for (i = 0; i < 7; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
        }
        Assertions.assertTrue((boolean)bs.get(7), (String)"Shouldn't have flipped bit 7");
        Assertions.assertFalse((boolean)bs.get(8), (String)"Shouldn't have flipped bit 8");
        Assertions.assertTrue((boolean)bs.get(9), (String)"Failed to flip bit 9");
        Assertions.assertFalse((boolean)bs.get(10), (String)"Failed to flip bit 10");
        for (i = 11; i < 72; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("failed to flip bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(72), (String)"Failed to flip bit 72");
        Assertions.assertTrue((boolean)bs.get(73), (String)"Failed to flip bit 73");
        for (i = 74; i < 110; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
        }
        Assertions.assertTrue((boolean)bs.get(110), (String)"Shouldn't have flipped bit 110");
        for (i = 111; i < bs.size(); ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
        }
        bs = this.newInstance(256);
        bs.set(7);
        bs.set(10);
        bs.set(72);
        bs.set(110);
        bs.set(181);
        bs.set(220);
        bs.flip(9, 219);
        for (i = 0; i < 7; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
        }
        Assertions.assertTrue((boolean)bs.get(7), (String)"Shouldn't have flipped bit 7");
        Assertions.assertFalse((boolean)bs.get(8), (String)"Shouldn't have flipped bit 8");
        Assertions.assertTrue((boolean)bs.get(9), (String)"Failed to flip bit 9");
        Assertions.assertFalse((boolean)bs.get(10), (String)"Failed to flip bit 10");
        for (i = 11; i < 72; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("failed to flip bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(72), (String)"Failed to flip bit 72");
        for (i = 73; i < 110; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("failed to flip bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(110), (String)"Failed to flip bit 110");
        for (i = 111; i < 181; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("failed to flip bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(181), (String)"Failed to flip bit 181");
        for (i = 182; i < 219; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("failed to flip bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(219), (String)"Shouldn't have flipped bit 219");
        Assertions.assertTrue((boolean)bs.get(220), (String)"Shouldn't have flipped bit 220");
        for (i = 221; i < bs.size(); ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
        }
        bs = this.newInstance(10);
        try {
            bs.flip(-1, 3);
            Assertions.fail((String)"Test1: Attempt to flip with  negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            bs.flip(2, -1);
            Assertions.fail((String)"Test2: Attempt to flip with negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            bs.flip(4, 2);
            Assertions.fail((String)"Test4: Attempt to flip with illegal args failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    void test_getI() {
        FluentBitSet bs = this.newInstance();
        bs.set(8);
        Assertions.assertFalse((boolean)this.eightFbs.get(99), (String)"Get returned true for index out of range");
        Assertions.assertTrue((boolean)this.eightFbs.get(3), (String)"Get returned false for set value");
        Assertions.assertFalse((boolean)bs.get(0), (String)"Get returned true for a non set value");
        LangAssertions.assertIndexOutOfBoundsException(() -> this.newInstance().get(-1), "Attempt to get at negative index failed to generate exception");
        bs = this.newInstance(1);
        Assertions.assertFalse((boolean)bs.get(64), (String)"Access greater than size");
        bs = this.newInstance();
        bs.set(63);
        Assertions.assertTrue((boolean)bs.get(63), (String)"Test highest bit");
        bs = this.newInstance(0);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test1: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test1: Wrong size,");
        bs.get(2);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test2: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test2: Wrong size,");
        bs.get(70);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test3: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test3: Wrong size,");
    }

    @Test
    void test_getII() {
        FluentBitSet bitset = this.newInstance(30);
        bitset.get(3, 3);
        FluentBitSet bs = this.newInstance(512);
        bs.set(3, 9);
        bs.set(10, 20);
        bs.set(60, 75);
        bs.set(121);
        bs.set(130, 140);
        FluentBitSet resultbs = bs.get(3, 6);
        FluentBitSet correctbs = this.newInstance(3);
        correctbs.set(0, 3);
        Assertions.assertEquals((Object)correctbs, (Object)resultbs, (String)"Test1: Returned incorrect BitSet");
        resultbs = bs.get(100, 125);
        correctbs = this.newInstance(25);
        correctbs.set(21);
        Assertions.assertEquals((Object)correctbs, (Object)resultbs, (String)"Test2: Returned incorrect BitSet");
        resultbs = bs.get(15, 125);
        correctbs = this.newInstance(25);
        correctbs.set(0, 5);
        correctbs.set(45, 60);
        correctbs.set(106);
        Assertions.assertEquals((Object)correctbs, (Object)resultbs, (String)"Test3: Returned incorrect BitSet");
        resultbs = bs.get(70, 145);
        correctbs = this.newInstance(75);
        correctbs.set(0, 5);
        correctbs.set(51);
        correctbs.set(60, 70);
        Assertions.assertEquals((Object)correctbs, (Object)resultbs, (String)"Test4: Returned incorrect BitSet");
        resultbs = bs.get(5, 145);
        correctbs = this.newInstance(140);
        correctbs.set(0, 4);
        correctbs.set(5, 15);
        correctbs.set(55, 70);
        correctbs.set(116);
        correctbs.set(125, 135);
        Assertions.assertEquals((Object)correctbs, (Object)resultbs, (String)"Test5: Returned incorrect BitSet");
        resultbs = bs.get(5, 250);
        correctbs = this.newInstance(200);
        correctbs.set(0, 4);
        correctbs.set(5, 15);
        correctbs.set(55, 70);
        correctbs.set(116);
        correctbs.set(125, 135);
        Assertions.assertEquals((Object)correctbs, (Object)resultbs, (String)"Test6: Returned incorrect BitSet");
        Assertions.assertEquals((Object)bs.get(0, bs.size()), (Object)bs, (String)"equality principle 1 ");
        FluentBitSet bs2 = this.newInstance(129);
        bs2.set(0, 20);
        bs2.set(62, 65);
        bs2.set(121, 123);
        resultbs = bs2.get(1, 124);
        correctbs = this.newInstance(129);
        correctbs.set(0, 19);
        correctbs.set(61, 64);
        correctbs.set(120, 122);
        Assertions.assertEquals((Object)correctbs, (Object)resultbs, (String)"Test7: Returned incorrect BitSet");
        bs2 = this.newInstance(128);
        bs2.set(2, 20);
        bs2.set(62);
        bs2.set(121, 123);
        bs2.set(127);
        resultbs = bs2.get(0, bs2.size());
        Assertions.assertEquals((Object)resultbs, (Object)bs2, (String)"equality principle 2 ");
        bs2 = this.newInstance(128);
        bs2.set(2, 20);
        bs2.set(62);
        bs2.set(121, 123);
        bs2.set(127);
        bs2.flip(0, 128);
        resultbs = bs2.get(0, bs.size());
        Assertions.assertEquals((Object)resultbs, (Object)bs2, (String)"equality principle 3 ");
        bs = this.newInstance(0);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test1: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test1: Wrong size,");
        bs.get(0, 2);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test2: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test2: Wrong size,");
        bs.get(60, 64);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test3: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test3: Wrong size,");
        bs.get(64, 120);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test4: Wrong length,");
        Assertions.assertEquals((int)0, (int)bs.size(), (String)"Test4: Wrong size,");
        bs.set(25);
        Assertions.assertEquals((int)26, (int)bs.length(), (String)"Test5: Wrong length,");
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test5: Wrong size,");
        bs.get(60, 64);
        Assertions.assertEquals((int)26, (int)bs.length(), (String)"Test6: Wrong length,");
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test6: Wrong size,");
        bs.get(64, 120);
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test7: Wrong size,");
        Assertions.assertEquals((int)26, (int)bs.length(), (String)"Test7: Wrong length,");
        bs.get(80);
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test8: Wrong size,");
        Assertions.assertEquals((int)26, (int)bs.length(), (String)"Test8: Wrong length,");
        bs.get(25);
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Test9: Wrong size,");
        Assertions.assertEquals((int)26, (int)bs.length(), (String)"Test9: Wrong length,");
    }

    @Test
    void test_hashCode() {
        FluentBitSet bs = (FluentBitSet)this.eightFbs.clone();
        bs.clear(2);
        bs.clear(6);
        Assertions.assertEquals((int)bs.bitSet().hashCode(), (int)bs.hashCode(), (String)"BitSet returns wrong hash value");
        bs.set(10);
        bs.clear(3);
        Assertions.assertEquals((int)97, (int)bs.hashCode(), (String)"BitSet returns wrong hash value");
    }

    @Test
    void test_intersects() {
        FluentBitSet bs = this.newInstance(500);
        bs.set(5);
        bs.set(63);
        bs.set(64);
        bs.set(71, 110);
        bs.set(127, 130);
        bs.set(192);
        bs.set(450);
        FluentBitSet bs2 = this.newInstance(8);
        Assertions.assertFalse((boolean)bs.intersects(bs2), (String)"Test1: intersects() returned incorrect value");
        Assertions.assertFalse((boolean)bs2.intersects(bs), (String)"Test1: intersects() returned incorrect value");
        bs2.set(4);
        Assertions.assertFalse((boolean)bs.intersects(bs2), (String)"Test2: intersects() returned incorrect value");
        Assertions.assertFalse((boolean)bs2.intersects(bs), (String)"Test2: intersects() returned incorrect value");
        bs2.clear();
        bs2.set(5);
        Assertions.assertTrue((boolean)bs.intersects(bs2), (String)"Test3: intersects() returned incorrect value");
        Assertions.assertTrue((boolean)bs2.intersects(bs), (String)"Test3: intersects() returned incorrect value");
        bs2.clear();
        bs2.set(63);
        Assertions.assertTrue((boolean)bs.intersects(bs2), (String)"Test4: intersects() returned incorrect value");
        Assertions.assertTrue((boolean)bs2.intersects(bs), (String)"Test4: intersects() returned incorrect value");
        bs2.clear();
        bs2.set(80);
        Assertions.assertTrue((boolean)bs.intersects(bs2), (String)"Test5: intersects() returned incorrect value");
        Assertions.assertTrue((boolean)bs2.intersects(bs), (String)"Test5: intersects() returned incorrect value");
        bs2.clear();
        bs2.set(127);
        Assertions.assertTrue((boolean)bs.intersects(bs2), (String)"Test6: intersects() returned incorrect value");
        Assertions.assertTrue((boolean)bs2.intersects(bs), (String)"Test6: intersects() returned incorrect value");
        bs2.clear();
        bs2.set(192);
        Assertions.assertTrue((boolean)bs.intersects(bs2), (String)"Test7: intersects() returned incorrect value");
        Assertions.assertTrue((boolean)bs2.intersects(bs), (String)"Test7: intersects() returned incorrect value");
        bs2.clear();
        bs2.set(450);
        Assertions.assertTrue((boolean)bs.intersects(bs2), (String)"Test8: intersects() returned incorrect value");
        Assertions.assertTrue((boolean)bs2.intersects(bs), (String)"Test8: intersects() returned incorrect value");
        bs2.clear();
        bs2.set(500);
        Assertions.assertFalse((boolean)bs.intersects(bs2), (String)"Test9: intersects() returned incorrect value");
        Assertions.assertFalse((boolean)bs2.intersects(bs), (String)"Test9: intersects() returned incorrect value");
    }

    @Test
    void test_intersects_BitSet() {
        FluentBitSet bs = this.newInstance(500);
        bs.set(5);
        bs.set(63);
        bs.set(64);
        bs.set(71, 110);
        bs.set(127, 130);
        bs.set(192);
        bs.set(450);
        FluentBitSet bs2 = this.newInstance(8);
        Assertions.assertFalse((boolean)bs.intersects(bs2.bitSet()), (String)"Test1: intersects() returned incorrect value");
        Assertions.assertFalse((boolean)bs2.intersects(bs.bitSet()), (String)"Test1: intersects() returned incorrect value");
        bs2.set(4);
        Assertions.assertFalse((boolean)bs.intersects(bs2.bitSet()), (String)"Test2: intersects() returned incorrect value");
        Assertions.assertFalse((boolean)bs2.intersects(bs.bitSet()), (String)"Test2: intersects() returned incorrect value");
        bs2.clear();
        bs2.set(5);
        Assertions.assertTrue((boolean)bs.intersects(bs2.bitSet()), (String)"Test3: intersects() returned incorrect value");
        Assertions.assertTrue((boolean)bs2.intersects(bs.bitSet()), (String)"Test3: intersects() returned incorrect value");
        bs2.clear();
        bs2.set(63);
        Assertions.assertTrue((boolean)bs.intersects(bs2.bitSet()), (String)"Test4: intersects() returned incorrect value");
        Assertions.assertTrue((boolean)bs2.intersects(bs.bitSet()), (String)"Test4: intersects() returned incorrect value");
        bs2.clear();
        bs2.set(80);
        Assertions.assertTrue((boolean)bs.intersects(bs2.bitSet()), (String)"Test5: intersects() returned incorrect value");
        Assertions.assertTrue((boolean)bs2.intersects(bs.bitSet()), (String)"Test5: intersects() returned incorrect value");
        bs2.clear();
        bs2.set(127);
        Assertions.assertTrue((boolean)bs.intersects(bs2.bitSet()), (String)"Test6: intersects() returned incorrect value");
        Assertions.assertTrue((boolean)bs2.intersects(bs.bitSet()), (String)"Test6: intersects() returned incorrect value");
        bs2.clear();
        bs2.set(192);
        Assertions.assertTrue((boolean)bs.intersects(bs2.bitSet()), (String)"Test7: intersects() returned incorrect value");
        Assertions.assertTrue((boolean)bs2.intersects(bs.bitSet()), (String)"Test7: intersects() returned incorrect value");
        bs2.clear();
        bs2.set(450);
        Assertions.assertTrue((boolean)bs.intersects(bs2.bitSet()), (String)"Test8: intersects() returned incorrect value");
        Assertions.assertTrue((boolean)bs2.intersects(bs.bitSet()), (String)"Test8: intersects() returned incorrect value");
        bs2.clear();
        bs2.set(500);
        Assertions.assertFalse((boolean)bs.intersects(bs2.bitSet()), (String)"Test9: intersects() returned incorrect value");
        Assertions.assertFalse((boolean)bs2.intersects(bs.bitSet()), (String)"Test9: intersects() returned incorrect value");
    }

    @Test
    void test_isEmpty() {
        FluentBitSet bs = this.newInstance(500);
        Assertions.assertTrue((boolean)bs.isEmpty(), (String)"Test: isEmpty() returned wrong value");
        bs.set(3);
        Assertions.assertFalse((boolean)bs.isEmpty(), (String)"Test0: isEmpty() returned wrong value");
        bs.clear();
        bs.set(12);
        Assertions.assertFalse((boolean)bs.isEmpty(), (String)"Test1: isEmpty() returned wrong value");
        bs.clear();
        bs.set(128);
        Assertions.assertFalse((boolean)bs.isEmpty(), (String)"Test2: isEmpty() returned wrong value");
        bs.clear();
        bs.set(459);
        Assertions.assertFalse((boolean)bs.isEmpty(), (String)"Test3: isEmpty() returned wrong value");
        bs.clear();
        bs.set(511);
        Assertions.assertFalse((boolean)bs.isEmpty(), (String)"Test4: isEmpty() returned wrong value");
    }

    @Test
    void test_length() {
        FluentBitSet bs = this.newInstance();
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"BitSet returned wrong length");
        bs.set(5);
        Assertions.assertEquals((int)6, (int)bs.length(), (String)"BitSet returned wrong length");
        bs.set(10);
        Assertions.assertEquals((int)11, (int)bs.length(), (String)"BitSet returned wrong length");
        bs.set(432);
        Assertions.assertEquals((int)433, (int)bs.length(), (String)"BitSet returned wrong length");
        bs.set(300);
        Assertions.assertEquals((int)433, (int)bs.length(), (String)"BitSet returned wrong length");
    }

    @Test
    void test_nextClearBitI() {
        FluentBitSet bs = this.newInstance(500);
        bs.set(0, bs.size() - 1);
        bs.set(bs.size() - 1);
        bs.clear(5);
        bs.clear(32);
        bs.clear(63);
        bs.clear(64);
        bs.clear(71, 110);
        bs.clear(127, 130);
        bs.clear(193);
        bs.clear(450);
        try {
            bs.nextClearBit(-1);
            Assertions.fail((String)"Expected IndexOutOfBoundsException for negative index");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assertions.assertEquals((int)5, (int)bs.nextClearBit(0), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)5, (int)bs.nextClearBit(5), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)32, (int)bs.nextClearBit(6), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)32, (int)bs.nextClearBit(32), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)63, (int)bs.nextClearBit(33), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)63, (int)bs.nextClearBit(63), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)64, (int)bs.nextClearBit(64), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)71, (int)bs.nextClearBit(65), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)71, (int)bs.nextClearBit(71), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)72, (int)bs.nextClearBit(72), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)127, (int)bs.nextClearBit(110), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)127, (int)bs.nextClearBit(127), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)128, (int)bs.nextClearBit(128), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)193, (int)bs.nextClearBit(130), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)193, (int)bs.nextClearBit(191), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)193, (int)bs.nextClearBit(192), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)193, (int)bs.nextClearBit(193), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)450, (int)bs.nextClearBit(194), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)450, (int)bs.nextClearBit(255), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)450, (int)bs.nextClearBit(256), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)450, (int)bs.nextClearBit(450), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)512, (int)bs.nextClearBit(451), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)512, (int)bs.nextClearBit(511), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)512, (int)bs.nextClearBit(512), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)513, (int)bs.nextClearBit(513), (String)"nextClearBit() returned the wrong value");
        Assertions.assertEquals((int)800, (int)bs.nextClearBit(800), (String)"nextClearBit() returned the wrong value");
    }

    @Test
    void test_nextSetBitI() {
        FluentBitSet bs = this.newInstance(500);
        bs.set(5);
        bs.set(32);
        bs.set(63);
        bs.set(64);
        bs.set(71, 110);
        bs.set(127, 130);
        bs.set(193);
        bs.set(450);
        try {
            bs.nextSetBit(-1);
            Assertions.fail((String)"Expected IndexOutOfBoundsException for negative index");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assertions.assertEquals((int)5, (int)bs.nextSetBit(0), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)5, (int)bs.nextSetBit(5), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)32, (int)bs.nextSetBit(6), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)32, (int)bs.nextSetBit(32), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)63, (int)bs.nextSetBit(33), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)63, (int)bs.nextSetBit(63), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)64, (int)bs.nextSetBit(64), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)71, (int)bs.nextSetBit(65), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)71, (int)bs.nextSetBit(71), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)72, (int)bs.nextSetBit(72), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)127, (int)bs.nextSetBit(110), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)127, (int)bs.nextSetBit(127), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)128, (int)bs.nextSetBit(128), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)193, (int)bs.nextSetBit(130), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)193, (int)bs.nextSetBit(191), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)193, (int)bs.nextSetBit(192), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)193, (int)bs.nextSetBit(193), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)450, (int)bs.nextSetBit(194), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)450, (int)bs.nextSetBit(255), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)450, (int)bs.nextSetBit(256), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)450, (int)bs.nextSetBit(450), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)-1, (int)bs.nextSetBit(451), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)-1, (int)bs.nextSetBit(511), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)-1, (int)bs.nextSetBit(512), (String)"nextSetBit() returned the wrong value");
        Assertions.assertEquals((int)-1, (int)bs.nextSetBit(800), (String)"nextSetBit() returned the wrong value");
    }

    @Test
    void test_or() {
        int i;
        FluentBitSet bs = this.newInstance(128);
        bs.or(this.eightFbs);
        for (i = 0; i < 8; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)"OR failed to set bits");
        }
        bs = this.newInstance(0);
        bs.or(this.eightFbs);
        for (i = 0; i < 8; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)"OR(0) failed to set bits");
        }
        this.eightFbs.clear(5);
        bs = this.newInstance(128);
        bs.or(this.eightFbs);
        Assertions.assertFalse((boolean)bs.get(5), (String)"OR set a bit which should be off");
    }

    @Test
    void test_or_BitSet() {
        int i;
        FluentBitSet bs = this.newInstance(128);
        bs.or(this.eightFbs.bitSet());
        for (i = 0; i < 8; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)"OR failed to set bits");
        }
        bs = this.newInstance(0);
        bs.or(this.eightFbs.bitSet());
        for (i = 0; i < 8; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)"OR(0) failed to set bits");
        }
        this.eightFbs.clear(5);
        bs = this.newInstance(128);
        bs.or(this.eightFbs.bitSet());
        Assertions.assertFalse((boolean)bs.get(5), (String)"OR set a bit which should be off");
    }

    @Test
    void test_or_FluentBitSetArray() {
        int i;
        FluentBitSet bs = this.newInstance(128);
        bs.or(new FluentBitSet[]{this.eightFbs});
        for (i = 0; i < 8; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)"OR failed to set bits");
        }
        bs = this.newInstance(0);
        bs.or(new FluentBitSet[]{this.eightFbs});
        for (i = 0; i < 8; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)"OR(0) failed to set bits");
        }
        this.eightFbs.clear(5);
        bs = this.newInstance(128);
        bs.or(new FluentBitSet[]{this.eightFbs});
        Assertions.assertFalse((boolean)bs.get(5), (String)"OR set a bit which should be off");
    }

    @Test
    void test_previousClearBit() {
        FluentBitSet bs = this.newInstance();
        Assertions.assertEquals((int)1, (int)bs.previousClearBit(1), (String)"previousClearBit");
    }

    @Test
    void test_previousSetBit() {
        FluentBitSet bs = this.newInstance();
        Assertions.assertEquals((int)-1, (int)bs.previousSetBit(1), (String)"previousSetBit");
    }

    @Test
    void test_setII() {
        int i;
        FluentBitSet bitset = this.newInstance(30);
        bitset.set(29, 29);
        FluentBitSet bs = this.newInstance(16);
        bs.set(5);
        bs.set(15);
        bs.set(7, 11);
        for (i = 0; i < 7; ++i) {
            if (i == 5) {
                Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
                continue;
            }
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have set bit " + i));
        }
        for (i = 7; i < 11; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("Failed to set bit " + i));
        }
        for (i = 11; i < bs.size(); ++i) {
            if (i == 15) {
                Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
                continue;
            }
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have set bit " + i));
        }
        bs = this.newInstance(16);
        bs.set(7, 64);
        Assertions.assertEquals((int)64, (int)bs.size(), (String)"Failed to grow BitSet");
        for (i = 0; i < 7; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have set bit " + i));
        }
        for (i = 7; i < 64; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("Failed to set bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(64), (String)"Shouldn't have set bit 64");
        bs = this.newInstance(32);
        bs.set(0, 64);
        for (i = 0; i < 64; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("Failed to set bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(64), (String)"Shouldn't have set bit 64");
        bs = this.newInstance(32);
        bs.set(0, 65);
        for (i = 0; i < 65; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("Failed to set bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(65), (String)"Shouldn't have set bit 65");
        bs = this.newInstance(128);
        bs.set(7);
        bs.set(110);
        bs.set(9, 74);
        for (i = 0; i < 9; ++i) {
            if (i == 7) {
                Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
                continue;
            }
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have set bit " + i));
        }
        for (i = 9; i < 74; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("Failed to set bit " + i));
        }
        for (i = 74; i < bs.size(); ++i) {
            if (i == 110) {
                Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
                continue;
            }
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have set bit " + i));
        }
        bs = this.newInstance(256);
        bs.set(7);
        bs.set(255);
        bs.set(9, 219);
        for (i = 0; i < 9; ++i) {
            if (i == 7) {
                Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have set flipped " + i));
                continue;
            }
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have set bit " + i));
        }
        for (i = 9; i < 219; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("failed to set bit " + i));
        }
        for (i = 219; i < 255; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have set bit " + i));
        }
        Assertions.assertTrue((boolean)bs.get(255), (String)"Shouldn't have flipped bit 255");
        bs = this.newInstance(10);
        try {
            bs.set(-1, 3);
            Assertions.fail((String)"Test1: Attempt to flip with  negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            bs.set(2, -1);
            Assertions.fail((String)"Test2: Attempt to flip with negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        bs.set(2, 2);
        Assertions.assertFalse((boolean)bs.get(2), (String)"Bit got set incorrectly ");
        try {
            bs.set(4, 2);
            Assertions.fail((String)"Test4: Attempt to flip with illegal args failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    void test_setIIZ() {
        this.eightFbs.set(3, 6, false);
        Assertions.assertTrue((!this.eightFbs.get(3) && !this.eightFbs.get(4) && !this.eightFbs.get(5) ? 1 : 0) != 0, (String)"Should have set bits 3, 4, and 5 to false");
        this.eightFbs.set(3, 6, true);
        Assertions.assertTrue((this.eightFbs.get(3) && this.eightFbs.get(4) && this.eightFbs.get(5) ? 1 : 0) != 0, (String)"Should have set bits 3, 4, and 5 to true");
    }

    @Test
    void test_setInclusive() {
        int i;
        FluentBitSet bitset = this.newInstance(30);
        bitset.set(29, 29);
        FluentBitSet bs = this.newInstance(16);
        bs.set(5);
        bs.set(15);
        bs.setInclusive(7, 11);
        for (i = 0; i < 7; ++i) {
            if (i == 5) {
                Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
                continue;
            }
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have set bit " + i));
        }
        for (i = 7; i < 12; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("Failed to set bit " + i));
        }
        for (i = 12; i < bs.size(); ++i) {
            if (i == 15) {
                Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
                continue;
            }
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have set bit " + i));
        }
        bs = this.newInstance(16);
        bs.setInclusive(7, 64);
        Assertions.assertEquals((int)128, (int)bs.size(), (String)"Failed to grow BitSet");
        for (i = 0; i < 7; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have set bit " + i));
        }
        for (i = 7; i < 65; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("Failed to set bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(65), (String)"Shouldn't have set bit 64");
        bs = this.newInstance(32);
        bs.setInclusive(0, 64);
        for (i = 0; i < 65; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("Failed to set bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(65), (String)"Shouldn't have set bit 64");
        bs = this.newInstance(32);
        bs.setInclusive(0, 65);
        for (i = 0; i < 66; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("Failed to set bit " + i));
        }
        Assertions.assertFalse((boolean)bs.get(66), (String)"Shouldn't have set bit 65");
        bs = this.newInstance(128);
        bs.set(7);
        bs.set(110);
        bs.setInclusive(9, 74);
        for (i = 0; i < 9; ++i) {
            if (i == 7) {
                Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
                continue;
            }
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have set bit " + i));
        }
        for (i = 9; i < 75; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("Failed to set bit " + i));
        }
        for (i = 75; i < bs.size(); ++i) {
            if (i == 110) {
                Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have flipped bit " + i));
                continue;
            }
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have set bit " + i));
        }
        bs = this.newInstance(256);
        bs.set(7);
        bs.set(255);
        bs.setInclusive(9, 219);
        for (i = 0; i < 9; ++i) {
            if (i == 7) {
                Assertions.assertTrue((boolean)bs.get(i), (String)("Shouldn't have set flipped " + i));
                continue;
            }
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have set bit " + i));
        }
        for (i = 9; i < 220; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)("failed to set bit " + i));
        }
        for (i = 220; i < 255; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)("Shouldn't have set bit " + i));
        }
        Assertions.assertTrue((boolean)bs.get(255), (String)"Shouldn't have flipped bit 255");
        bs = this.newInstance(10);
        try {
            bs.setInclusive(-1, 3);
            Assertions.fail((String)"Test1: Attempt to flip with  negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            bs.setInclusive(2, -1);
            Assertions.fail((String)"Test2: Attempt to flip with negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        bs.setInclusive(2, 2);
        Assertions.assertFalse((boolean)bs.get(3), (String)"Bit got set incorrectly ");
        try {
            bs.setInclusive(4, 2);
            Assertions.fail((String)"Test4: Attempt to flip with illegal args failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    void test_setInt() {
        FluentBitSet bs = this.newInstance();
        bs.set(8);
        Assertions.assertTrue((boolean)bs.get(8), (String)"Failed to set bit");
        try {
            bs.set(-1);
            Assertions.fail((String)"Attempt to set at negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        bs.set(128);
        Assertions.assertEquals((int)192, (int)bs.size(), (String)"Failed to grow BitSet");
        Assertions.assertTrue((boolean)bs.get(128), (String)"Failed to set bit");
        bs = this.newInstance(64);
        int i = bs.size();
        while (--i >= 0) {
            bs.set(i);
            Assertions.assertTrue((boolean)bs.get(i), (String)"Incorrectly set");
            Assertions.assertEquals((int)(i + 1), (int)bs.length(), (String)"Incorrect length");
            int j = bs.size();
            while (--j > i) {
                Assertions.assertFalse((boolean)bs.get(j), (String)("Incorrectly set bit " + j));
            }
            j = i;
            while (--j >= 0) {
                Assertions.assertFalse((boolean)bs.get(j), (String)("Incorrectly set bit " + j));
            }
            bs.clear(i);
        }
        bs = this.newInstance(0);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test1: Wrong length");
        bs.set(0);
        Assertions.assertEquals((int)1, (int)bs.length(), (String)"Test2: Wrong length");
    }

    @Test
    void test_setIntArray() {
        FluentBitSet bs = this.newInstance();
        bs.set(new int[]{8});
        Assertions.assertTrue((boolean)bs.get(8), (String)"Failed to set bit");
        try {
            bs.set(new int[]{-1});
            Assertions.fail((String)"Attempt to set at negative index failed to generate exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        bs.set(new int[]{128});
        Assertions.assertEquals((int)192, (int)bs.size(), (String)"Failed to grow BitSet");
        Assertions.assertTrue((boolean)bs.get(128), (String)"Failed to set bit");
        bs = this.newInstance(64);
        int i = bs.size();
        while (--i >= 0) {
            bs.set(new int[]{i});
            Assertions.assertTrue((boolean)bs.get(i), (String)"Incorrectly set");
            Assertions.assertEquals((int)(i + 1), (int)bs.length(), (String)"Incorrect length");
            int j = bs.size();
            while (--j > i) {
                Assertions.assertFalse((boolean)bs.get(j), (String)("Incorrectly set bit " + j));
            }
            j = i;
            while (--j >= 0) {
                Assertions.assertFalse((boolean)bs.get(j), (String)("Incorrectly set bit " + j));
            }
            bs.clear(i);
        }
        bs = this.newInstance(0);
        Assertions.assertEquals((int)0, (int)bs.length(), (String)"Test1: Wrong length");
        bs.set(new int[]{0});
        Assertions.assertEquals((int)1, (int)bs.length(), (String)"Test2: Wrong length");
    }

    @Test
    void test_setIZ() {
        this.eightFbs.set(5, false);
        Assertions.assertFalse((boolean)this.eightFbs.get(5), (String)"Should have set bit 5 to true");
        this.eightFbs.set(5, true);
        Assertions.assertTrue((boolean)this.eightFbs.get(5), (String)"Should have set bit 5 to false");
    }

    @Test
    void test_setRangeInclusive() {
        Assertions.assertEquals((int)64, (int)this.eightFbs.size(), (String)"Returned incorrect size");
        this.eightFbs.set(129);
        Assertions.assertTrue((this.eightFbs.size() >= 129 ? 1 : 0) != 0, (String)"Returned incorrect size");
    }

    @Test
    void test_size() {
        Assertions.assertEquals((int)64, (int)this.eightFbs.size(), (String)"Returned incorrect size");
        this.eightFbs.set(129);
        Assertions.assertTrue((this.eightFbs.size() >= 129 ? 1 : 0) != 0, (String)"Returned incorrect size");
    }

    @Test
    void test_stream() {
        FluentBitSet bs = this.newInstance();
        Assertions.assertEquals((long)0L, (long)bs.stream().count(), (String)"stream");
    }

    @Test
    void test_toByteArray() {
        FluentBitSet bs = this.newInstance();
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])bs.toByteArray(), (String)"stream");
    }

    @Test
    void test_toLongArray() {
        FluentBitSet bs = this.newInstance();
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])bs.toLongArray(), (String)"stream");
    }

    @Test
    void test_toString() {
        Assertions.assertEquals((Object)"{0, 1, 2, 3, 4, 5, 6, 7}", (Object)this.eightFbs.toString(), (String)"Returned incorrect string representation");
        this.eightFbs.clear(2);
        Assertions.assertEquals((Object)"{0, 1, 3, 4, 5, 6, 7}", (Object)this.eightFbs.toString(), (String)"Returned incorrect string representation");
    }

    @Test
    void test_xor() {
        int i;
        FluentBitSet bs = (FluentBitSet)this.eightFbs.clone();
        bs.xor(this.eightFbs);
        for (i = 0; i < 8; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)"XOR failed to clear bits");
        }
        bs.xor(this.eightFbs);
        for (i = 0; i < 8; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)"XOR failed to set bits");
        }
        bs = this.newInstance(0);
        bs.xor(this.eightFbs);
        for (i = 0; i < 8; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)"XOR(0) failed to set bits");
        }
        bs = this.newInstance();
        bs.set(63);
        Assertions.assertEquals((Object)"{63}", (Object)bs.toString(), (String)"Test highest bit");
    }

    @Test
    void test_xor_BitSet() {
        int i;
        FluentBitSet bs = (FluentBitSet)this.eightFbs.clone();
        bs.xor(this.eightFbs.bitSet());
        for (i = 0; i < 8; ++i) {
            Assertions.assertFalse((boolean)bs.get(i), (String)"XOR failed to clear bits");
        }
        bs.xor(this.eightFbs.bitSet());
        for (i = 0; i < 8; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)"XOR failed to set bits");
        }
        bs = this.newInstance(0);
        bs.xor(this.eightFbs.bitSet());
        for (i = 0; i < 8; ++i) {
            Assertions.assertTrue((boolean)bs.get(i), (String)"XOR(0) failed to set bits");
        }
        bs = this.newInstance();
        bs.set(63);
        Assertions.assertEquals((Object)"{63}", (Object)bs.toString(), (String)"Test highest bit");
    }
}

