/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.exception.CustomUncheckedException;
import org.apache.commons.lang3.function.AnnotationTestFixture;
import org.apache.commons.lang3.function.MethodFixtures;
import org.apache.commons.lang3.function.MethodInvokers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MethodInvokersFunctionTest
extends MethodFixtures {
    MethodInvokersFunctionTest() {
    }

    @Test
    void testApply0Arg() throws NoSuchMethodException, SecurityException {
        Function func = MethodInvokers.asFunction((Method)MethodInvokersFunctionTest.getMethodForGetString());
        Assertions.assertEquals((Object)INSTANCE.getString(), func.apply(INSTANCE));
    }

    @Test
    void testApply0ArgThrowsUnchecked() throws NoSuchMethodException, SecurityException {
        Function func = MethodInvokers.asFunction((Method)MethodInvokersFunctionTest.getMethodForGetStringThrowsUnchecked());
        Assertions.assertThrows(CustomUncheckedException.class, () -> func.apply(INSTANCE));
    }

    @Test
    void testBuildVarArg() throws SecurityException, NoSuchMethodException {
        MethodInvokers.asFunction((Method)MethodInvokersFunctionTest.getMethodForGetStringVarStringArgs());
    }

    @Test
    void testConstructorForNull() throws SecurityException {
        LangAssertions.assertNullPointerException(() -> MethodInvokers.asFunction(null));
    }

    @Test
    void testFindAndInvoke() throws SecurityException {
        List invokers = Stream.of(MethodFixtures.class.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(AnnotationTestFixture.class)).map(MethodInvokers::asFunction).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)invokers.size());
        Set set1 = invokers.stream().map(i -> i.apply(MethodFixtures.INSTANCE)).collect(Collectors.toSet());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList(INSTANCE.getString(), INSTANCE.getString2())), set1);
        Set set2 = Stream.of(INSTANCE).map((Function)invokers.get(0)).collect(Collectors.toSet());
        Set set3 = Stream.of(INSTANCE).map((Function)invokers.get(1)).collect(Collectors.toSet());
        set2.addAll(set3);
        Assertions.assertEquals(new HashSet<String>(Arrays.asList(INSTANCE.getString(), INSTANCE.getString2())), set2);
    }

    @Test
    void testFullExample() throws SecurityException, ReflectiveOperationException {
        Method method = String.class.getMethod("length", new Class[0]);
        Function function = MethodInvokers.asFunction((Method)method);
        Assertions.assertEquals((int)3, (Integer)((Integer)function.apply("ABC")));
    }

    @Test
    void testMapComputeIfAbsent() throws NoSuchMethodException, SecurityException {
        HashMap map = new HashMap();
        map.computeIfAbsent(INSTANCE, MethodInvokers.asFunction((Method)MethodInvokersFunctionTest.getMethodForGetString()));
        Assertions.assertEquals((Object)INSTANCE.getString(), map.get(INSTANCE));
    }

    @Test
    void testToString() throws SecurityException, ReflectiveOperationException {
        Assertions.assertFalse((boolean)MethodInvokers.asFunction((Method)MethodInvokersFunctionTest.getMethodForGetString()).toString().isEmpty());
    }
}

