/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.control.event;

import org.apache.commons.jcs3.engine.control.event.behavior.ElementEventType;
import org.apache.commons.jcs3.engine.control.event.behavior.IElementEvent;
import org.apache.commons.jcs3.engine.control.event.behavior.IElementEventHandler;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class ElementEventHandlerMockImpl
implements IElementEventHandler {
    private int callCount;
    private static final Log log = LogManager.getLog(ElementEventHandlerMockImpl.class);
    private int spoolCount;
    private int spoolNotAllowedCount;
    private int spoolNoDiskCount;
    private int exceededMaxLifeBackgroundCount;
    private int exceededIdleTimeBackgroundCount;

    public synchronized <T> void handleElementEvent(IElementEvent<T> event) {
        this.setCallCount(this.getCallCount() + 1);
        if (log.isDebugEnabled()) {
            log.debug("HANDLER -- HANDLER -- HANDLER -- ---EVENT CODE = " + event.getElementEvent());
            log.debug("/n/n EVENT CODE = " + event.getElementEvent() + " ***************************");
        }
        if (event.getElementEvent() == ElementEventType.SPOOLED_DISK_AVAILABLE) {
            this.setSpoolCount(this.getSpoolCount() + 1);
        } else if (event.getElementEvent() == ElementEventType.SPOOLED_NOT_ALLOWED) {
            this.setSpoolNotAllowedCount(this.getSpoolNotAllowedCount() + 1);
        } else if (event.getElementEvent() == ElementEventType.SPOOLED_DISK_NOT_AVAILABLE) {
            this.setSpoolNoDiskCount(this.getSpoolNoDiskCount() + 1);
        } else if (event.getElementEvent() == ElementEventType.EXCEEDED_MAXLIFE_BACKGROUND) {
            this.setExceededMaxLifeBackgroundCount(this.getExceededMaxLifeBackgroundCount() + 1);
        } else if (event.getElementEvent() == ElementEventType.EXCEEDED_IDLETIME_BACKGROUND) {
            this.setExceededIdleTimeBackgroundCount(this.getExceededIdleTimeBackgroundCount() + 1);
        }
    }

    public void setSpoolCount(int spoolCount) {
        this.spoolCount = spoolCount;
    }

    public int getSpoolCount() {
        return this.spoolCount;
    }

    public void setSpoolNotAllowedCount(int spoolNotAllowedCount) {
        this.spoolNotAllowedCount = spoolNotAllowedCount;
    }

    public int getSpoolNotAllowedCount() {
        return this.spoolNotAllowedCount;
    }

    public void setSpoolNoDiskCount(int spoolNoDiskCount) {
        this.spoolNoDiskCount = spoolNoDiskCount;
    }

    public int getSpoolNoDiskCount() {
        return this.spoolNoDiskCount;
    }

    public void setExceededMaxLifeBackgroundCount(int exceededMaxLifeBackground) {
        this.exceededMaxLifeBackgroundCount = exceededMaxLifeBackground;
    }

    public int getExceededMaxLifeBackgroundCount() {
        return this.exceededMaxLifeBackgroundCount;
    }

    public void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    public int getCallCount() {
        return this.callCount;
    }

    public void setExceededIdleTimeBackgroundCount(int exceededIdleTimeBackground) {
        this.exceededIdleTimeBackgroundCount = exceededIdleTimeBackground;
    }

    public int getExceededIdleTimeBackgroundCount() {
        return this.exceededIdleTimeBackgroundCount;
    }
}

