/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.server;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.commons.jcs3.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServer;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.net.HostNameUtil;

public class RemoteCacheServerStartupUtil {
    private static final Log log = LogManager.getLog(RemoteCacheServerStartupUtil.class);
    private static final int DEFAULT_REGISTRY_PORT = 1101;

    public static <K, V> RemoteCacheServer<K, V> startServerUsingProperties(String propsFileName) {
        int registryPort = 1101;
        Properties props = null;
        try {
            props = RemoteUtils.loadProps((String)propsFileName);
        }
        catch (IOException e) {
            log.error("Problem loading configuration from " + propsFileName, (Throwable)e);
        }
        if (props != null) {
            String portS = props.getProperty("registry.port", String.valueOf(1101));
            try {
                registryPort = Integer.parseInt(portS);
            }
            catch (NumberFormatException e) {
                log.error("Problem converting port to an int.", (Throwable)e);
            }
        }
        try {
            String registryHost = HostNameUtil.getLocalHostAddress();
            if (log.isDebugEnabled()) {
                log.debug("registryHost = [" + registryHost + "]");
            }
            if ("localhost".equals(registryHost) || "127.0.0.1".equals(registryHost)) {
                log.warn("The local address [" + registryHost + "] is INVALID.  Other machines must be able to use the address to reach this server.");
            }
            try {
                RemoteCacheServerFactory.startup((String)registryHost, (int)registryPort, (Properties)props);
            }
            catch (IOException e) {
                log.error("Problem starting remote cache server.", (Throwable)e);
            }
        }
        catch (UnknownHostException e) {
            log.error("Could not get local address to use for the registry!", (Throwable)e);
        }
        return RemoteCacheServerFactory.getRemoteCacheServer();
    }
}

