/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinition;

public class SimpleFacetDefinition
implements FacetDefinition {
    private final List<Vector3D> vertices;
    private final Vector3D normal;

    public SimpleFacetDefinition(List<Vector3D> vertices) {
        this(vertices, null);
    }

    public SimpleFacetDefinition(List<Vector3D> vertices, Vector3D normal) {
        Objects.requireNonNull(vertices, "Facet vertex list cannot be null");
        if (vertices.size() < 3) {
            throw new IllegalArgumentException("Facet vertex list must contain at least 3 points; found " + vertices.size());
        }
        this.vertices = Collections.unmodifiableList(vertices);
        this.normal = normal;
    }

    @Override
    public List<Vector3D> getVertices() {
        return this.vertices;
    }

    @Override
    public Vector3D getNormal() {
        return this.normal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[vertices= ").append(this.getVertices()).append(", normal= ").append(this.getNormal()).append(']');
        return sb.toString();
    }
}

