/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.StrictConfigurationComparator;
import org.apache.commons.configuration.TestAbstractConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.junit.Assert;
import org.junit.Test;

public class TestMapConfiguration
extends TestAbstractConfiguration {
    private static final String KEY = "key1";
    private static final String SPACE_VALUE = "   Value with whitespace  ";
    private static final String TRIM_VALUE = "   Value with whitespace  ".trim();

    protected AbstractConfiguration getConfiguration() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY, "value1");
        map.put("key2", "value2");
        map.put("list", "value1, value2");
        map.put("listesc", "value1\\,value2");
        return new MapConfiguration(map);
    }

    protected AbstractConfiguration getEmptyConfiguration() {
        return new MapConfiguration(new HashMap());
    }

    @Test
    public void testGetMap() {
        HashMap map = new HashMap();
        MapConfiguration conf = new MapConfiguration(map);
        Assert.assertEquals(map, (Object)conf.getMap());
    }

    @Test
    public void testClone() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        MapConfiguration copy = (MapConfiguration)config.clone();
        StrictConfigurationComparator comp = new StrictConfigurationComparator();
        Assert.assertTrue((String)"Configurations are not equal", (boolean)comp.compare((Configuration)config, (Configuration)copy));
    }

    @Test
    public void testCloneModify() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.addConfigurationListener(new ConfigurationListener(){

            public void configurationChanged(ConfigurationEvent event) {
            }
        });
        MapConfiguration copy = (MapConfiguration)config.clone();
        Assert.assertTrue((String)"Event listeners were copied", (boolean)copy.getConfigurationListeners().isEmpty());
        config.addProperty("cloneTest", (Object)Boolean.TRUE);
        Assert.assertFalse((String)"Map not decoupled", (boolean)copy.containsKey("cloneTest"));
        copy.clearProperty(KEY);
        Assert.assertEquals((String)"Map not decoupled (2)", (Object)"value1", (Object)config.getString(KEY));
    }

    @Test
    public void testAddProperty() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.addProperty(KEY, (Object)TRIM_VALUE);
        config.addProperty(KEY, (Object)"anotherValue");
        List values = config.getList(KEY);
        Assert.assertEquals((String)"Wrong number of values", (long)3L, (long)values.size());
    }

    @Test
    public void testGetPropertyTrim() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.getMap().put(KEY, SPACE_VALUE);
        Assert.assertEquals((String)"Wrong trimmed value", (Object)TRIM_VALUE, (Object)config.getProperty(KEY));
    }

    @Test
    public void testGetPropertyTrimDisabled() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.getMap().put(KEY, SPACE_VALUE);
        config.setTrimmingDisabled(true);
        Assert.assertEquals((String)"Wrong trimmed value", (Object)SPACE_VALUE, (Object)config.getProperty(KEY));
    }

    @Test
    public void testGetPropertyTrimNoSplit() {
        MapConfiguration config = (MapConfiguration)this.getConfiguration();
        config.getMap().put(KEY, SPACE_VALUE);
        config.setDelimiterParsingDisabled(true);
        Assert.assertEquals((String)"Wrong trimmed value", (Object)SPACE_VALUE, (Object)config.getProperty(KEY));
    }
}

