/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.osgi;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.options.MavenArtifactProvisionOption;

final class Configurations {
    private static MavenArtifactProvisionOption getCommonsCodec() {
        return CoreOptions.mavenBundle().groupId("commons-codec").artifactId("commons-codec").version("1.16.0");
    }

    private static MavenArtifactProvisionOption getCommonsIO() {
        return CoreOptions.mavenBundle().groupId("commons-io").artifactId("commons-io").version("2.15.1");
    }

    public static Option[] getConfigWithoutOptionals() {
        Option[] defaultConfig = Configurations.getDefaultConfig();
        Option[] result = (Option[])Arrays.stream(defaultConfig).filter(o -> !Configurations.getCommonsCodec().equals(o)).filter(o -> !Configurations.getCommonsIO().equals(o)).toArray(Option[]::new);
        Assertions.assertTrue((result.length < defaultConfig.length ? 1 : 0) != 0, (String)"Expected to have removed options.");
        return result;
    }

    public static Option[] getDefaultConfig() {
        return new Option[]{CoreOptions.systemProperty((String)"pax.exam.osgi.unresolved.fail").value("true"), CoreOptions.systemProperty((String)"org.ops4j.pax.url.mvn.useFallbackRepositories").value("false"), CoreOptions.systemProperty((String)"org.ops4j.pax.url.mvn.repositories").value("https://repo.maven.apache.org/maven2"), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.scr").version("2.0.14"), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.configadmin").version("1.8.16"), Configurations.getCommonsCodec(), Configurations.getCommonsIO(), CoreOptions.composite((Option[])new Option[]{CoreOptions.systemProperty((String)"pax.exam.invoker").value("junit"), CoreOptions.bundle((String)"link:classpath:META-INF/links/org.ops4j.pax.tipi.junit.link"), CoreOptions.bundle((String)"link:classpath:META-INF/links/org.ops4j.pax.exam.invoker.junit.link"), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.hamcrest").version("1.3_1")}), (Option)CoreOptions.bundle((String)"reference:file:target/classes/").start()};
    }

    private Configurations() {
    }
}

