/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.zip.ZipException;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.zip.X5455_ExtendedTimestamp;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class X5455_ExtendedTimestampTest {
    private static final ZipShort X5455 = new ZipShort(21589);
    private static final ZipLong ZERO_TIME = new ZipLong(0);
    private static final ZipLong MAX_TIME_SECONDS = new ZipLong(Integer.MAX_VALUE);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd/HH:mm:ss Z");
    private X5455_ExtendedTimestamp xf;
    @TempDir
    private File tmpDir;

    X5455_ExtendedTimestampTest() {
    }

    private static Date adjustFromGMTToExpectedOffset(Date from) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(from);
        cal.add(14, cal.get(15));
        if (cal.getTimeZone().inDaylightTime(from)) {
            cal.add(14, cal.get(16));
        }
        cal.add(10, 8);
        return cal.getTime();
    }

    private static boolean isFlagSet(byte data, byte flag) {
        return (data & flag) == flag;
    }

    @BeforeEach
    public void before() {
        this.xf = new X5455_ExtendedTimestamp();
    }

    private void parseReparse(byte providedFlags, ZipLong time, byte expectedFlags, byte[] expectedLocal, byte[] almostExpectedCentral) throws ZipException {
        byte[] expectedCentral = new byte[almostExpectedCentral.length];
        System.arraycopy(almostExpectedCentral, 0, expectedCentral, 0, almostExpectedCentral.length);
        expectedCentral[0] = expectedFlags;
        this.xf.setModifyTime(time);
        this.xf.setAccessTime(time);
        this.xf.setCreateTime(time);
        this.xf.setFlags(providedFlags);
        byte[] result = this.xf.getLocalFileDataData();
        Assertions.assertArrayEquals((byte[])expectedLocal, (byte[])result);
        this.xf.parseFromLocalFileData(result, 0, result.length);
        Assertions.assertEquals((byte)expectedFlags, (byte)this.xf.getFlags());
        if (X5455_ExtendedTimestampTest.isFlagSet(expectedFlags, (byte)1)) {
            Assertions.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
            Assertions.assertEquals((Object)time, (Object)this.xf.getModifyTime());
        }
        if (X5455_ExtendedTimestampTest.isFlagSet(expectedFlags, (byte)2)) {
            Assertions.assertTrue((boolean)this.xf.isBit1_accessTimePresent());
            Assertions.assertEquals((Object)time, (Object)this.xf.getAccessTime());
        }
        if (X5455_ExtendedTimestampTest.isFlagSet(expectedFlags, (byte)4)) {
            Assertions.assertTrue((boolean)this.xf.isBit2_createTimePresent());
            Assertions.assertEquals((Object)time, (Object)this.xf.getCreateTime());
        }
        this.xf.setModifyTime(time);
        this.xf.setAccessTime(time);
        this.xf.setCreateTime(time);
        this.xf.setFlags(providedFlags);
        result = this.xf.getCentralDirectoryData();
        Assertions.assertArrayEquals((byte[])expectedCentral, (byte[])result);
        this.xf.parseFromCentralDirectoryData(result, 0, result.length);
        Assertions.assertEquals((byte)expectedFlags, (byte)this.xf.getFlags());
        if (X5455_ExtendedTimestampTest.isFlagSet(expectedFlags, (byte)1)) {
            Assertions.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
            Assertions.assertEquals((Object)time, (Object)this.xf.getModifyTime());
        }
    }

    private void parseReparse(ZipLong time, byte[] expectedLocal, byte[] almostExpectedCentral) throws ZipException {
        this.parseReparse(expectedLocal[0], time, expectedLocal[0], expectedLocal, almostExpectedCentral);
    }

    @AfterEach
    public void removeTempFiles() {
        if (this.tmpDir != null) {
            AbstractTest.forceDelete(this.tmpDir);
        }
    }

    @Test
    void testBitsAreSetWithTime() {
        this.xf.setModifyJavaTime(new Date(1111L));
        Assertions.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
        Assertions.assertEquals((int)1, (int)this.xf.getFlags());
        this.xf.setAccessJavaTime(new Date(2222L));
        Assertions.assertTrue((boolean)this.xf.isBit1_accessTimePresent());
        Assertions.assertEquals((int)3, (int)this.xf.getFlags());
        this.xf.setCreateJavaTime(new Date(3333L));
        Assertions.assertTrue((boolean)this.xf.isBit2_createTimePresent());
        Assertions.assertEquals((int)7, (int)this.xf.getFlags());
        this.xf.setModifyJavaTime(null);
        Assertions.assertFalse((boolean)this.xf.isBit0_modifyTimePresent());
        Assertions.assertEquals((int)6, (int)this.xf.getFlags());
        this.xf.setAccessJavaTime(null);
        Assertions.assertFalse((boolean)this.xf.isBit1_accessTimePresent());
        Assertions.assertEquals((int)4, (int)this.xf.getFlags());
        this.xf.setCreateJavaTime(null);
        Assertions.assertFalse((boolean)this.xf.isBit2_createTimePresent());
        Assertions.assertEquals((int)0, (int)this.xf.getFlags());
    }

    @Test
    void testGetHeaderId() {
        Assertions.assertEquals((Object)X5455, (Object)this.xf.getHeaderId());
    }

    @Test
    void testGettersSetters() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.set(1, 2000);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long timeMillis = cal.getTimeInMillis();
        ZipLong time = new ZipLong(timeMillis / 1000L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.xf.setModifyJavaTime(new Date(1000L * (MAX_TIME_SECONDS.getValue() + 1L))), (String)"Time too big for 32 bits!");
        this.xf.setModifyTime(time);
        Assertions.assertEquals((Object)time, (Object)this.xf.getModifyTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getModifyJavaTime().getTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getModifyFileTime().toMillis());
        Assertions.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
        this.xf.setModifyJavaTime(new Date(timeMillis));
        Assertions.assertEquals((Object)time, (Object)this.xf.getModifyTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getModifyJavaTime().getTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getModifyFileTime().toMillis());
        Assertions.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
        this.xf.setModifyJavaTime(new Date(timeMillis + 123L));
        Assertions.assertEquals((Object)time, (Object)this.xf.getModifyTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getModifyJavaTime().getTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getModifyFileTime().toMillis());
        Assertions.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
        this.xf.setModifyFileTime(FileTime.fromMillis(timeMillis + 123L));
        Assertions.assertEquals((Object)time, (Object)this.xf.getModifyTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getModifyJavaTime().getTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getModifyFileTime().toMillis());
        Assertions.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
        this.xf.setModifyTime(null);
        Assertions.assertNull((Object)this.xf.getModifyJavaTime());
        Assertions.assertNull((Object)this.xf.getModifyFileTime());
        Assertions.assertFalse((boolean)this.xf.isBit0_modifyTimePresent());
        this.xf.setModifyJavaTime(null);
        Assertions.assertNull((Object)this.xf.getModifyTime());
        Assertions.assertNull((Object)this.xf.getModifyFileTime());
        Assertions.assertFalse((boolean)this.xf.isBit0_modifyTimePresent());
        this.xf.setModifyFileTime(null);
        Assertions.assertNull((Object)this.xf.getModifyJavaTime());
        Assertions.assertNull((Object)this.xf.getModifyTime());
        Assertions.assertFalse((boolean)this.xf.isBit0_modifyTimePresent());
        this.xf.setAccessTime(time);
        Assertions.assertEquals((Object)time, (Object)this.xf.getAccessTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getAccessJavaTime().getTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getAccessFileTime().toMillis());
        Assertions.assertTrue((boolean)this.xf.isBit1_accessTimePresent());
        this.xf.setAccessJavaTime(new Date(timeMillis));
        Assertions.assertEquals((Object)time, (Object)this.xf.getAccessTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getAccessJavaTime().getTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getAccessFileTime().toMillis());
        Assertions.assertTrue((boolean)this.xf.isBit1_accessTimePresent());
        this.xf.setAccessJavaTime(new Date(timeMillis + 123L));
        Assertions.assertEquals((Object)time, (Object)this.xf.getAccessTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getAccessJavaTime().getTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getAccessFileTime().toMillis());
        Assertions.assertTrue((boolean)this.xf.isBit1_accessTimePresent());
        this.xf.setAccessFileTime(FileTime.fromMillis(timeMillis + 123L));
        Assertions.assertEquals((Object)time, (Object)this.xf.getAccessTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getAccessJavaTime().getTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getAccessFileTime().toMillis());
        Assertions.assertTrue((boolean)this.xf.isBit1_accessTimePresent());
        this.xf.setAccessTime(null);
        Assertions.assertNull((Object)this.xf.getAccessJavaTime());
        Assertions.assertNull((Object)this.xf.getAccessFileTime());
        Assertions.assertFalse((boolean)this.xf.isBit1_accessTimePresent());
        this.xf.setAccessJavaTime(null);
        Assertions.assertNull((Object)this.xf.getAccessTime());
        Assertions.assertNull((Object)this.xf.getAccessFileTime());
        Assertions.assertFalse((boolean)this.xf.isBit1_accessTimePresent());
        this.xf.setAccessFileTime(null);
        Assertions.assertNull((Object)this.xf.getAccessJavaTime());
        Assertions.assertNull((Object)this.xf.getAccessTime());
        Assertions.assertFalse((boolean)this.xf.isBit1_accessTimePresent());
        this.xf.setCreateTime(time);
        Assertions.assertEquals((Object)time, (Object)this.xf.getCreateTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getCreateJavaTime().getTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getCreateFileTime().toMillis());
        Assertions.assertTrue((boolean)this.xf.isBit2_createTimePresent());
        this.xf.setCreateJavaTime(new Date(timeMillis));
        Assertions.assertEquals((Object)time, (Object)this.xf.getCreateTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getCreateJavaTime().getTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getCreateFileTime().toMillis());
        Assertions.assertTrue((boolean)this.xf.isBit2_createTimePresent());
        this.xf.setCreateJavaTime(new Date(timeMillis + 123L));
        Assertions.assertEquals((Object)time, (Object)this.xf.getCreateTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getCreateJavaTime().getTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getCreateFileTime().toMillis());
        Assertions.assertTrue((boolean)this.xf.isBit2_createTimePresent());
        this.xf.setCreateFileTime(FileTime.fromMillis(timeMillis + 123L));
        Assertions.assertEquals((Object)time, (Object)this.xf.getCreateTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getCreateJavaTime().getTime());
        Assertions.assertEquals((long)timeMillis, (long)this.xf.getCreateFileTime().toMillis());
        Assertions.assertTrue((boolean)this.xf.isBit2_createTimePresent());
        this.xf.setCreateTime(null);
        Assertions.assertNull((Object)this.xf.getCreateJavaTime());
        Assertions.assertNull((Object)this.xf.getCreateFileTime());
        Assertions.assertFalse((boolean)this.xf.isBit2_createTimePresent());
        this.xf.setCreateJavaTime(null);
        Assertions.assertNull((Object)this.xf.getCreateTime());
        Assertions.assertNull((Object)this.xf.getCreateFileTime());
        Assertions.assertFalse((boolean)this.xf.isBit2_createTimePresent());
        this.xf.setCreateFileTime(null);
        Assertions.assertNull((Object)this.xf.getCreateJavaTime());
        Assertions.assertNull((Object)this.xf.getCreateTime());
        Assertions.assertFalse((boolean)this.xf.isBit2_createTimePresent());
        this.xf.setModifyTime(time);
        this.xf.setAccessTime(time);
        this.xf.setCreateTime(time);
        this.xf.setFlags((byte)0);
        Assertions.assertEquals((int)0, (int)this.xf.getFlags());
        Assertions.assertFalse((boolean)this.xf.isBit0_modifyTimePresent());
        Assertions.assertFalse((boolean)this.xf.isBit1_accessTimePresent());
        Assertions.assertFalse((boolean)this.xf.isBit2_createTimePresent());
        Assertions.assertEquals((int)1, (int)this.xf.getLocalFileDataLength().getValue());
        Assertions.assertEquals((int)1, (int)this.xf.getCentralDirectoryLength().getValue());
        this.xf.setFlags((byte)1);
        Assertions.assertEquals((int)1, (int)this.xf.getFlags());
        Assertions.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
        Assertions.assertFalse((boolean)this.xf.isBit1_accessTimePresent());
        Assertions.assertFalse((boolean)this.xf.isBit2_createTimePresent());
        Assertions.assertEquals((int)5, (int)this.xf.getLocalFileDataLength().getValue());
        Assertions.assertEquals((int)5, (int)this.xf.getCentralDirectoryLength().getValue());
        this.xf.setFlags((byte)2);
        Assertions.assertEquals((int)2, (int)this.xf.getFlags());
        Assertions.assertFalse((boolean)this.xf.isBit0_modifyTimePresent());
        Assertions.assertTrue((boolean)this.xf.isBit1_accessTimePresent());
        Assertions.assertFalse((boolean)this.xf.isBit2_createTimePresent());
        Assertions.assertEquals((int)5, (int)this.xf.getLocalFileDataLength().getValue());
        Assertions.assertEquals((int)1, (int)this.xf.getCentralDirectoryLength().getValue());
        this.xf.setFlags((byte)4);
        Assertions.assertEquals((int)4, (int)this.xf.getFlags());
        Assertions.assertFalse((boolean)this.xf.isBit0_modifyTimePresent());
        Assertions.assertFalse((boolean)this.xf.isBit1_accessTimePresent());
        Assertions.assertTrue((boolean)this.xf.isBit2_createTimePresent());
        Assertions.assertEquals((int)5, (int)this.xf.getLocalFileDataLength().getValue());
        Assertions.assertEquals((int)1, (int)this.xf.getCentralDirectoryLength().getValue());
        this.xf.setFlags((byte)7);
        Assertions.assertEquals((int)7, (int)this.xf.getFlags());
        Assertions.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
        Assertions.assertTrue((boolean)this.xf.isBit1_accessTimePresent());
        Assertions.assertTrue((boolean)this.xf.isBit2_createTimePresent());
        Assertions.assertEquals((int)13, (int)this.xf.getLocalFileDataLength().getValue());
        Assertions.assertEquals((int)5, (int)this.xf.getCentralDirectoryLength().getValue());
        this.xf.setFlags((byte)-1);
        Assertions.assertEquals((int)-1, (int)this.xf.getFlags());
        Assertions.assertTrue((boolean)this.xf.isBit0_modifyTimePresent());
        Assertions.assertTrue((boolean)this.xf.isBit1_accessTimePresent());
        Assertions.assertTrue((boolean)this.xf.isBit2_createTimePresent());
        Assertions.assertEquals((int)13, (int)this.xf.getLocalFileDataLength().getValue());
        Assertions.assertEquals((int)5, (int)this.xf.getCentralDirectoryLength().getValue());
    }

    @Test
    void testMisc() throws Exception {
        Assertions.assertNotEquals((Object)this.xf, (Object)new Object());
        Assertions.assertTrue((boolean)this.xf.toString().startsWith("0x5455 Zip Extra Field"));
        Assertions.assertFalse((boolean)this.xf.toString().contains(" Modify:"));
        Assertions.assertFalse((boolean)this.xf.toString().contains(" Access:"));
        Assertions.assertFalse((boolean)this.xf.toString().contains(" Create:"));
        Object o = this.xf.clone();
        Assertions.assertEquals((int)o.hashCode(), (int)this.xf.hashCode());
        Assertions.assertEquals((Object)this.xf, (Object)o);
        this.xf.setModifyJavaTime(new Date(1111L));
        this.xf.setAccessJavaTime(new Date(2222L));
        this.xf.setCreateJavaTime(new Date(3333L));
        this.xf.setFlags((byte)7);
        Assertions.assertNotEquals((Object)this.xf, (Object)o);
        Assertions.assertTrue((boolean)this.xf.toString().startsWith("0x5455 Zip Extra Field"));
        Assertions.assertTrue((boolean)this.xf.toString().contains(" Modify:"));
        Assertions.assertTrue((boolean)this.xf.toString().contains(" Access:"));
        Assertions.assertTrue((boolean)this.xf.toString().contains(" Create:"));
        o = this.xf.clone();
        Assertions.assertEquals((int)o.hashCode(), (int)this.xf.hashCode());
        Assertions.assertEquals((Object)this.xf, (Object)o);
    }

    @Test
    void testParseReparse() throws ZipException {
        byte[] NULL_FLAGS = new byte[]{0};
        byte[] AC_CENTRAL = new byte[]{2};
        byte[] CR_CENTRAL = new byte[]{4};
        byte[] MOD_ZERO = new byte[]{1, 0, 0, 0, 0};
        byte[] MOD_MAX = new byte[]{1, -1, -1, -1, 127};
        byte[] AC_ZERO = new byte[]{2, 0, 0, 0, 0};
        byte[] AC_MAX = new byte[]{2, -1, -1, -1, 127};
        byte[] CR_ZERO = new byte[]{4, 0, 0, 0, 0};
        byte[] CR_MAX = new byte[]{4, -1, -1, -1, 127};
        byte[] MOD_AC_ZERO = new byte[]{3, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] MOD_AC_MAX = new byte[]{3, -1, -1, -1, 127, -1, -1, -1, 127};
        byte[] MOD_AC_CR_ZERO = new byte[]{7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] MOD_AC_CR_MAX = new byte[]{7, -1, -1, -1, 127, -1, -1, -1, 127, -1, -1, -1, 127};
        this.parseReparse(null, NULL_FLAGS, NULL_FLAGS);
        this.parseReparse(ZERO_TIME, MOD_ZERO, MOD_ZERO);
        this.parseReparse(MAX_TIME_SECONDS, MOD_MAX, MOD_MAX);
        this.parseReparse(ZERO_TIME, AC_ZERO, AC_CENTRAL);
        this.parseReparse(MAX_TIME_SECONDS, AC_MAX, AC_CENTRAL);
        this.parseReparse(ZERO_TIME, CR_ZERO, CR_CENTRAL);
        this.parseReparse(MAX_TIME_SECONDS, CR_MAX, CR_CENTRAL);
        this.parseReparse(ZERO_TIME, MOD_AC_ZERO, MOD_ZERO);
        this.parseReparse(MAX_TIME_SECONDS, MOD_AC_MAX, MOD_MAX);
        this.parseReparse(ZERO_TIME, MOD_AC_CR_ZERO, MOD_ZERO);
        this.parseReparse(MAX_TIME_SECONDS, MOD_AC_CR_MAX, MOD_MAX);
        this.parseReparse((byte)15, MAX_TIME_SECONDS, (byte)7, MOD_AC_CR_MAX, MOD_MAX);
        this.parseReparse((byte)31, MAX_TIME_SECONDS, (byte)7, MOD_AC_CR_MAX, MOD_MAX);
        this.parseReparse((byte)63, MAX_TIME_SECONDS, (byte)7, MOD_AC_CR_MAX, MOD_MAX);
        this.parseReparse((byte)71, MAX_TIME_SECONDS, (byte)7, MOD_AC_CR_MAX, MOD_MAX);
        this.parseReparse((byte)127, MAX_TIME_SECONDS, (byte)7, MOD_AC_CR_MAX, MOD_MAX);
        this.parseReparse((byte)-1, MAX_TIME_SECONDS, (byte)7, MOD_AC_CR_MAX, MOD_MAX);
    }

    @Test
    void testResetsFlagsWhenLocalFileArrayIsTooShort() throws Exception {
        byte[] local = new byte[]{7};
        this.xf.parseFromLocalFileData(local, 0, 1);
        Assertions.assertArrayEquals((byte[])new byte[1], (byte[])this.xf.getLocalFileDataData());
    }

    @Test
    void testSampleFile() throws Exception {
        File archive = AbstractTest.getFile("COMPRESS-210_unix_time_zip_test.zip");
        try (ZipFile zipFile = ((ZipFile.Builder)ZipFile.builder().setFile(archive)).get();){
            Enumeration en = zipFile.getEntries();
            block10: while (en.hasMoreElements()) {
                int year;
                ZipArchiveEntry zae = (ZipArchiveEntry)en.nextElement();
                if (zae.isDirectory()) continue;
                String name = zae.getName();
                int x = name.lastIndexOf(47);
                String yearString = name.substring(x + 1);
                try {
                    year = Integer.parseInt(yearString);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                X5455_ExtendedTimestamp xf = (X5455_ExtendedTimestamp)zae.getExtraField(X5455);
                Date rawZ = zae.getLastModifiedDate();
                Date m = xf.getModifyJavaTime();
                boolean zipTimeUsesExtendedTimestampCorrectly = rawZ.equals(m);
                boolean zipTimeUsesExtendedTimestampButUnsigned = year > 2037 && rawZ.getSeconds() == 1;
                boolean zipTimeUsesExtendedTimestamp = zipTimeUsesExtendedTimestampCorrectly || zipTimeUsesExtendedTimestampButUnsigned;
                Date z = zipTimeUsesExtendedTimestamp ? rawZ : X5455_ExtendedTimestampTest.adjustFromGMTToExpectedOffset(rawZ);
                Date a = xf.getAccessJavaTime();
                String zipTime = DATE_FORMAT.format(z);
                String modTime = DATE_FORMAT.format(m);
                String accTime = DATE_FORMAT.format(a);
                switch (year) {
                    case 2109: {
                        if (zipTimeUsesExtendedTimestamp) continue block10;
                        Assertions.assertEquals((Object)"1981-01-01/00:00:02 +0000", (Object)zipTime);
                        continue block10;
                    }
                }
                if (!zipTimeUsesExtendedTimestamp) {
                    if (year < 1980) {
                        Assertions.assertEquals((Object)"1980-01-01/08:00:00 +0000", (Object)zipTime);
                    } else {
                        Assertions.assertEquals((Object)(year + "-01-01/00:00:02 +0000"), (Object)zipTime);
                    }
                }
                if (year >= 2038) continue;
                Assertions.assertEquals((Object)(year + "-01-01/00:00:01 +0000"), (Object)modTime);
                Assertions.assertEquals((Object)(year + "-01-01/00:00:03 +0000"), (Object)accTime);
            }
        }
    }

    @Test
    void testWriteReadRoundtrip() throws IOException {
        File output = new File(this.tmpDir, "write_rewrite.zip");
        Calendar instance = Calendar.getInstance();
        instance.clear();
        instance.set(1997, 8, 24, 15, 10, 2);
        Date date = instance.getTime();
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             ZipArchiveOutputStream os = new ZipArchiveOutputStream(out);){
            ZipArchiveEntry ze = new ZipArchiveEntry("foo");
            this.xf.setModifyJavaTime(date);
            this.xf.setFlags((byte)1);
            ze.addExtraField((ZipExtraField)this.xf);
            os.putArchiveEntry(ze);
            os.closeArchiveEntry();
        }
        try (ZipFile zf = ((ZipFile.Builder)ZipFile.builder().setFile(output)).get();){
            ZipArchiveEntry ze = zf.getEntry("foo");
            X5455_ExtendedTimestamp ext = (X5455_ExtendedTimestamp)ze.getExtraField(X5455);
            Assertions.assertNotNull((Object)ext);
            Assertions.assertTrue((boolean)ext.isBit0_modifyTimePresent());
            Assertions.assertEquals((Object)date, (Object)ext.getModifyJavaTime());
        }
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

