/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import org.apache.commons.compress.archivers.zip.CircularBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CircularBufferTest {
    CircularBufferTest() {
    }

    @Test
    void testCopy() {
        int i;
        CircularBuffer buffer = new CircularBuffer(16);
        buffer.put(1);
        buffer.put(2);
        buffer.get();
        buffer.get();
        buffer.copy(6, 8);
        for (i = 2; i < 6; ++i) {
            Assertions.assertEquals((int)0, (int)buffer.get(), (String)("buffer[" + i + "]"));
        }
        Assertions.assertEquals((int)1, (int)buffer.get(), (String)"buffer[6]");
        Assertions.assertEquals((int)2, (int)buffer.get(), (String)"buffer[7]");
        Assertions.assertEquals((int)0, (int)buffer.get(), (String)"buffer[8]");
        Assertions.assertEquals((int)0, (int)buffer.get(), (String)"buffer[9]");
        for (i = 10; i < 14; ++i) {
            buffer.put(i);
            buffer.get();
        }
        Assertions.assertFalse((boolean)buffer.available(), (String)"available");
        buffer.copy(2, 8);
        for (i = 14; i < 18; ++i) {
            Assertions.assertEquals((int)(i % 2 == 0 ? 12 : 13), (int)buffer.get(), (String)("buffer[" + i + "]"));
        }
    }

    @Test
    void testPutAndGet() {
        int i;
        int size = 16;
        CircularBuffer buffer = new CircularBuffer(16);
        for (i = 0; i < 8; ++i) {
            buffer.put(i);
        }
        Assertions.assertTrue((boolean)buffer.available(), (String)"available");
        for (i = 0; i < 8; ++i) {
            Assertions.assertEquals((int)i, (int)buffer.get(), (String)("buffer[" + i + "]"));
        }
        Assertions.assertEquals((int)-1, (int)buffer.get());
        Assertions.assertFalse((boolean)buffer.available(), (String)"available");
    }
}

