/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.dump;

import java.io.InputStream;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.dump.DumpArchiveException;
import org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.apache.commons.compress.archivers.dump.InvalidFormatException;
import org.apache.commons.compress.archivers.dump.ShortFileException;
import org.apache.commons.compress.archivers.dump.UnrecognizedFormatException;
import org.apache.commons.compress.archivers.dump.UnsupportedCompressionAlgorithmException;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

class DumpArchiveInputStreamTest
extends AbstractTest {
    DumpArchiveInputStreamTest() {
    }

    @Test
    void testConsumesArchiveCompletely() throws Exception {
        try (InputStream is = DumpArchiveInputStreamTest.class.getResourceAsStream("/archive_with_trailer.dump");
             DumpArchiveInputStream dump = new DumpArchiveInputStream(is);){
            while (dump.getNextDumpEntry() != null) {
            }
            byte[] expected = new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 10};
            byte[] actual = new byte[expected.length];
            is.read(actual);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    void testDirectoryNullBytes() throws Exception {
        try (InputStream is = DumpArchiveInputStreamTest.newInputStream("org/apache/commons/compress/dump/directory_null_bytes-fail.dump");
             DumpArchiveInputStream archive = new DumpArchiveInputStream(is);){
            Assertions.assertThrows(InvalidFormatException.class, () -> ((DumpArchiveInputStream)archive).getNextEntry());
        }
    }

    @Test
    void testInvalidCompressType() throws Exception {
        try (InputStream is = DumpArchiveInputStreamTest.newInputStream("org/apache/commons/compress/dump/invalid_compression_type-fail.dump");){
            ArchiveException ex = (ArchiveException)Assertions.assertThrows(ArchiveException.class, () -> new DumpArchiveInputStream(is).close());
            Assertions.assertInstanceOf(UnsupportedCompressionAlgorithmException.class, (Object)ex.getCause());
        }
    }

    @Test
    @Timeout(value=15L, unit=TimeUnit.SECONDS, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    void testLoopingInodes() throws Exception {
        try (InputStream is = DumpArchiveInputStreamTest.newInputStream("org/apache/commons/compress/dump/looping_inodes-fail.dump");
             DumpArchiveInputStream archive = new DumpArchiveInputStream(is);){
            archive.getNextEntry();
            Assertions.assertThrows(DumpArchiveException.class, () -> ((DumpArchiveInputStream)archive).getNextEntry());
        }
    }

    @Test
    void testMultiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (InputStream in = DumpArchiveInputStreamTest.newInputStream("bla.dump");
             DumpArchiveInputStream archive = new DumpArchiveInputStream(in);){
            Assertions.assertNotNull((Object)archive.getNextEntry());
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
        }
    }

    @Test
    void testNotADumpArchive() throws Exception {
        try (InputStream is = DumpArchiveInputStreamTest.newInputStream("bla.zip");){
            ArchiveException ex = (ArchiveException)Assertions.assertThrows(ArchiveException.class, () -> new DumpArchiveInputStream(is).close(), (String)"expected an exception");
            Assertions.assertTrue((boolean)(ex.getCause() instanceof ShortFileException));
        }
    }

    @Test
    void testNotADumpArchiveButBigEnough() throws Exception {
        try (InputStream is = DumpArchiveInputStreamTest.newInputStream("zip64support.tar.bz2");){
            ArchiveException ex = (ArchiveException)Assertions.assertThrows(ArchiveException.class, () -> new DumpArchiveInputStream(is).close(), (String)"expected an exception");
            Assertions.assertInstanceOf(UnrecognizedFormatException.class, (Object)ex.getCause());
        }
    }

    @Test
    void testRecLenZeroLongExecution() throws Exception {
        try (InputStream is = DumpArchiveInputStreamTest.newInputStream("org/apache/commons/compress/dump/reclen_zero-fail.dump");
             DumpArchiveInputStream archive = new DumpArchiveInputStream(is);){
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(20L), () -> Assertions.assertThrows(DumpArchiveException.class, () -> ((DumpArchiveInputStream)archive).getNextEntry()));
        }
    }

    @Test
    void testSingleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (InputStream in = DumpArchiveInputStreamTest.newInputStream("bla.dump");
             DumpArchiveInputStream archive = new DumpArchiveInputStream(in);){
            Assertions.assertNotNull((Object)archive.getNextEntry());
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read());
            Assertions.assertEquals((int)-1, (int)archive.read());
        }
    }
}

