/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class CpioTest
extends AbstractTest {
    @Test
    void testCpioArchiveCreation() throws Exception {
        File output = this.newTempFile("bla.cpio");
        File file1 = CpioTest.getFile("test1.xml");
        File file2 = CpioTest.getFile("test2.xml");
        try (OutputStream outputStream = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("cpio", outputStream);){
            archiveOutputStream.putArchiveEntry((ArchiveEntry)new CpioArchiveEntry("test1.xml", file1.length()));
            archiveOutputStream.write(file1);
            archiveOutputStream.closeArchiveEntry();
            archiveOutputStream.putArchiveEntry((ArchiveEntry)new CpioArchiveEntry("test2.xml", file2.length()));
            archiveOutputStream.write(file2);
            archiveOutputStream.closeArchiveEntry();
        }
    }

    @Test
    void testCpioUnarchive() throws Exception {
        File output = this.newTempFile("bla.cpio");
        File file1 = CpioTest.getFile("test1.xml");
        File file2 = CpioTest.getFile("test2.xml");
        long file1Length = file1.length();
        long file2Length = file2.length();
        try (OutputStream outputStream = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             ArchiveOutputStream archiveOutputStream = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("cpio", outputStream);){
            CpioArchiveEntry entry2 = new CpioArchiveEntry("test1.xml", file1Length);
            entry2.setMode(32768L);
            archiveOutputStream.putArchiveEntry((ArchiveEntry)entry2);
            archiveOutputStream.write(file1);
            archiveOutputStream.closeArchiveEntry();
            entry2 = new CpioArchiveEntry("test2.xml", file2Length);
            entry2.setMode(32768L);
            archiveOutputStream.putArchiveEntry((ArchiveEntry)entry2);
            archiveOutputStream.write(file2);
            archiveOutputStream.closeArchiveEntry();
            archiveOutputStream.finish();
            archiveOutputStream.close();
            outputStream.close();
        }
        HashMap result = new HashMap();
        try (InputStream inputStream = Files.newInputStream(output.toPath(), new OpenOption[0]);
             ArchiveInputStream archiveInputStream = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("cpio", inputStream);){
            archiveInputStream.forEach(entry -> {
                File cpioget = this.newTempFile(entry.getName());
                Files.copy((InputStream)archiveInputStream, cpioget.toPath(), new CopyOption[0]);
                result.put(entry.getName(), cpioget);
            });
        }
        File testFile = (File)result.get("test1.xml");
        Assertions.assertTrue((boolean)testFile.exists(), (String)("Expected " + testFile.getAbsolutePath() + " to exist"));
        Assertions.assertEquals((long)file1Length, (long)testFile.length(), (String)("length of " + testFile.getAbsolutePath()));
        testFile = (File)result.get("test2.xml");
        Assertions.assertTrue((boolean)testFile.exists(), (String)("Expected " + testFile.getAbsolutePath() + " to exist"));
        Assertions.assertEquals((long)file2Length, (long)testFile.length(), (String)("length of " + testFile.getAbsolutePath()));
    }

    @Test
    void testDirectoryEntryFromFile() throws Exception {
        CpioArchiveEntry entryOut;
        File archive = this.createTempFile("test.", ".cpio");
        File dir = this.getTempDirFile();
        long beforeArchiveWrite = dir.lastModified();
        CpioArchiveEntry entryIn = new CpioArchiveEntry(dir, "foo");
        try (CpioArchiveOutputStream tos = new CpioArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            tos.putArchiveEntry(entryIn);
            tos.closeArchiveEntry();
        }
        try (CpioArchiveInputStream tis = new CpioArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            entryOut = tis.getNextCPIOEntry();
        }
        Assertions.assertNotNull((Object)entryOut);
        Assertions.assertEquals((Object)"foo", (Object)entryOut.getName());
        Assertions.assertEquals((long)0L, (long)entryOut.getSize());
        Assertions.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(entryOut.getLastModifiedDate().getTime() / 1000L));
        Assertions.assertTrue((boolean)entryOut.isDirectory());
    }

    @Test
    void testExplicitDirectoryEntry() throws Exception {
        CpioArchiveEntry out;
        long beforeArchiveWrite;
        File archive = this.createTempFile("test.", ".cpio");
        try (CpioArchiveOutputStream tos = new CpioArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            beforeArchiveWrite = this.getTempDirFile().lastModified();
            CpioArchiveEntry in = new CpioArchiveEntry("foo/");
            in.setTime(beforeArchiveWrite / 1000L);
            in.setMode(16384L);
            tos.putArchiveEntry(in);
            tos.closeArchiveEntry();
        }
        try (CpioArchiveInputStream tis = new CpioArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            out = tis.getNextCPIOEntry();
        }
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"foo/", (Object)out.getName());
        Assertions.assertEquals((long)0L, (long)out.getSize());
        Assertions.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
        Assertions.assertTrue((boolean)out.isDirectory());
    }

    @Test
    void testExplicitFileEntry() throws Exception {
        CpioArchiveEntry out;
        File tmp = this.createTempFile();
        File archive = this.createTempFile("test.", ".cpio");
        try (CpioArchiveOutputStream tos = new CpioArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            CpioArchiveEntry in = new CpioArchiveEntry("foo");
            in.setTime(tmp.lastModified() / 1000L);
            in.setSize(tmp.length());
            in.setMode(32768L);
            tos.putArchiveEntry(in);
            tos.write(tmp);
            tos.closeArchiveEntry();
        }
        try (CpioArchiveInputStream tis = new CpioArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            out = tis.getNextCPIOEntry();
        }
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"foo", (Object)out.getName());
        Assertions.assertEquals((long)tmp.length(), (long)out.getSize());
        Assertions.assertEquals((long)(tmp.lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
        Assertions.assertFalse((boolean)out.isDirectory());
    }

    @Test
    void testFileEntryFromFile() throws Exception {
        CpioArchiveEntry out;
        File tmp = this.createTempFile();
        File archive = this.createTempFile("test.", ".cpio");
        try (CpioArchiveOutputStream tos = new CpioArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            CpioArchiveEntry in = new CpioArchiveEntry(tmp, "foo");
            tos.putArchiveEntry(in);
            tos.write(tmp);
            tos.closeArchiveEntry();
        }
        try (CpioArchiveInputStream tis = new CpioArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            out = tis.getNextCPIOEntry();
        }
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"foo", (Object)out.getName());
        Assertions.assertEquals((long)tmp.length(), (long)out.getSize());
        Assertions.assertEquals((long)(tmp.lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
        Assertions.assertFalse((boolean)out.isDirectory());
    }

    @Test
    void testSymbolicLinkFileEntry() throws Exception {
        CpioArchiveEntry entry;
        File tmp = this.createTempFile();
        File archive = this.createTempFile("test.", ".cpio");
        String name = "EntryName";
        String nameLink = "LinkName";
        Charset charset = StandardCharsets.UTF_8;
        try (CpioArchiveOutputStream tos = new CpioArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            CpioArchiveEntry entry2 = new CpioArchiveEntry("EntryName");
            entry2.setTime(tmp.lastModified() / 1000L);
            entry2.setSize((long)"LinkName".length());
            entry2.setMode(40960L);
            Assertions.assertTrue((boolean)entry2.isSymbolicLink());
            tos.putArchiveEntry(entry2);
            tos.write("LinkName".getBytes(charset));
            tos.closeArchiveEntry();
        }
        try (CpioArchiveInputStream tis = new CpioArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            entry = tis.getNextEntry();
            Assertions.assertEquals((Object)"LinkName", (Object)IOUtils.toString((InputStream)tis, (Charset)charset));
        }
        Assertions.assertNotNull((Object)entry);
        Assertions.assertEquals((Object)"EntryName", (Object)entry.getName());
        Assertions.assertTrue((boolean)entry.isSymbolicLink());
        Assertions.assertEquals((long)"LinkName".length(), (long)entry.getSize());
        Assertions.assertEquals((long)(tmp.lastModified() / 1000L), (long)(entry.getLastModifiedDate().getTime() / 1000L));
        Assertions.assertFalse((boolean)entry.isDirectory());
    }
}

