/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils2.BeanIntrospector;
import org.apache.commons.beanutils2.FluentIntrospectionTestBean;
import org.apache.commons.beanutils2.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils2.PropertyUtilsBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FluentPropertyBeanIntrospectorTest {
    private static Map<String, PropertyDescriptor> createDescriptorMap(PropertyDescriptor[] descs) {
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor pd : descs) {
            map.put(pd.getName(), pd);
        }
        return map;
    }

    private static PropertyDescriptor fetchDescriptor(Map<String, PropertyDescriptor> props, String name) {
        Assertions.assertTrue((boolean)props.containsKey(name), (String)("Property not found: " + name));
        return props.get(name);
    }

    @Test
    public void testInitNoPrefix() {
        Assertions.assertThrows(NullPointerException.class, () -> new FluentPropertyBeanIntrospector(null));
    }

    @Test
    public void testIntrospection() throws IntrospectionException {
        PropertyUtilsBean pu = new PropertyUtilsBean();
        FluentPropertyBeanIntrospector introspector = new FluentPropertyBeanIntrospector();
        pu.addBeanIntrospector((BeanIntrospector)introspector);
        Map<String, PropertyDescriptor> props = FluentPropertyBeanIntrospectorTest.createDescriptorMap(pu.getPropertyDescriptors(FluentIntrospectionTestBean.class));
        PropertyDescriptor pd = FluentPropertyBeanIntrospectorTest.fetchDescriptor(props, "name");
        Assertions.assertNotNull((Object)pd.getReadMethod(), (String)"No read method for name");
        Assertions.assertNotNull((Object)pd.getWriteMethod(), (String)"No write method for name");
        FluentPropertyBeanIntrospectorTest.fetchDescriptor(props, "stringProperty");
        pd = FluentPropertyBeanIntrospectorTest.fetchDescriptor(props, "fluentProperty");
        Assertions.assertNull((Object)pd.getReadMethod(), (String)"Read method for fluentProperty");
        Assertions.assertNotNull((Object)pd.getWriteMethod(), (String)"No write method for fluentProperty");
        pd = FluentPropertyBeanIntrospectorTest.fetchDescriptor(props, "fluentGetProperty");
        Assertions.assertNotNull((Object)pd.getReadMethod(), (String)"No read method for fluentGetProperty");
        Assertions.assertNotNull((Object)pd.getWriteMethod(), (String)"No write method for fluentGetProperty");
    }

    @Test
    public void testIntrospectionCaps() throws Exception {
        PropertyUtilsBean pu = new PropertyUtilsBean();
        FluentPropertyBeanIntrospector introspector = new FluentPropertyBeanIntrospector();
        pu.addBeanIntrospector((BeanIntrospector)introspector);
        Map<String, PropertyDescriptor> props = FluentPropertyBeanIntrospectorTest.createDescriptorMap(pu.getPropertyDescriptors(CapsBean.class));
        PropertyDescriptor aDescriptor = FluentPropertyBeanIntrospectorTest.fetchDescriptor(props, "URI");
        Assertions.assertNotNull((Object)aDescriptor, (String)"missing property");
        Assertions.assertNotNull((Object)aDescriptor.getReadMethod(), (String)"No read method for uri");
        Assertions.assertNotNull((Object)aDescriptor.getWriteMethod(), (String)"No write method for uri");
        Assertions.assertNull((Object)props.get("uRI"), (String)"Should not find mis-capitalized property");
    }

    public static final class CapsBean {
        private URI mURI;

        public URI getURI() {
            return this.mURI;
        }

        public void setURI(URI theURI) {
            this.mURI = theURI;
        }
    }
}

