/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.bugs.other.Jira273BeanFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Jira273TestCase
extends TestCase {
    private final Log log = LogFactory.getLog(Jira273TestCase.class);

    public static void main(String[] args) {
        TestRunner.run((Test)Jira273TestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(Jira273TestCase.class);
    }

    public Jira273TestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIssue_BEANUTILS_273_AnnonymousNotOverriden() {
        Object bean = Jira273BeanFactory.createAnnonymousNotOverriden();
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)bean, (String)"beanValue");
        }
        catch (Throwable t) {
            this.log.error((Object)("AnnonymousNotOverriden: " + t.getMessage()), t);
            Jira273TestCase.fail((String)("AnnonymousNotOverriden Threw exception: " + t));
        }
        Jira273TestCase.assertEquals((Object)"PublicBeanWithMethod", (Object)result);
    }

    public void testIssue_BEANUTILS_273_AnnonymousOverriden() {
        Object bean = Jira273BeanFactory.createAnnonymousOverriden();
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)bean, (String)"beanValue");
        }
        catch (Throwable t) {
            this.log.error((Object)("AnnonymousOverriden: " + t.getMessage()), t);
            Jira273TestCase.fail((String)("AnnonymousOverriden Threw exception: " + t));
        }
        Jira273TestCase.assertEquals((Object)"AnnonymousOverriden", (Object)result);
    }

    public void testIssue_BEANUTILS_273_PrivatePrivatePublicNotOverriden() {
        Object bean = Jira273BeanFactory.createPrivatePrivatePublicNotOverriden();
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)bean, (String)"beanValue");
        }
        catch (Throwable t) {
            this.log.error((Object)("PrivatePrivatePublicNotOverriden: " + t.getMessage()), t);
            Jira273TestCase.fail((String)("PrivatePrivatePublicNotOverriden Threw exception: " + t));
        }
        Jira273TestCase.assertEquals((Object)"PublicBeanWithMethod", (Object)result);
    }

    public void testIssue_BEANUTILS_273_PrivatePrivatePublicOverriden() {
        Object bean = Jira273BeanFactory.createPrivatePrivatePublicOverriden();
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)bean, (String)"beanValue");
        }
        catch (Throwable t) {
            this.log.error((Object)("PrivatePrivatePublicOverriden: " + t.getMessage()), t);
            Jira273TestCase.fail((String)("PrivatePrivatePublicOverriden Threw exception: " + t));
        }
        Jira273TestCase.assertEquals((Object)"PrivatePrivatePublicOverriden", (Object)result);
    }

    public void testIssue_BEANUTILS_273_PrivatePublicNotOverriden() {
        Object bean = Jira273BeanFactory.createPrivatePublicNotOverriden();
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)bean, (String)"beanValue");
        }
        catch (Throwable t) {
            this.log.error((Object)("PrivatePublicNotOverriden: " + t.getMessage()), t);
            Jira273TestCase.fail((String)("PrivatePublicNotOverriden Threw exception: " + t));
        }
        Jira273TestCase.assertEquals((Object)"PublicBeanWithMethod", (Object)result);
    }

    public void testIssue_BEANUTILS_273_PrivatePublicOverriden() {
        Object bean = Jira273BeanFactory.createPrivatePublicOverriden();
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)bean, (String)"beanValue");
        }
        catch (Throwable t) {
            this.log.error((Object)("PrivatePublicOverriden: " + t.getMessage()), t);
            Jira273TestCase.fail((String)("PrivatePublicOverriden Threw exception: " + t));
        }
        Jira273TestCase.assertEquals((Object)"PrivatePublicOverriden", (Object)result);
    }
}

