/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.util.ResourceLoader;

public final class ScopeConfig {
    public static final String SWINGCONTEXT_WINDOW_ICON_PROPERTY = "org.scopemvc.controller.swing.SwingContext.window_icon";
    public static final String SWINGCONTEXT_PROGRESS_START_DELAY_PROPERTY = "org.scopemvc.controller.swing.SwingContext.progress_start_delay";
    public static final String STEXTFIELD_CONTROL_SETTINGS_PROPERTY = "org.scopemvc.view.swing.STextField.control_settings";
    public static final String SPASSWORDFIELD_CONTROL_SETTINGS_PROPERTY = "org.scopemvc.view.swing.SPasswordField.control_settings";
    public static final String STEXTAREA_CONTROL_SETTINGS_PROPERTY = "org.scopemvc.view.swing.STextArea.control_settings";
    public static final String SLABEL_USE_LABELFOR_COMPONENT_ENABLED_STATE_PROPERTY = "org.scopemvc.view.swing.SLabel.use_labelFor_component_enabled_state";
    public static final String VALIDATIONHELPER_VALIDATION_FAILED_COLOR = "org.scopemvc.view.swing.ValidationHelper-validation.failed.color";
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$util$ScopeConfig == null ? (class$org$scopemvc$util$ScopeConfig = ScopeConfig.class$("org.scopemvc.util.ScopeConfig")) : class$org$scopemvc$util$ScopeConfig);
    private static final String DEFAULT_CUSTOM_CONFIG_NAME = "scope";
    private static final String DEFAULT_CONFIG_NAME = "org.scopemvc.util.DefaultScopeConfig";
    private static final String DEFAULT_PROPERTY_PREFIX = "org.scopemvc.";
    private static ScopeConfig instance;
    private HashMap properties = new HashMap();
    static /* synthetic */ Class class$org$scopemvc$util$ScopeConfig;

    private ScopeConfig() {
        this.initialise();
    }

    public static ScopeConfig getInstance() {
        if (instance == null) {
            instance = new ScopeConfig();
        }
        return instance;
    }

    public static String getString(String string) {
        Object v;
        if (LOG.isDebugEnabled()) {
            LOG.debug("getString: " + string + ", result " + ScopeConfig.getProperties().get(string));
        }
        return (v = ScopeConfig.getProperties().get(string)) == null ? null : v.toString();
    }

    public static Object getObject(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getObject: " + string + ", result " + ScopeConfig.getProperties().get(string));
        }
        return ScopeConfig.getProperties().get(string);
    }

    public static char getChar(String string) {
        String string2 = ScopeConfig.getProperties().get(string).toString();
        char c = '\u0000';
        if (string2 == null || string2.length() < 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getChar: no char property for: " + string);
            }
        } else {
            c = string2.charAt(0);
        }
        if (LOG.isErrorEnabled() && string2.length() > 1) {
            LOG.error("Char property for (" + string + ") longer than a single char: " + string2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getChar: " + string + ", result " + c);
        }
        return c;
    }

    public static Class getClass(String string) {
        Object v = ScopeConfig.getProperties().get(string);
        if (v == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getClass: " + string + ", result null");
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getClass: " + string + ", result " + v);
        }
        if (v instanceof Class) {
            return (Class)v;
        }
        if (!(v instanceof String)) {
            throw new IllegalArgumentException("Config property: " + string + " is not a Class or String: " + v.getClass());
        }
        try {
            return Class.forName((String)v);
        }
        catch (Exception exception) {
            LOG.warn("Class not found: " + v + " for property " + string);
            return null;
        }
    }

    public static Integer getInteger(String string) {
        Object v = ScopeConfig.getProperties().get(string);
        if (v == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getInteger: " + string + ", result  null");
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getInteger: " + string + ", result " + v);
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (!(v instanceof String)) {
            throw new IllegalArgumentException("Config property: " + string + " is not an Integer or String: " + v.getClass());
        }
        try {
            return new Integer((String)v);
        }
        catch (Exception exception) {
            LOG.warn("Not an integer value: " + v + " for property " + string);
            return null;
        }
    }

    public static Iterator getKeysMatching(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = ScopeConfig.getProperties().keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            hashSet.add(string2);
        }
        return hashSet.iterator();
    }

    public static void setPropertiesName(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setPropertiesName: " + string);
        }
        if (string == null) {
            throw new IllegalArgumentException("Can't set PropertiesName to null. Pass in a resource name.");
        }
        ResourceBundle resourceBundle = ResourceLoader.getProperties(string);
        if (resourceBundle != null) {
            ScopeConfig.getInstance().putAll(resourceBundle);
        }
        ScopeConfig.getInstance().loadSystemConfig();
    }

    protected static HashMap getProperties() {
        return ScopeConfig.getInstance().properties;
    }

    protected String getDefaultCustomConfigName() {
        return DEFAULT_CUSTOM_CONFIG_NAME;
    }

    protected String getDefaultConfigName() {
        return DEFAULT_CONFIG_NAME;
    }

    protected String getPropertyPrefix() {
        return DEFAULT_PROPERTY_PREFIX;
    }

    protected void initialise() {
        this.loadDefaultConfig();
        this.loadCustomConfig();
        this.loadSystemConfig();
        if (LOG.isDebugEnabled()) {
            LOG.debug("--- Scope properties ---");
            Iterator iterator = this.properties.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = this.properties.get(string);
                LOG.debug(string + " = " + v);
            }
            LOG.debug("------------------------");
        }
    }

    private void loadSystemConfig() {
        block3: {
            try {
                Properties properties = System.getProperties();
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (!string.startsWith(DEFAULT_PROPERTY_PREFIX)) continue;
                    String string2 = properties.getProperty(string);
                    this.properties.put(string, string2);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Override Scope property " + string + " with " + string2);
                }
            }
            catch (SecurityException securityException) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Can't access System properties", securityException);
            }
        }
    }

    private void loadCustomConfig() {
        ResourceBundle resourceBundle = ResourceLoader.getProperties(DEFAULT_CUSTOM_CONFIG_NAME);
        if (resourceBundle != null) {
            this.putAll(resourceBundle);
            LOG.info("Load custom Scope config from scope.properties");
        } else {
            LOG.warn("Can't load custom Scope config from scope.properties");
        }
    }

    private void loadDefaultConfig() {
        ResourceBundle resourceBundle = ResourceLoader.getProperties(DEFAULT_CONFIG_NAME);
        if (resourceBundle != null) {
            this.putAll(resourceBundle);
        } else {
            LOG.error("Can't load default Scope config from: org.scopemvc.util.DefaultScopeConfig");
        }
    }

    private void putAll(ResourceBundle resourceBundle) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Object object = resourceBundle.getObject(string);
            this.properties.put(string, object);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

