/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.GraphUtils;
import org.objectstyle.ashwood.graph.MapDigraph;
import org.objectstyle.ashwood.graph.layout.DigraphLayout;
import org.objectstyle.ashwood.util.Attribute;
import org.objectstyle.ashwood.util.MapAttribute;
import org.objectstyle.ashwood.util.MutableInteger;
import org.objectstyle.ashwood.util.Pair;

public class SugiyamaLayout
extends DigraphLayout {
    private double movePrecision = 1.0;
    private double stepSize = 1.0;
    private int adjustingPassCount = 2;
    private boolean rootsUpwards = true;
    private Map wrapperLevelMap;
    private Map vertexWrapperMap;
    private Map replacementMap = new HashMap();
    private VertexWrapper[][] levels = null;
    private Digraph wrapperDigraph;

    public void doLayout() {
        this.createWrapperDigraph();
        this.wrapperLevelMap = GraphUtils.computeLevels(new HashMap(this.wrapperDigraph.order()), this.wrapperDigraph, true);
        this.splitLongArcs();
        this.createLevels();
        this.minimizeArcIntersections();
        this.minimizeDistancesToBarycentres();
        this.computeGeometry();
    }

    private void createWrapperDigraph() {
        this.wrapperDigraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        this.vertexWrapperMap = new HashMap(this.digraph.order());
        Iterator i = this.digraph.vertexIterator();
        while (i.hasNext()) {
            Object vertex = i.next();
            VertexWrapper wrapper = new VertexWrapper(vertex);
            this.vertexWrapperMap.put(vertex, wrapper);
            this.wrapperDigraph.addVertex(wrapper);
        }
        i = this.digraph.arcIterator();
        while (i.hasNext()) {
            i.next();
            Object wrapper1 = this.vertexWrapperMap.get(i.getOrigin());
            Object wrapper2 = this.vertexWrapperMap.get(i.getDestination());
            if (this.rootsUpwards) {
                this.wrapperDigraph.putArc(wrapper1, wrapper2, Boolean.TRUE);
                continue;
            }
            this.wrapperDigraph.putArc(wrapper2, wrapper1, Boolean.TRUE);
        }
    }

    private void splitLongArcs() {
        Iterator i = this.wrapperDigraph.arcIterator();
        while (i.hasNext()) {
            i.next();
            Object object = i.getOrigin();
            Object dst = i.getDestination();
            int originLevel = this.wrapperLevelMap.get(object).hashCode();
            int dstLevel = this.wrapperLevelMap.get(dst).hashCode();
            int increment = dstLevel - originLevel;
            if (increment == 1) continue;
            Pair splitArc = new Pair(object, dst);
            ArrayList<DummyWrapper> dummyWrappers = new ArrayList<DummyWrapper>(increment - 1);
            for (int j = 1; j < increment; ++j) {
                DummyWrapper dummyWrapper = new DummyWrapper(splitArc, j);
                dummyWrappers.add(dummyWrapper);
                this.wrapperLevelMap.put(dummyWrapper, new MutableInteger(originLevel + j));
            }
            this.replacementMap.put(splitArc, dummyWrappers);
        }
        for (Map.Entry entry : this.replacementMap.entrySet()) {
            Pair splitArc = (Pair)entry.getKey();
            List dummyWrappers = (List)entry.getValue();
            this.wrapperDigraph.removeArc(splitArc.first, splitArc.second);
            Object origin = splitArc.first;
            for (Object dummyVertex : dummyWrappers) {
                this.wrapperDigraph.putArc(origin, dummyVertex, Boolean.TRUE);
                origin = dummyVertex;
            }
            this.wrapperDigraph.putArc(origin, splitArc.second, Boolean.TRUE);
        }
    }

    private void createLevels() {
        int maxLevel = 0;
        HashMap<Number, int[]> levelSizes = new HashMap<Number, int[]>();
        for (Number level : this.wrapperLevelMap.values()) {
            maxLevel = maxLevel >= level.intValue() ? maxLevel : level.intValue();
            int[] levelSize = (int[])levelSizes.get(level);
            if (levelSize == null) {
                levelSizes.put(level, new int[]{1});
                continue;
            }
            levelSize[0] = levelSize[0] + 1;
        }
        this.levels = new VertexWrapper[maxLevel + 1][];
        for (int i = 0; i < this.levels.length; ++i) {
            int levelSize = ((int[])levelSizes.get(new MutableInteger(i)))[0];
            this.levels[i] = new VertexWrapper[levelSize];
        }
        int[][] currentIndexes = new int[this.levels.length][1];
        for (Map.Entry entry : this.wrapperLevelMap.entrySet()) {
            VertexWrapper wrapper;
            int level = entry.getValue().hashCode();
            int[] nArray = currentIndexes[level];
            nArray[0] = nArray[0] + 1;
            this.levels[level][currentIndex] = wrapper = (VertexWrapper)entry.getKey();
        }
    }

    private void minimizeArcIntersections() {
        double distance;
        int k;
        double denominator;
        double numenator;
        int j;
        int i;
        for (i = 0; i < this.levels.length - 1; ++i) {
            for (j = 0; j < this.levels[i + 1].length; ++j) {
                VertexWrapper dst = this.levels[i + 1][j];
                numenator = 0.0;
                denominator = 0.0;
                for (k = 0; k < this.levels[i].length; ++k) {
                    VertexWrapper origin = this.levels[i][k];
                    distance = this.wrapperDigraph.hasArc(origin, dst) ? 1 : 0;
                    numenator += (double)k * distance;
                    denominator += distance;
                }
                dst.setBarycenter(numenator / denominator);
            }
            Arrays.sort(this.levels[i + 1]);
        }
        for (i = this.levels.length - 1; i > 0; --i) {
            for (j = 0; j < this.levels[i - 1].length; ++j) {
                VertexWrapper origin = this.levels[i - 1][j];
                numenator = 0.0;
                denominator = 0.0;
                for (k = 0; k < this.levels[i].length; ++k) {
                    VertexWrapper dst = this.levels[i][k];
                    distance = this.wrapperDigraph.hasArc(origin, dst) ? 1 : 0;
                    numenator += (double)k * distance;
                    denominator += distance;
                }
                origin.setBarycenter(numenator / denominator);
            }
            Arrays.sort(this.levels[i - 1]);
        }
    }

    private void minimizeDistancesToBarycentres() {
        for (int i = 0; i < this.levels.length; ++i) {
            double previousCenterX = this.areaBounds.getMinX() - this.horizontalSpacing;
            double previousWidth = 0.0;
            for (int j = 0; j < this.levels[i].length; ++j) {
                VertexWrapper box = this.levels[i][j];
                box.setCenterX(previousCenterX + this.horizontalSpacing + (previousWidth + box.getWidth()) / 2.0);
                previousCenterX = box.getCenterX();
                previousWidth = box.getWidth();
                box.setUpperConnectivity(this.wrapperDigraph.incomingSize(box));
                box.setLowerConnectivity(this.wrapperDigraph.outgoingSize(box));
            }
        }
        int passCount = Math.min(this.adjustingPassCount, this.levels.length - 1);
        for (int pass = 0; pass < this.adjustingPassCount; ++pass) {
            this.adjustMovingDown(pass + 1);
            this.adjustMovingUp(this.levels.length - 2);
        }
    }

    private void adjustMovingDown(int upperLevel) {
        for (int i = upperLevel; i < this.levels.length; ++i) {
            for (int j = 0; j < this.levels[i].length; ++j) {
                double distanceToBarycenter;
                VertexWrapper box = this.levels[i][j];
                double numenator = 0.0;
                for (int k = 0; k < this.levels[i - 1].length; ++k) {
                    VertexWrapper upperBox = this.levels[i - 1][k];
                    if (!this.wrapperDigraph.hasArc(upperBox, box)) continue;
                    numenator += upperBox.getCenterX();
                }
                box.setUpperBarycenter(numenator / (double)box.getUpperConnectivity());
                int priority = box.getUpperConnectivity();
                if (box.isDummy()) {
                    priority = 0;
                }
                double actualMovementDistance = 0.0;
                while ((actualMovementDistance = (distanceToBarycenter = box.getUpperBarycenter() - box.getCenterX()) > this.movePrecision ? this.adjustVertexWithinLevel(true, false, this.levels[i], j, priority, this.stepSize) : (distanceToBarycenter < -this.movePrecision ? this.adjustVertexWithinLevel(true, true, this.levels[i], j, priority, this.stepSize) : 0.0)) > this.movePrecision) {
                }
            }
        }
    }

    private void adjustMovingUp(int lowerLevel) {
        for (int i = lowerLevel; i >= 0; --i) {
            for (int j = 0; j < this.levels[i].length; ++j) {
                double distanceToBarycenter;
                VertexWrapper box = this.levels[i][j];
                double numenator = 0.0;
                for (int k = 0; k < this.levels[i + 1].length; ++k) {
                    VertexWrapper lowerBox = this.levels[i + 1][k];
                    if (!this.wrapperDigraph.hasArc(box, lowerBox)) continue;
                    numenator += lowerBox.getCenterX();
                }
                box.setLowerBarycenter(numenator / (double)box.getLowerConnectivity());
                int priority = box.getLowerConnectivity();
                if (box.isDummy()) {
                    priority = 0;
                }
                double actualMovementDistance = 0.0;
                while ((actualMovementDistance = (distanceToBarycenter = box.getLowerBarycenter() - box.getCenterX()) > this.movePrecision ? this.adjustVertexWithinLevel(false, false, this.levels[i], j, priority, this.stepSize) : (distanceToBarycenter < -this.movePrecision ? this.adjustVertexWithinLevel(false, true, this.levels[i], j, priority, this.stepSize) : 0.0)) > this.movePrecision) {
                }
            }
        }
    }

    private double adjustVertexWithinLevel(boolean wayDown, boolean toLeft, VertexWrapper[] level, int wrapperIndex, int priority, double wantedDistance) {
        int direction = toLeft ? -1 : 1;
        VertexWrapper box = level[wrapperIndex];
        double centerX = box.getCenterX();
        double width = box.getWidth();
        double possibleDistance = 0.0;
        double actualDistance = 0.0;
        double areaWidth = this.areaBounds.getWidth();
        double areaMinX = this.areaBounds.getMinX();
        if (toLeft && wrapperIndex == 0) {
            possibleDistance = centerX - (areaMinX + width / 2.0);
            actualDistance = Math.min(wantedDistance, possibleDistance);
        } else if (!toLeft && wrapperIndex == level.length - 1) {
            possibleDistance = areaMinX + areaWidth - (centerX + width / 2.0);
            actualDistance = Math.min(wantedDistance, possibleDistance);
        } else {
            int neighborPriority;
            int neighborIndex = wrapperIndex + direction;
            VertexWrapper neighbor = level[neighborIndex];
            int n = neighborPriority = wayDown ? neighbor.getUpperConnectivity() : neighbor.getLowerConnectivity();
            if (neighbor.isDummy()) {
                priority = 0;
            }
            if (wantedDistance <= (possibleDistance = toLeft ? centerX - (neighbor.getCenterX() + this.horizontalSpacing + (neighbor.getWidth() + width) / 2.0) : neighbor.getCenterX() - (centerX + this.horizontalSpacing + (neighbor.getWidth() + width) / 2.0))) {
                actualDistance = wantedDistance;
            } else if (priority <= neighborPriority) {
                actualDistance = possibleDistance;
            } else {
                double askedDistance = wantedDistance - possibleDistance;
                double neighborMovedDistance = this.adjustVertexWithinLevel(wayDown, toLeft, level, neighborIndex, priority, askedDistance);
                actualDistance = possibleDistance + neighborMovedDistance;
            }
        }
        box.setCenterX(centerX + (double)direction * actualDistance);
        return actualDistance;
    }

    private void computeGeometry() {
        double levelY = this.areaBounds.getMinY();
        double areaMaxX = this.areaBounds.getMinX();
        for (int i = 0; i < this.levels.length; ++i) {
            double lowerLevelY = levelY;
            VertexWrapper[] level = this.levels[i];
            for (int j = 0; j < level.length; ++j) {
                lowerLevelY = Math.max(lowerLevelY, level[j].setupVertexShape(levelY));
            }
            double levelMaxX = level[level.length - 1].getCenterX() + level[level.length - 1].getWidth() / 2.0;
            levelY = lowerLevelY + this.verticalSpacing;
            areaMaxX = Math.max(areaMaxX, levelMaxX);
        }
        this.areaBounds.setFrame(this.areaBounds.getMinX(), this.areaBounds.getMinY(), areaMaxX - this.areaBounds.getMinX(), levelY - this.verticalSpacing - this.areaBounds.getMinY());
    }

    private RectangularShape getVertexShape(Object vertex) {
        return (RectangularShape)this.vertexShape.get(vertex);
    }

    public List computeBentArcs() {
        ArrayList<Pair> arcs = new ArrayList<Pair>(this.replacementMap.size());
        for (Map.Entry entry : this.replacementMap.entrySet()) {
            Pair splitArc = (Pair)entry.getKey();
            Object vertex1 = ((VertexWrapper)splitArc.first).getVertex();
            Object vertex2 = ((VertexWrapper)splitArc.second).getVertex();
            Pair vertexPair = this.rootsUpwards ? new Pair(vertex1, vertex2) : new Pair(vertex2, vertex1);
            List dummyWrappers = (List)entry.getValue();
            ArrayList<Point> points = new ArrayList<Point>(dummyWrappers.size());
            for (DummyWrapper dummy : dummyWrappers) {
                points.add(dummy.getBendingPoint());
            }
            arcs.add(new Pair(vertexPair, points));
        }
        return arcs;
    }

    public void setMovePrecision(double movePrecision) {
        this.movePrecision = movePrecision;
    }

    public double getMovePrecision() {
        return this.movePrecision;
    }

    public void setStepSize(double stepSize) {
        this.stepSize = stepSize;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setAdjustingPassCount(int adjustingPassCount) {
        this.adjustingPassCount = adjustingPassCount;
    }

    public int getAdjustingPassCount() {
        return this.adjustingPassCount;
    }

    public void setRootsUpwards(boolean rootsUpwards) {
        this.rootsUpwards = rootsUpwards;
    }

    public boolean isRootsUpwards() {
        return this.rootsUpwards;
    }

    public static void main(String[] args) {
        Digraph digraph = SugiyamaLayout.createDigraph4();
        Rectangle2D.Double vertexRect = new Rectangle2D.Double(0.0, 0.0, 20.0, 15.0);
        Rectangle2D.Double areaBounds = new Rectangle2D.Double(0.0, 0.0, 500.0, 500.0);
        HashMap vertexShapeMap = new HashMap();
        Iterator i = digraph.vertexIterator();
        while (i.hasNext()) {
            Object vertex = i.next();
            vertexShapeMap.put(vertex, vertexRect.clone());
        }
        MapAttribute vertexShape = new MapAttribute(vertexShapeMap);
        double horisontalSpacing = 5.0;
        double verticalSpacing = 5.0;
        int adjustingPassCount = 100;
        double movePrecision = 1.0;
        double stepSize = 1.0;
        boolean rootsUpwards = true;
        SugiyamaLayout layout = new SugiyamaLayout();
        layout.setDigraph(digraph);
        layout.setVertexShape(vertexShape);
        layout.setAreaBounds(areaBounds);
        layout.setAdjustingPassCount(adjustingPassCount);
        layout.setHorizontalSpacing(horisontalSpacing);
        layout.setVerticalSpacing(verticalSpacing);
        layout.setMovePrecision(movePrecision);
        layout.setStepSize(stepSize);
        layout.setRootsUpwards(rootsUpwards);
        layout.doLayout();
        System.out.println("Results:");
        System.out.println("Area: " + layout.getAreaBounds());
        System.out.println("Vertices:");
        Attribute vshape = layout.getVertexShape();
        Iterator i2 = digraph.vertexIterator();
        while (i2.hasNext()) {
            Object vertex = i2.next();
            System.out.println(vertex + ": " + vshape.get(vertex));
        }
        System.out.println("Bye-bye.");
    }

    private static Digraph createDigraph1() {
        MapDigraph digraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        String[] vertices = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "J"};
        digraph.addAllVertices(Arrays.asList(vertices));
        digraph.putArc("D", "A", Boolean.TRUE);
        digraph.putArc("D", "B", Boolean.TRUE);
        digraph.putArc("F", "B", Boolean.TRUE);
        digraph.putArc("G", "C", Boolean.TRUE);
        digraph.putArc("E", "D", Boolean.TRUE);
        digraph.putArc("H", "F", Boolean.TRUE);
        digraph.putArc("F", "G", Boolean.TRUE);
        digraph.putArc("E", "H", Boolean.TRUE);
        digraph.putArc("J", "E", Boolean.TRUE);
        digraph.putArc("J", "H", Boolean.TRUE);
        digraph.putArc("J", "G", Boolean.TRUE);
        return digraph;
    }

    private static Digraph createDigraph2() {
        MapDigraph digraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        String[] vertices = new String[]{"A", "B", "C", "D", "E", "F"};
        digraph.addAllVertices(Arrays.asList(vertices));
        digraph.putArc("A", "B", Boolean.TRUE);
        digraph.putArc("A", "F", Boolean.TRUE);
        digraph.putArc("B", "C", Boolean.TRUE);
        digraph.putArc("F", "D", Boolean.TRUE);
        digraph.putArc("C", "D", Boolean.TRUE);
        digraph.putArc("E", "D", Boolean.TRUE);
        return digraph;
    }

    private static Digraph createDigraph3() {
        MapDigraph digraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        String[] vertices = new String[]{"A", "B", "C", "D", "E", "F"};
        digraph.addAllVertices(Arrays.asList(vertices));
        digraph.putArc("A", "B", Boolean.TRUE);
        digraph.putArc("A", "E", Boolean.TRUE);
        digraph.putArc("B", "F", Boolean.TRUE);
        digraph.putArc("C", "E", Boolean.TRUE);
        digraph.putArc("C", "D", Boolean.TRUE);
        digraph.putArc("E", "D", Boolean.TRUE);
        digraph.putArc("E", "B", Boolean.TRUE);
        digraph.putArc("D", "F", Boolean.TRUE);
        return digraph;
    }

    private static Digraph createDigraph4() {
        MapDigraph digraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        String[] vertices = new String[]{"A", "B", "C", "D", "E"};
        digraph.addAllVertices(Arrays.asList(vertices));
        digraph.putArc("A", "B", Boolean.TRUE);
        digraph.putArc("A", "C", Boolean.TRUE);
        digraph.putArc("B", "D", Boolean.TRUE);
        digraph.putArc("C", "E", Boolean.TRUE);
        return digraph;
    }

    private class DummyWrapper
    extends VertexWrapper {
        private Pair splitArc;
        private int index;
        private Point bendingPoint;

        private DummyWrapper(Pair splitArc, int index) {
            super(null);
            this.splitArc = splitArc;
            this.index = index;
        }

        boolean isDummy() {
            return true;
        }

        double setupVertexShape(double levelY) {
            this.bendingPoint = new Point((int)this.getCenterX(), (int)levelY);
            return levelY;
        }

        Point getBendingPoint() {
            return this.bendingPoint;
        }
    }

    private class VertexWrapper
    implements Comparable {
        private Object vertex;
        private double barycenter;
        private double upperBarycenter;
        private double lowerBarycenter;
        private int upperConnectivity;
        private int lowerConnectivity;
        private double centerX;
        private double width = 0.0;

        private VertexWrapper(Object vertex) {
            this.vertex = vertex;
            if (vertex != null) {
                RectangularShape shape = SugiyamaLayout.this.getVertexShape(vertex);
                this.width = shape != null ? shape.getWidth() : 0.0;
            }
        }

        void setBarycenter(double barycenter) {
            this.barycenter = barycenter;
        }

        void setUpperConnectivity(int upperConnectivity) {
            this.upperConnectivity = upperConnectivity;
        }

        int getUpperConnectivity() {
            return this.upperConnectivity;
        }

        void setLowerConnectivity(int lowerConnectivity) {
            this.lowerConnectivity = lowerConnectivity;
        }

        int getLowerConnectivity() {
            return this.lowerConnectivity;
        }

        void setUpperBarycenter(double upperBarycenter) {
            this.upperBarycenter = upperBarycenter;
        }

        double getUpperBarycenter() {
            return this.upperBarycenter;
        }

        void setLowerBarycenter(double lowerBarycenter) {
            this.lowerBarycenter = lowerBarycenter;
        }

        double getLowerBarycenter() {
            return this.lowerBarycenter;
        }

        void setCenterX(double centerX) {
            this.centerX = centerX;
        }

        double getCenterX() {
            return this.centerX;
        }

        void setWidth(double width) {
            this.width = width;
        }

        double getWidth() {
            return this.width;
        }

        Object getVertex() {
            return this.vertex;
        }

        boolean isDummy() {
            return false;
        }

        public int compareTo(Object o) {
            long rhsBits;
            if (this.barycenter < ((VertexWrapper)o).barycenter) {
                return -1;
            }
            if (this.barycenter > ((VertexWrapper)o).barycenter) {
                return 1;
            }
            long lhsBits = Double.doubleToLongBits(this.barycenter);
            if (lhsBits == (rhsBits = Double.doubleToLongBits(((VertexWrapper)o).barycenter))) {
                return 0;
            }
            if (lhsBits < rhsBits) {
                return -1;
            }
            return 1;
        }

        double setupVertexShape(double levelY) {
            if (this.vertex == null) {
                return levelY;
            }
            RectangularShape shape = SugiyamaLayout.this.getVertexShape(this.vertex);
            double height = shape.getHeight();
            shape.setFrame(this.centerX - this.width / 2.0, levelY, this.width, height);
            return levelY + height;
        }
    }
}

