/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.types.AbstractType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultType
extends AbstractType {
    private static final Map<String, Method> readMethods = new HashMap<String, Method>();
    private static final Map<String, Method> procReadMethods = new HashMap<String, Method>();
    private static Method readObjectMethod;
    private static Method procReadObjectMethod;
    protected String className;
    protected Method readMethod;
    protected Method procReadMethod;

    public static Iterator<String> defaultTypes() {
        return readMethods.keySet().iterator();
    }

    public DefaultType() {
        this.className = Object.class.getName();
        this.readMethod = readObjectMethod;
        this.procReadMethod = procReadObjectMethod;
    }

    public DefaultType(String className) {
        this.className = className;
        this.readMethod = readMethods.get(className);
        if (this.readMethod == null) {
            throw new CayenneRuntimeException("Unsupported default class: " + className + ". If you want a non-standard class to map to JDBC type," + " you will need to implement ExtendedType interface yourself.");
        }
        this.procReadMethod = procReadMethods.get(className);
        if (this.procReadMethod == null) {
            throw new CayenneRuntimeException("Unsupported default class: " + className + ". If you want a non-standard class to map to JDBC type," + " you will need to implement ExtendedType interface yourself.");
        }
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        Object val = this.readMethod.invoke((Object)rs, index);
        return rs.wasNull() ? null : val;
    }

    @Override
    public Object materializeObject(CallableStatement st, int index, int type) throws Exception {
        Object val = this.procReadMethod.invoke((Object)st, index);
        return st.wasNull() ? null : val;
    }

    static {
        try {
            Class<ResultSet> rsClass = ResultSet.class;
            Class[] paramTypes = new Class[]{Integer.TYPE};
            readMethods.put("java.lang.Long", rsClass.getMethod("getLong", paramTypes));
            readMethods.put("java.math.BigDecimal", rsClass.getMethod("getBigDecimal", paramTypes));
            readMethods.put("java.lang.Boolean", rsClass.getMethod("getBoolean", paramTypes));
            readMethods.put("java.lang.Byte", rsClass.getMethod("getByte", paramTypes));
            readMethods.put("byte[]", rsClass.getMethod("getBytes", paramTypes));
            readMethods.put("java.sql.Date", rsClass.getMethod("getDate", paramTypes));
            readMethods.put("java.lang.Double", rsClass.getMethod("getDouble", paramTypes));
            readMethods.put("java.lang.Float", rsClass.getMethod("getFloat", paramTypes));
            readMethods.put("java.lang.Integer", rsClass.getMethod("getInt", paramTypes));
            readMethods.put("java.lang.Short", rsClass.getMethod("getShort", paramTypes));
            readMethods.put("java.lang.String", rsClass.getMethod("getString", paramTypes));
            readMethods.put("java.sql.Time", rsClass.getMethod("getTime", paramTypes));
            readMethods.put("java.sql.Timestamp", rsClass.getMethod("getTimestamp", paramTypes));
            readMethods.put("java.sql.Blob", rsClass.getMethod("getBlob", paramTypes));
            readObjectMethod = rsClass.getMethod("getObject", paramTypes);
            Class<CallableStatement> csClass = CallableStatement.class;
            procReadMethods.put("java.lang.Long", csClass.getMethod("getLong", paramTypes));
            procReadMethods.put("java.math.BigDecimal", csClass.getMethod("getBigDecimal", paramTypes));
            procReadMethods.put("java.lang.Boolean", csClass.getMethod("getBoolean", paramTypes));
            procReadMethods.put("java.lang.Byte", csClass.getMethod("getByte", paramTypes));
            procReadMethods.put("byte[]", csClass.getMethod("getBytes", paramTypes));
            procReadMethods.put("java.sql.Date", csClass.getMethod("getDate", paramTypes));
            procReadMethods.put("java.lang.Double", csClass.getMethod("getDouble", paramTypes));
            procReadMethods.put("java.lang.Float", csClass.getMethod("getFloat", paramTypes));
            procReadMethods.put("java.lang.Integer", csClass.getMethod("getInt", paramTypes));
            procReadMethods.put("java.lang.Short", csClass.getMethod("getShort", paramTypes));
            procReadMethods.put("java.lang.String", csClass.getMethod("getString", paramTypes));
            procReadMethods.put("java.sql.Time", csClass.getMethod("getTime", paramTypes));
            procReadMethods.put("java.sql.Timestamp", csClass.getMethod("getTimestamp", paramTypes));
            procReadMethods.put("java.sql.Blob", csClass.getMethod("getBlob", paramTypes));
            procReadObjectMethod = csClass.getMethod("getObject", paramTypes);
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error initializing read methods.", ex);
        }
    }
}

