/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.action.NewProjectAction;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.ApplicationProject;
import org.apache.cayenne.project.Project;

public class RevertAction
extends CayenneAction {
    public static String getActionName() {
        return "Revert";
    }

    public RevertAction(Application application) {
        super(RevertAction.getActionName(), application);
    }

    public void performAction(ActionEvent e) {
        Project project = this.getCurrentProject();
        if (project == null) {
            return;
        }
        boolean isNew = project.isLocationUndefined();
        CayenneModelerController controller = this.getApplication().getFrameController();
        controller.projectClosedAction();
        if (!isNew && project.getMainFile().isFile()) {
            OpenProjectAction openAction = (OpenProjectAction)controller.getApplication().getAction(OpenProjectAction.getActionName());
            openAction.openProject(project.getMainFile());
        } else {
            if (!(project instanceof ApplicationProject)) {
                throw new CayenneRuntimeException("Only ApplicationProjects are supported.");
            }
            controller.getApplication().getAction(NewProjectAction.getActionName()).performAction(e);
        }
        this.application.getUndoManager().discardAllEdits();
    }
}

