/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.Util;

public class ProcedureQueryValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath treeNodePath, Validator validator) {
        ProcedureQuery query = (ProcedureQuery)treeNodePath.getObject();
        this.validateName(query, treeNodePath, validator);
        this.validateRoot(query, treeNodePath, validator);
    }

    protected void validateRoot(ProcedureQuery query, ProjectPath path, Validator validator) {
        DataMap map = path.firstInstanceOf(DataMap.class);
        Object root = query.getRoot();
        if (root == null && map != null) {
            validator.registerWarning("Query has no root", path);
        }
        if (root instanceof Procedure) {
            Procedure procedure = (Procedure)root;
            if (map != null && map.getProcedure(procedure.getName()) != procedure) {
                validator.registerWarning("Invalid Procedure Root - " + procedure.getName(), path);
            }
            return;
        }
        if (root instanceof String && map != null && map.getProcedure(root.toString()) == null) {
            validator.registerWarning("Invalid Procedure Root - " + root, path);
        }
    }

    protected void validateName(Query query, ProjectPath path, Validator validator) {
        String name = query.getName();
        if (Util.isEmptyString(name)) {
            validator.registerError("Unnamed Query.", path);
            return;
        }
        DataMap map = (DataMap)path.getObjectParent();
        if (map == null) {
            return;
        }
        for (Query otherQuery : map.getQueries()) {
            if (otherQuery == query || !name.equals(otherQuery.getName())) continue;
            validator.registerError("Duplicate Query name: " + name + ".", path);
            break;
        }
    }
}

