/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.util.Util;

public class DbEntityValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        DbEntity ent = (DbEntity)path.getObject();
        this.validateName(ent, path, validator);
        this.validateAttributes(ent, path, validator);
        this.validatePK(ent, path, validator);
    }

    protected void validatePK(DbEntity ent, ProjectPath path, Validator validator) {
        DataMap map;
        if (ent.getAttributes().size() > 0 && ent.getPrimaryKeys().size() == 0 && (map = ent.getDataMap()) != null && map.getMappedEntities(ent).size() > 0) {
            validator.registerWarning("DbEntity \"" + ent.getName() + "\" has no primary key attributes defined.", path);
        }
    }

    protected void validateAttributes(DbEntity ent, ProjectPath path, Validator validator) {
        if (ent.getAttributes().size() == 0) {
            validator.registerWarning("DbEntity \"" + ent.getName() + "\" has no attributes defined.", path);
        }
    }

    protected void validateName(DbEntity ent, ProjectPath path, Validator validator) {
        String name = ent.getName();
        if (Util.isEmptyString(name)) {
            validator.registerError("Unnamed DbEntity.", path);
            return;
        }
        DataMap map = (DataMap)path.getObjectParent();
        if (map == null) {
            return;
        }
        for (DbEntity otherEnt : map.getDbEntities()) {
            if (otherEnt == ent || !name.equals(otherEnt.getName())) continue;
            validator.registerError("Duplicate DbEntity name: " + name + ".", path);
            break;
        }
    }
}

