/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.File;

public class CayenneUserDir {
    protected static CayenneUserDir sharedInstance;
    public static final String CAYENNE_DIR = ".cayenne";
    public static final String ALT_USER_DIR_PROPERTY = "cayenne.userdir";
    protected File cayenneUserDir;

    public static CayenneUserDir getInstance() {
        if (sharedInstance == null) {
            sharedInstance = new CayenneUserDir();
        }
        return sharedInstance;
    }

    protected CayenneUserDir() {
        File tmpDir = null;
        String dirName = System.getProperty(ALT_USER_DIR_PROPERTY);
        if (dirName != null) {
            tmpDir = new File(dirName);
        } else {
            File homeDir = new File(System.getProperty("user.home"));
            tmpDir = new File(homeDir, CAYENNE_DIR);
        }
        if (tmpDir.exists() && !tmpDir.isDirectory()) {
            tmpDir = null;
        } else if (tmpDir.exists() && !tmpDir.canRead()) {
            tmpDir = null;
        } else if (!tmpDir.exists()) {
            tmpDir.mkdirs();
            if (!tmpDir.exists()) {
                tmpDir = null;
            }
        }
        this.cayenneUserDir = tmpDir;
    }

    public File getDirectory() {
        return this.cayenneUserDir;
    }

    public boolean canRead() {
        return this.cayenneUserDir != null;
    }

    public boolean canWrite() {
        return this.cayenneUserDir != null && this.cayenneUserDir.canWrite();
    }

    public File resolveFile(String name) {
        return new File(this.cayenneUserDir, name);
    }
}

