/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.sql.DataSource;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.access.ConnectionLogger;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.conf.AbstractHandler;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DataSourceFactory;
import org.apache.cayenne.conf.PasswordEncoding;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.conn.PoolManager;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DriverDataSourceFactory
implements DataSourceFactory {
    private static final Log logger = LogFactory.getLog(DriverDataSourceFactory.class);
    protected XMLReader parser = Util.createXmlReader();
    protected DataSourceInfo driverInfo;
    protected Configuration parentConfiguration;

    public void initializeWithParentConfiguration(Configuration parentConfiguration) {
        this.parentConfiguration = parentConfiguration;
    }

    public DataSource getDataSource(String location) throws Exception {
        this.load(location);
        ConnectionLogger logger = new ConnectionLogger();
        try {
            return new PoolManager(this.driverInfo.getJdbcDriver(), this.driverInfo.getDataSourceUrl(), this.driverInfo.getMinConnections(), this.driverInfo.getMaxConnections(), this.driverInfo.getUserName(), this.driverInfo.getPassword(), logger);
        }
        catch (Exception ex) {
            QueryLogger.logConnectFailure(ex);
            throw ex;
        }
    }

    protected DataSourceInfo getDriverInfo() {
        return this.driverInfo;
    }

    protected InputStream getInputStream(String location) {
        if (this.parentConfiguration == null) {
            throw new ConfigurationException("No parent Configuration set - cannot continue.");
        }
        URL url = this.parentConfiguration.getResourceFinder().getResource(location);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading URL " + url, e);
        }
    }

    protected void load(String location) throws Exception {
        logger.info((Object)("loading driver information from '" + location + "'."));
        InputStream in = this.getInputStream(location);
        if (in == null) {
            logger.info((Object)("Error: location '" + location + "' not found."));
            throw new ConfigurationException("Can't find DataSource configuration file at " + location);
        }
        RootHandler handler = new RootHandler();
        this.parser.setContentHandler(handler);
        this.parser.setErrorHandler(handler);
        this.parser.parse(new InputSource(in));
    }

    private class ConnectionHandler
    extends AbstractHandler {
        public ConnectionHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void init(String name, Attributes atts, DataSourceInfo driverInfo) throws SAXException {
            try {
                String max;
                String min = atts.getValue("min");
                if (min != null) {
                    driverInfo.setMinConnections(Integer.parseInt(min));
                }
                if ((max = atts.getValue("max")) != null) {
                    driverInfo.setMaxConnections(Integer.parseInt(max));
                }
            }
            catch (NumberFormatException nfex) {
                logger.info((Object)"Error loading numeric attribute", (Throwable)nfex);
                throw new SAXException("Error reading numeric attribute.", nfex);
            }
        }
    }

    private class LoginHandler
    extends AbstractHandler {
        public LoginHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String passwordFromInputStream(InputStream inputStream) {
            BufferedReader bufferedReader = null;
            InputStreamReader inputStreamReader = null;
            String password = null;
            try {
                inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                password = bufferedReader.readLine();
            }
            catch (IOException exception) {
                logger.warn((Object)exception);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (inputStreamReader != null) {
                        inputStreamReader.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    inputStream.close();
                }
                catch (IOException exception) {}
            }
            return password;
        }

        private String passwordFromURL(URL url) {
            InputStream inputStream = null;
            String password = null;
            try {
                inputStream = url.openStream();
                password = this.passwordFromInputStream(inputStream);
            }
            catch (IOException exception) {
                logger.warn((Object)exception);
            }
            return password;
        }

        public void init(String name, Attributes atts, DataSourceInfo driverInfo) {
            logger.info((Object)"loading user name and password.");
            String encoderClass = atts.getValue("encoderClass");
            String encoderKey = atts.getValue("encoderKey") == null ? atts.getValue("encoderSalt") : atts.getValue("encoderKey");
            String password = atts.getValue("password");
            String passwordLocation = atts.getValue("passwordLocation");
            String passwordSource = atts.getValue("passwordSource");
            if (passwordSource == null) {
                passwordSource = "model";
            }
            String username = atts.getValue("userName");
            driverInfo.setPasswordEncoderClass(encoderClass);
            driverInfo.setPasswordEncoderKey(encoderKey);
            driverInfo.setPasswordLocation(passwordLocation);
            driverInfo.setPasswordSource(passwordSource);
            driverInfo.setUserName(username);
            if (encoderKey != null) {
                passwordSource = passwordSource.replaceAll("\\{\\}", encoderKey);
            }
            PasswordEncoding passwordEncoder = driverInfo.getPasswordEncoder();
            if (passwordLocation != null) {
                if (passwordLocation.equals("classpath")) {
                    URL url = DriverDataSourceFactory.this.parentConfiguration.getResourceFinder().getResource(passwordLocation);
                    if (url != null) {
                        password = this.passwordFromURL(url);
                    } else {
                        logger.error((Object)("Could not find resource in CLASSPATH: " + passwordSource));
                    }
                } else if (passwordLocation.equals("url")) {
                    try {
                        password = this.passwordFromURL(new URL(passwordSource));
                    }
                    catch (MalformedURLException exception) {
                        logger.warn((Object)exception);
                    }
                } else if (passwordLocation.equals("executable") && passwordSource != null) {
                    try {
                        Process process = Runtime.getRuntime().exec(passwordSource);
                        password = this.passwordFromInputStream(process.getInputStream());
                        process.waitFor();
                    }
                    catch (IOException exception) {
                        logger.warn((Object)exception);
                    }
                    catch (InterruptedException exception) {
                        logger.warn((Object)exception);
                    }
                }
            }
            if (password != null && passwordEncoder != null) {
                driverInfo.setPassword(passwordEncoder.decodePassword(password, encoderKey));
            }
        }
    }

    private class UrlHandler
    extends AbstractHandler {
        public UrlHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void init(String name, Attributes atts, DataSourceInfo driverInfo) throws SAXException {
            driverInfo.setDataSourceUrl(atts.getValue("value"));
            if (driverInfo.getDataSourceUrl() == null) {
                logger.info((Object)"error: <url> has no 'value'.");
                throw new SAXException("'<url value=' attribute is required.");
            }
        }
    }

    private class DriverHandler
    extends AbstractHandler {
        public DriverHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void init(String name, Attributes attrs) {
            String className = attrs.getValue("", "class");
            logger.info((Object)("loading driver " + className));
            DriverDataSourceFactory.this.driverInfo = new DataSourceInfo();
            DriverDataSourceFactory.this.driverInfo.setJdbcDriver(className);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("login")) {
                new LoginHandler(this.parser, this).init(localName, atts, DriverDataSourceFactory.this.driverInfo);
            } else if (localName.equals("url")) {
                new UrlHandler(this.parser, this).init(localName, atts, DriverDataSourceFactory.this.driverInfo);
            } else if (localName.equals("connectionPool")) {
                new ConnectionHandler(this.parser, this).init(localName, atts, DriverDataSourceFactory.this.driverInfo);
            } else {
                logger.info((Object)("<login, url, connectionPool> are valid. <" + localName + "> is unexpected."));
                throw new SAXException("Config file is not of expected XML type");
            }
        }
    }

    private class RootHandler
    extends DefaultHandler {
        private RootHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (!localName.equals("driver")) {
                logger.info((Object)("<driver> must be the root element. <" + localName + "> is unexpected."));
                throw new SAXException("Config file is not of expected XML type. '" + localName + "' unexpected.");
            }
            new DriverHandler(DriverDataSourceFactory.this.parser, this).init(localName, atts);
        }
    }
}

