/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.io.InputStream;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.conf.ConfigLoader;
import org.apache.cayenne.conf.ConfigLoaderDelegate;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.ResourceFinder;
import org.apache.cayenne.conf.RuntimeLoadDelegate;
import org.apache.cayenne.util.ResourceLocator;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultConfiguration
extends Configuration {
    private static Log logger = LogFactory.getLog(DefaultConfiguration.class);
    protected ResourceLocator locator;

    public DefaultConfiguration() {
        this("cayenne.xml");
    }

    public DefaultConfiguration(String domainConfigurationName) {
        super(domainConfigurationName);
        if (domainConfigurationName == null) {
            throw new ConfigurationException("cannot use null as domain file name.");
        }
        logger.debug((Object)("using domain file name: " + domainConfigurationName));
        ResourceLocator locator = new ResourceLocator();
        locator.setSkipAbsolutePath(true);
        locator.setSkipClasspath(false);
        locator.setSkipCurrentDirectory(true);
        locator.setSkipHomeDirectory(true);
        if (!this.getClass().equals(DefaultConfiguration.class)) {
            locator.addClassPath(Util.getPackagePath(this.getClass().getName()));
        }
        this.setResourceLocator(locator);
    }

    public DefaultConfiguration(String domainConfigurationName, ResourceLocator locator) {
        super(domainConfigurationName);
        this.setResourceLocator(locator);
    }

    public void addClassPath(String customPath) {
        this.locator.addClassPath(customPath);
    }

    public void addResourcePath(String path) {
        this.locator.addFilesystemPath(path);
    }

    protected InputStream getDomainConfiguration() {
        return super.getDomainConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        logger.debug((Object)"initialize starting.");
        InputStream in = this.getDomainConfiguration();
        if (in == null) {
            StringBuilder msg = new StringBuilder();
            msg.append("[").append(this.getClass().getName()).append("] : Domain configuration file \"").append(this.getDomainConfigurationName()).append("\" is not found.");
            throw new ConfigurationException(msg.toString());
        }
        ConfigLoaderDelegate delegate = this.getLoaderDelegate();
        if (delegate == null) {
            delegate = new RuntimeLoadDelegate(this, this.getLoadStatus());
        }
        ConfigLoader loader = new ConfigLoader(delegate);
        try {
            loader.loadDomains(in);
        }
        finally {
            this.setLoadStatus(delegate.getStatus());
            in.close();
        }
        logger.debug((Object)"initialize finished.");
    }

    protected ResourceLocator getResourceLocator() {
        return this.locator;
    }

    protected ResourceFinder getResourceFinder() {
        return this.locator;
    }

    protected void setResourceLocator(ResourceLocator locator) {
        this.locator = locator;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(this.getClass().getName()).append(": classloader=").append(this.locator.getClassLoader()).append(']');
        return buf.toString();
    }
}

