/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.modeler.dialog.objentity.DbRelationshipTargetDialog;
import org.apache.cayenne.modeler.dialog.objentity.DbRelationshipTargetModel;
import org.scopemvc.controller.basic.BasicController;
import org.scopemvc.core.Control;
import org.scopemvc.core.ControlException;

public class DbRelationshipTargetController
extends BasicController {
    public static final String CONTINUE_CONTROL = "cayenne.modeler.mapObjRelationship.continue.button";
    public static final String CANCEL_CONTROL = "cayenne.modeler.mapObjRelationship.cancel.button";
    public static final String TOMANY_CONTROL = "cayenne.modeler.mapObjRelationship.tomany.checkbox";
    public static final String SOURCE1_CONTROL = "cayenne.modeler.mapObjRelationship.source1.button";
    public static final String SOURCE2_CONTROL = "cayenne.modeler.mapObjRelationship.source2.button";
    DbEntity source1;
    DbEntity source2;
    boolean savePressed;

    public DbRelationshipTargetController(DbEntity source1, DbEntity source2) {
        this.source1 = source1;
        this.source2 = source2;
        DbRelationshipTargetModel model = new DbRelationshipTargetModel(source1, source2);
        this.setModel(model);
    }

    protected void doHandleControl(Control control) throws ControlException {
        if (control.matchesID(CANCEL_CONTROL)) {
            this.shutdown();
        } else if (control.matchesID(CONTINUE_CONTROL)) {
            this.save();
        }
    }

    protected void save() {
        DbRelationshipTargetModel model = (DbRelationshipTargetModel)this.getModel();
        DbEntity target = model.getTarget();
        if (target == null) {
            JOptionPane.showMessageDialog((Component)((Object)this.getView()), "Please select target entity first.", "Warning", 2);
            return;
        }
        this.savePressed = true;
        this.shutdown();
    }

    public void startup() {
        DbRelationshipTargetDialog view = new DbRelationshipTargetDialog(this.source1, this.source2);
        this.setView(view);
        view.getSource1Button().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DbRelationshipTargetModel)DbRelationshipTargetController.this.getModel()).setSource(DbRelationshipTargetController.this.source1, true);
            }
        });
        view.getSource2Button().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DbRelationshipTargetModel)DbRelationshipTargetController.this.getModel()).setSource(DbRelationshipTargetController.this.source2, false);
            }
        });
        view.getSource1Button().setSelected(true);
        ((DbRelationshipTargetModel)this.getModel()).setSource(this.source1, true);
        super.startup();
    }

    boolean isSavePressed() {
        return this.savePressed;
    }
}

