/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.generic;

import org.apache.cayenne.DataObject;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.FaultFactory;
import org.apache.cayenne.reflect.PersistentDescriptor;
import org.apache.cayenne.reflect.PersistentDescriptorFactory;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.generic.DataObjectAccessor;
import org.apache.cayenne.reflect.generic.DataObjectAttributeProperty;
import org.apache.cayenne.reflect.generic.DataObjectDescriptor;
import org.apache.cayenne.reflect.generic.DataObjectToManyMapProperty;
import org.apache.cayenne.reflect.generic.DataObjectToManyProperty;
import org.apache.cayenne.reflect.generic.DataObjectToOneProperty;
import org.apache.cayenne.reflect.generic.ValueComparisonStrategyFactory;

public class DataObjectDescriptorFactory
extends PersistentDescriptorFactory {
    protected FaultFactory faultFactory;
    protected ValueComparisonStrategyFactory valueComparisonStrategyFactory;

    public DataObjectDescriptorFactory(ClassDescriptorMap descriptorMap, FaultFactory faultFactory, ValueComparisonStrategyFactory valueComparisonStrategyFactory) {
        super(descriptorMap);
        this.faultFactory = faultFactory;
        this.valueComparisonStrategyFactory = valueComparisonStrategyFactory;
    }

    @Override
    protected ClassDescriptor getDescriptor(ObjEntity entity, Class<?> entityClass) {
        if (!DataObject.class.isAssignableFrom(entityClass)) {
            return null;
        }
        return super.getDescriptor(entity, entityClass);
    }

    @Override
    protected PersistentDescriptor createDescriptor() {
        return new DataObjectDescriptor();
    }

    @Override
    protected void createAttributeProperty(PersistentDescriptor descriptor, ObjAttribute attribute) {
        DataObjectAttributeProperty property = new DataObjectAttributeProperty(attribute, this.valueComparisonStrategyFactory.getStrategy(attribute));
        descriptor.addDeclaredProperty(property);
    }

    @Override
    protected void createToManyListProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        descriptor.addDeclaredProperty(new DataObjectToManyProperty(relationship, targetDescriptor, this.faultFactory.getListFault()));
    }

    @Override
    protected void createToManyMapProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        Accessor mapKeyAccessor = this.createMapKeyAccessor(relationship, targetDescriptor);
        descriptor.addDeclaredProperty(new DataObjectToManyMapProperty(relationship, targetDescriptor, this.faultFactory.getMapFault(mapKeyAccessor), mapKeyAccessor));
    }

    @Override
    protected void createToManySetProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        descriptor.addDeclaredProperty(new DataObjectToManyProperty(relationship, targetDescriptor, this.faultFactory.getSetFault()));
    }

    @Override
    protected void createToManyCollectionProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        descriptor.addDeclaredProperty(new DataObjectToManyProperty(relationship, targetDescriptor, this.faultFactory.getCollectionFault()));
    }

    @Override
    protected void createToOneProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        descriptor.addDeclaredProperty(new DataObjectToOneProperty(relationship, targetDescriptor, this.faultFactory.getToOneFault()));
    }

    @Override
    protected Accessor createAccessor(PersistentDescriptor descriptor, String propertyName, Class<?> propertyType) throws PropertyException {
        return new DataObjectAccessor(propertyName);
    }
}

